/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.commonUI;

import java.io.IOException;
import jetbrains.charisma.commonUI.StaticResource;
import jetbrains.springframework.configuration.runtime.MyPathMatchingResourcePatternResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class FrontendPathUtil {
    protected static Log log = LogFactory.getLog(FrontendPathUtil.class);

    public static StaticResource staticResource(String pattern) throws RuntimeException {
        try {
            return new StaticResource(FrontendPathUtil.findResource(pattern).getFilename());
        }
        catch (Exception ioe) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(pattern + " cannot be loaded " + ioe.getMessage()));
            }
            return null;
        }
    }

    public static Resource findResource(String pattern) throws IOException {
        Resource[] resources;
        ClassLoader parent = FrontendPathUtil.class.getClassLoader();
        MyPathMatchingResourcePatternResolver resourcePatternResolver = new MyPathMatchingResourcePatternResolver((ResourceLoader)new DefaultResourceLoader(parent));
        for (Resource resource : resources = resourcePatternResolver.getResources("**/*.js")) {
            if (!resource.getFilename().contains(pattern)) continue;
            return resource;
        }
        throw new IllegalStateException("Resource not found " + pattern);
    }
}

