/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.links.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import java.util.Collections;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeUtil;
import jetbrains.charisma.links.persistent.LegacyIssueLinkHistory;
import jetbrains.charisma.links.persistent.Link;
import jetbrains.charisma.links.persistent.ModernIssueLinkHistory;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;

public abstract class IssueLinkHistory {
    private static final ModernIssueLinkHistory MODERN_ISSUE_LINK_HISTORY = new ModernIssueLinkHistory();
    private static final LegacyIssueLinkHistory LEGACY_ISSUE_LINK_HISTORY = new LegacyIssueLinkHistory();

    public Iterable<Link> getRemoved(Entity currentIssue, Entity prevIssue, Entity nextIssue) {
        return this.getAccessibleNonDraftLinksExcepting(currentIssue, prevIssue, nextIssue);
    }

    public Iterable<Link> getAdded(Entity currentIssue, Entity prevIssue, Entity nextIssue) {
        return this.getAccessibleNonDraftLinksExcepting(currentIssue, nextIssue, prevIssue);
    }

    protected abstract Iterable<Link> getAccessibleNonDraftLinksExcepting(Entity var1, Entity var2, Entity var3);

    public static Iterable<Link> getRemovedLinks(Entity currentIssue, Entity prevIssue, Entity nextIssue) {
        if (IssueLinkHistory.matchesRefactoringMoment(prevIssue, nextIssue)) {
            return Sequence.fromIterable(Collections.emptyList());
        }
        return Sequence.fromIterable(LEGACY_ISSUE_LINK_HISTORY.getRemoved(currentIssue, prevIssue, nextIssue)).concat(Sequence.fromIterable(MODERN_ISSUE_LINK_HISTORY.getRemoved(currentIssue, prevIssue, nextIssue)));
    }

    public static Iterable<Link> getAddedLinks(Entity currentIssue, Entity prevIssue, Entity nextIssue) {
        if (IssueLinkHistory.matchesRefactoringMoment(prevIssue, nextIssue)) {
            return Sequence.fromIterable(Collections.emptyList());
        }
        return Sequence.fromIterable(LEGACY_ISSUE_LINK_HISTORY.getAdded(currentIssue, prevIssue, nextIssue)).concat(Sequence.fromIterable(MODERN_ISSUE_LINK_HISTORY.getAdded(currentIssue, prevIssue, nextIssue)));
    }

    public static boolean matchesRefactoringMoment(Entity v1, Entity v2) {
        if (Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)v1, (String)"issueLinks2")).isNotEmpty() && !QueryOperations.isEmpty(IssueLinkPrototypeUtil.getAllLinkedIssues(v2))) {
            return true;
        }
        return Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)v2, (String)"issueLinks2")).isNotEmpty() && !QueryOperations.isEmpty(IssueLinkPrototypeUtil.getAllLinkedIssues(v1));
    }
}

