/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.links.persistent;

import jetbrains.exodus.entitystore.Entity;
import org.apache.commons.lang.StringUtils;

public abstract class Link {
    private boolean myOutward;
    private Entity myFrom;
    private Entity myTo;

    public Link(Entity from, Entity to, boolean outward) {
        this.setOutward(outward);
        this.setFrom(from);
        this.setTo(to);
    }

    public abstract void unlink();

    public abstract String getId();

    public abstract String getLinkTypeName();

    public abstract String getLinkOutwardRole();

    public abstract String getLinkInwardRole();

    public boolean getOutward() {
        return this.myOutward;
    }

    private void setOutward(boolean value) {
        this.myOutward = value;
    }

    public Entity getFrom() {
        return this.myFrom;
    }

    private void setFrom(Entity value) {
        this.myFrom = value;
    }

    public Entity getTo() {
        return this.myTo;
    }

    private void setTo(Entity value) {
        this.myTo = value;
    }

    public String getRole() {
        return this.getOutward() ? this.getLinkOutwardRole() : this.getLinkInwardRole();
    }

    public String getCapitalizedRole() {
        return StringUtils.capitalize((String)this.getRole());
    }

    public Entity getLinkSource() {
        return this.getOutward() ? this.getFrom() : this.getTo();
    }

    public Entity getLinkTarget() {
        return this.getOutward() ? this.getTo() : this.getFrom();
    }
}

