/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import jetbrains.charisma.main.CharismaLicenseCheckerContainer;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.main.ReleaseDateManager;
import jetbrains.charisma.persistent.DiskSpaceManagement;
import jetbrains.charisma.persistent.LicenseHistoryImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeArithmetics;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.ring.license.LicenseFlag;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.teamsys.license.runtime.InvalidLicenseException;
import jetbrains.teamsys.license.runtime.LicenseChecker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Period;
import webr.framework.controller.CentralManager;

public class CharismaLicenseChecker
extends LicenseChecker {
    private static final BigInteger n = new BigInteger("263209838529653741309366162078767955401650210060093940479440536241110980313794956537153327107041219371342779419863684554849202277263853757273750327567871802106538309185809561001712198328099404198770096988081455939118836298393133358550417396551205893870871649995935725104508543665608276612812277299875371100701");
    private static final int MB = 0x100000;
    private static final int expectedProtuctType = 0;
    private static final int expectedProductMinorVersion = 0;
    private static final int BROADCAST_INT = Integer.MAX_VALUE;
    private static final int EAP_BUILD_NUMBER = 1000000;
    private static final int BETA_BUILD_NUMBER = 1000001;
    private static final int RC_BUILD_NUMBER = 1000002;
    private static final Period DEFAULT_FREE_UPGRADE_PERIOD = Period.years((int)1);
    public static final long MIN_REQUIRED_PERM_GEN = 0x8000000L;
    public static final long PERM_GEN;
    protected static Log log;
    private final int userCount;
    private final long issueCount;
    private final int projectCount;
    private final int diskSpace;
    private final long flags;
    private final short freeUpgradeDays;
    private final Long freeUpgradeEnd;

    CharismaLicenseChecker() throws GeneralSecurityException {
        this(CharismaLicenseChecker.getNullSafeUsername(), CharismaLicenseChecker.getNullSafeLicense());
    }

    private CharismaLicenseChecker(String username, String license) throws GeneralSecurityException {
        super(username, new BigInteger(license, 16), n);
        int userCount = (int)this.getValue(31);
        this.issueCount = this.getValue(63);
        this.projectCount = (int)this.getValue(31);
        this.flags = this.getValue(63);
        this.freeUpgradeDays = (short)this.getValue(15);
        Period freeUpdatePeriod = this.freeUpgradeDays == 0 ? DEFAULT_FREE_UPGRADE_PERIOD : Period.days((int)this.freeUpgradeDays);
        int ds = (int)this.getValue(31);
        this.diskSpace = ds > 0 ? ds : Integer.MAX_VALUE;
        int reporterCount = (int)this.getValue(12) * 10;
        this.userCount = userCount + reporterCount;
        this.freeUpgradeEnd = DateTimeArithmetics.plus((Long)this.getGenerationTime(), (Period)freeUpdatePeriod);
    }

    private static String getInvalidKeyText(Throwable e) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Invalid license key: " + CharismaLicenseChecker.getExceptionMessage(e)));
        }
        if (e instanceof InvalidLicenseException) {
            return ((InvalidLicenseException)e).isUserNameInvalid() ? ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("LicenseChecker.User_name_is_invalid", new Object[0]) : ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("LicenseChecker.License_is_invalid", new Object[0]);
        }
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Invalid_license_key", new Object[0]);
    }

    public static String getLicenseError(String username, String license) {
        try {
            return CharismaLicenseChecker.getLicenseError(new CharismaLicenseChecker(username, license));
        }
        catch (Throwable e) {
            return CharismaLicenseChecker.getInvalidKeyText(e);
        }
    }

    public static String getLicenseError() {
        String error;
        try {
            error = CharismaLicenseChecker.getLicenseError(((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate());
        }
        catch (Throwable e) {
            return CharismaLicenseChecker.getInvalidKeyText(e);
        }
        return error;
    }

    public static int getLicenseType_() {
        try {
            return ((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().getLicenseType();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean checkFlag(LicenseFlag flag) {
        try {
            return flag.hasFlag(((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().flags);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getUserCount() {
        try {
            return ((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().userCount;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isUnlimitedUsers() {
        return CharismaLicenseChecker.getUserCount() == Integer.MAX_VALUE;
    }

    public static boolean isUnlimitedDiskSpace() {
        return CharismaLicenseChecker.getDiskSpace() == Integer.MAX_VALUE;
    }

    public static long getIssueCount() {
        try {
            return ((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().issueCount;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getLicenseGenerationTime() {
        try {
            return ((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().getGenerationTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getLicenseExpirationTime() {
        try {
            return ((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().getExpirationTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getLicenseFreeUpdateEnd() {
        try {
            return ((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().freeUpgradeEnd;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static int getProjectCount() {
        try {
            return ((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().projectCount;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getDiskSpace() {
        try {
            return ((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().diskSpace;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isEnoughDiskSpace() {
        long allowedDiskSpace = CharismaLicenseChecker.getDiskSpace();
        if (allowedDiskSpace == Integer.MAX_VALUE) {
            return true;
        }
        return ((DiskSpaceManagement)ServiceLocator.getBean((String)"diskSpaceManagement")).getStorageSizeWithBackups() <= allowedDiskSpace * 0x100000L;
    }

    public static boolean isAgileEnabled() {
        try {
            return !LicenseFlag.AGILE_DISABLED.hasFlag(((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate().flags);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void checkIsEnoughDiskSpace() {
        if (!CharismaLicenseChecker.isEnoughDiskSpace()) {
            throw EntityOperations.isRemoved((Entity)DnqUtils.cast(null, (String)"ApplicationMetaData")) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Can_t_complete_operation_due_to_license_restrictions_disk_space_limit_exceeded", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Can_t_complete_operation_due_to_license_restrictions_disk_space_limit_exceeded", new Object[0]), (Entity)((TransientEntity)DnqUtils.cast(null, (String)"ApplicationMetaData"))));
        }
    }

    public static Tuples._2<String, String> getFreeLicense() {
        return MultiTuple.from((Object)((String)ServiceLocator.getBean((String)"defaultFreeLicenseName")), (Object)((String)ServiceLocator.getBean((String)"defaultFreeLicenseKey")));
    }

    private static String getNullSafeUsername() throws InvalidLicenseException {
        String username = PrimitiveAssociationSemantics.getBlobAsString((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"username");
        if (username == null || username.length() == 0) {
            throw new InvalidLicenseException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.license.error.username_not_set", new Object[0]), true);
        }
        return username;
    }

    private static String getNullSafeLicense() throws InvalidLicenseException {
        String license = CharismaLicenseChecker.trim_c6opvo_a0a0a91(PrimitiveAssociationSemantics.getBlobAsString((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"license"));
        if (license == null || license.length() == 0) {
            throw new InvalidLicenseException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.License_is_not_set", new Object[0]));
        }
        return license;
    }

    public static boolean isFreeUpgradeAllowed() {
        try {
            return !CharismaLicenseChecker.isFreeUpgradePeriodExpired(((CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker")).getOrCreate());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getLicenseError(CharismaLicenseChecker lc) {
        if (DateTimeOperations.compare((Long)lc.getGenerationTime(), (CompareType)CompareType.GT, (Long)DateTimeArithmetics.plus((Long)System.currentTimeMillis(), (Period)Period.days((int)1)), (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.The_license_was_not_generated_yet_;-", new Object[0]);
        }
        boolean isHosted = ConfigurationUtil.isYoutrackHosted();
        if (lc.getExpirationTime() < System.currentTimeMillis()) {
            if (isHosted) {
                if (lc.getLicenseType() == 2) {
                    return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Thank_you_for_trying_YouTrack_Your_free_trial_has_ended_Don_t_worry_all_your_data_is_safe_Choose_one_of_the_commercial_plans_or_switch_to_a_free_plan_to_continue_right_from_where_you_left", new Object[0]);
                }
                if (lc.getLicenseType() == 0) {
                    return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Thank_you_for_choosing_YouTrack_Your_current_subscription_has_ended_Don_t_worry_all_your_data_is_safe_Please_extend_your_subscription_or_change_your_plan_to_continue_right_from_where_you_stopped", new Object[0]);
                }
            }
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.The_license_has_expired", new Object[0]);
        }
        if (CharismaLicenseChecker.isFreeUpgradePeriodExpired(lc)) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Free_upgrade_period_has_expired", new Object[0]);
        }
        if (0 != lc.getProductType()) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Invalid_product_type", new Object[0]);
        }
        int productMinorVersion = lc.getProductMinorVersion();
        if (productMinorVersion != Integer.MAX_VALUE && productMinorVersion != 0) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Invalid_product_minor_version", new Object[0]);
        }
        int buildNumber = lc.getBuildNumber();
        if (buildNumber != Integer.MAX_VALUE && buildNumber != CharismaLicenseChecker.getApplicationBuildNumber()) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Invalid_build_number", new Object[0]);
        }
        boolean allowHostedSolution = LicenseFlag.HOSTED_SOLUTION.hasFlag(lc.flags);
        if (allowHostedSolution && !isHosted) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.This_license_can_be_used_only_for_YouTrack_InCloud", new Object[0]);
        }
        if (!allowHostedSolution && isHosted) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Can_t_use_this_license_for_YouTrack_InCloud", new Object[0]);
        }
        LicenseHistoryImpl.update();
        return null;
    }

    private static boolean isFreeUpgradePeriodExpired(CharismaLicenseChecker lc) {
        Long releaseDate;
        if (!ConfigurationUtil.isYoutrackHosted() && DateTimeOperations.compare((Long)lc.freeUpgradeEnd, (CompareType)CompareType.LT, (Long)(releaseDate = Long.valueOf(((ReleaseDateManager)ServiceLocator.getBean((String)"applicationReleaseDateManager")).getReleaseDate())), (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            return !LicenseHistoryImpl.isUpdateAfterLicenseExpirationAllowed();
        }
        return false;
    }

    private static String getExceptionMessage(Throwable e) {
        String message = e.getMessage();
        return message == null ? ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("CharismaLicenseChecker.Error_{0}", new Object[]{e.getClass().getName()}) : message;
    }

    private static int getApplicationBuildNumber() {
        String version_locase = ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion().toLowerCase();
        if (version_locase.contains("eap")) {
            return 1000000;
        }
        if (version_locase.contains("beta")) {
            return 1000001;
        }
        if (version_locase.contains("rc") || version_locase.contains("release candidate")) {
            return 1000002;
        }
        return Integer.valueOf(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationBuild());
    }

    private static long calculatePermGen() {
        try {
            for (MemoryPoolMXBean mx : ManagementFactory.getMemoryPoolMXBeans()) {
                String name = mx.getName();
                if (!name.endsWith("Perm Gen")) continue;
                return mx.getUsage().getMax();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Long.MAX_VALUE;
    }

    public static boolean isNotEnoughPermGen() {
        return PERM_GEN < 0x8000000L;
    }

    public static String trim_c6opvo_a0a0a91(String str) {
        return str == null ? null : str.trim();
    }

    static {
        log = LogFactory.getLog(CharismaLicenseChecker.class);
        PERM_GEN = CharismaLicenseChecker.calculatePermGen();
    }
}

