/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.maintenance;

import jetbrains.charisma.maintenance.VirtualFileDescriptorPathDecorator;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.jetbrains.annotations.NotNull;

public class PrefixPathBackupableDecorator
implements Backupable {
    @NotNull
    private final Backupable backupable;
    @NotNull
    private final String prefixPath;

    public PrefixPathBackupableDecorator(@NotNull Backupable backupable, @NotNull String prefixPath) {
        this.backupable = backupable;
        this.prefixPath = prefixPath;
    }

    public BackupStrategy getBackupStrategy() {
        return new BackupStrategyDecorator(this.backupable.getBackupStrategy(), this.prefixPath);
    }

    private static class BackupStrategyDecorator
    extends BackupStrategy {
        @NotNull
        private final BackupStrategy decorated;
        @NotNull
        private final String prefixPath;

        private BackupStrategyDecorator(@NotNull BackupStrategy decorated, @NotNull String prefixPath) {
            this.decorated = decorated;
            this.prefixPath = prefixPath;
        }

        public void beforeBackup() throws Exception {
            this.decorated.beforeBackup();
        }

        public void afterBackup() throws Exception {
            this.decorated.afterBackup();
        }

        public void onError(Throwable throwable) {
            this.decorated.onError(throwable);
        }

        public long acceptFile(@NotNull VirtualFileDescriptor file) {
            return this.decorated.acceptFile(file);
        }

        public Iterable<VirtualFileDescriptor> getContents() {
            Iterable source = this.decorated.getContents();
            return Sequence.fromIterable((Iterable)source).select((_FunctionTypes._return_P1_E0)new ISelector<VirtualFileDescriptor, VirtualFileDescriptor>(){

                public VirtualFileDescriptor select(VirtualFileDescriptor it) {
                    return this.decorate(it);
                }
            });
        }

        private VirtualFileDescriptor decorate(VirtualFileDescriptor it) {
            return new VirtualFileDescriptorPathDecorator(it, this.prefixPath);
        }
    }
}

