/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.maintenance;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.runtime.session.WebrSessionListenerImpl;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BeanContainerAwareSingleThreadDelegatingJobProcessor;

public class SessionManager
extends BeanContainerAwareSingleThreadDelegatingJobProcessor {
    protected static Log log = LogFactory.getLog(SessionManager.class);
    private Tuples._2<Integer, Long> maxOnlineUsersEver = MultiTuple.from((Object)0, (Object)System.currentTimeMillis());

    public SessionManager() {
        super(SessionManager.class.getName());
    }

    public Iterable<Entity> getOnlineUsers() {
        return SetSequence.fromSet((Set)((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).getLoggedInPrincipals()).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Serializable>(){

            public boolean accept(Serializable it) {
                return it != null;
            }
        }).select((_FunctionTypes._return_P1_E0)new ISelector<Serializable, Entity>(){

            public Entity select(Serializable it) {
                return DnqUtils.cast((Object)((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).getThreadSession().getEntity((EntityId)it), (String)"User");
            }
        });
    }

    public boolean isOnline(Entity user) {
        if (EntityOperations.equals((Entity)user, null)) {
            return false;
        }
        return ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).isLoggedIn((Serializable)user.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUsersCount() {
        int c = ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).getLoggedInCount();
        Tuples._2<Integer, Long> _22 = this.maxOnlineUsersEver;
        synchronized (_22) {
            if (c > (Integer)this.maxOnlineUsersEver._0()) {
                this.maxOnlineUsersEver = MultiTuple.from((Object)c, (Object)System.currentTimeMillis());
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxUsersCountEver() {
        Tuples._2<Integer, Long> _22 = this.maxOnlineUsersEver;
        synchronized (_22) {
            return (Integer)this.maxOnlineUsersEver._0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getMaxUsersCountEverDate() {
        Tuples._2<Integer, Long> _22 = this.maxOnlineUsersEver;
        synchronized (_22) {
            return (Long)this.maxOnlineUsersEver._1();
        }
    }

    public int getSessionsCount() {
        return WebrSessionListenerImpl.getInstance().getSessionsCount();
    }

    public int getWindowsCount() {
        return WebrSessionListenerImpl.getInstance().getWindowsCount();
    }

    public void asyncInvalidateSession(final Entity user) {
        new Job((JobProcessor)this){

            protected void execute() throws Throwable {
                _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                    public void invoke() {
                        SessionManager.this.invalidateSession(user);
                    }
                });
            }
        };
    }

    public void invalidateSession(final Entity user) {
        ISetSequence toInvalidate;
        block2: {
            toInvalidate = SetSequence.fromSet(new HashSet());
            try {
                WebrSessionListenerImpl.getInstance().forEach((_FunctionTypes._return_P1_E0)new _FunctionTypes._return_P1_E0<Boolean, HttpSession>((Set)toInvalidate){
                    final /* synthetic */ Set val$toInvalidate;
                    {
                        this.val$toInvalidate = set;
                    }

                    public Boolean invoke(HttpSession session) {
                        EntityId userId = SessionManager.this.getUserId(session);
                        if (userId != null && userId.equals(user.getId())) {
                            SetSequence.fromSet((Set)this.val$toInvalidate).addElement((Object)session);
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Exception while invalidating http sessions", (Throwable)e);
            }
        }
        SetSequence.fromSet((Set)toInvalidate).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<HttpSession>(){

            public void visit(HttpSession session) {
                block2: {
                    try {
                        session.invalidate();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block2;
                        log.warn((Object)("Exception while invalidating http session [" + session + "]"), (Throwable)e);
                    }
                }
            }
        });
    }

    private EntityId getUserId(HttpSession s) {
        return (EntityId)((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).getPrincipalRaw(s);
    }
}

