/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jetbrains.charisma.persistence.customfields.BundleImpl;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistence.user.BasePermissionsData;
import jetbrains.charisma.persistence.user.BaseUserPermissionsCacheData;
import jetbrains.exodus.entitystore.ComparableGetter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.ComparableGetterSort;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseUserPermissionsCache {
    protected static final ThreadLocal<Boolean> INVALID = new ThreadLocal();
    protected volatile BaseUserPermissionsCacheData data;

    public BaseUserPermissionsCache() {
        INVALID.set(true);
    }

    @Nullable
    public BaseUserPermissionsCacheData getData() {
        return this.data;
    }

    public void invalidate() {
        INVALID.set(true);
    }

    protected abstract void recalculate();

    @Nullable
    protected BasePermissionsData getPermissionData(Entity user) {
        BaseUserPermissionsCacheData data = this.getData();
        return data == null ? null : data.userPermissions.get(data.getUserKey(user));
    }

    @NotNull
    protected abstract Collection<Entity> getProjectsForPermission(Entity var1, String var2);

    protected Iterable<Entity> doGetPermittedProjectCustomFields(Entity user, boolean sorted, boolean read, Iterable<String> permissions) {
        IListSequence projectFields = Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"ProjectCustomField")).toListSequence();
        Object res = null;
        for (String permissionName : Sequence.fromIterable(permissions)) {
            TreeKeepingEntityIterable pcfs = read ? QueryOperations.query((Iterable)projectFields, (String)"ProjectCustomField", (NodeBase)new PropertyEqual("readPermissionName", (Comparable)((Object)permissionName))) : QueryOperations.query((Iterable)projectFields, (String)"ProjectCustomField", (NodeBase)new PropertyEqual("writePermissionName", (Comparable)((Object)permissionName)));
            for (Entity project : this.getProjectsForPermission(user, permissionName)) {
                TreeKeepingEntityIterable projectCustomFields = QueryOperations.query((Iterable)pcfs, (String)"ProjectCustomField", (NodeBase)new LinkEqual("project", project));
                if (res == null) {
                    res = projectCustomFields;
                    continue;
                }
                res = QueryOperations.union((Iterable)res, (Iterable)projectCustomFields);
            }
        }
        if (res == null) {
            return QueryOperations.empty((String)"ProjectCustomField");
        }
        return sorted ? QueryOperations.query(res, (String)"ProjectCustomField", (NodeBase)ComparableGetterSort.create(null, (ComparableGetter)new ComparableGetter(){

            public Comparable select(Entity it) {
                return Integer.valueOf(((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).getOrdinal(it));
            }
        }, (boolean)true)) : res;
    }

    protected Iterable<Entity> doGetPermittedProjectCustomFields(Entity user, Entity bundle, boolean sorted, boolean read) {
        return QueryOperations.intersect(this.doGetPermittedProjectCustomFields(user, sorted, read), ((BundleImpl)DnqUtils.getPersistentClassInstance((Entity)bundle, (String)"Bundle")).getUsagesInProjectFields(bundle));
    }

    protected Iterable<Entity> doGetPermittedProjectCustomFields(Entity user, boolean sorted, boolean read) {
        ISequence permissions = read ? Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"ProjectCustomField")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

            public String select(Entity it) {
                return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"readPermissionName", String.class, null);
            }
        }).distinct() : Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"ProjectCustomField")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

            public String select(Entity it) {
                return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"writePermissionName", String.class, null);
            }
        }).distinct();
        return this.doGetPermittedProjectCustomFields(user, sorted, read, (Iterable<String>)permissions);
    }

    public void checkValid() {
        if (Boolean.TRUE.equals(INVALID.get())) {
            INVALID.remove();
            this.recalculate();
        }
    }

    public Iterable<Entity> getPermittedProjectCustomFields(Entity user, Security.CustomFieldsAccess access) {
        BasePermissionsData permissionData = this.getPermissionData(user);
        Iterable<Entity> result = permissionData == null ? this.doGetPermittedProjectCustomFields(user, access.sorted, access.read) : (access.read ? permissionData.getReadPermittedCustomFields() : permissionData.getWritePermittedCustomFields());
        return access.removed ? result : Sequence.fromIterable(result).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.isRemoved((Entity)it);
            }
        });
    }

    public Iterable<Entity> getPermittedProjectCustomFieldPrototypes(Entity user, Security.CustomFieldsAccess access) {
        BasePermissionsData permissionData = this.getPermissionData(user);
        Iterable<Object> result = permissionData == null ? QueryOperations.selectDistinct(this.doGetPermittedProjectCustomFields(user, access.sorted, access.read), (String)"prototype") : (access.read ? permissionData.getReadPermittedCustomFieldPrototypes() : permissionData.getWritePermittedCustomFieldPrototypes());
        return access.removed ? result : Sequence.fromIterable(result).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.isRemoved((Entity)it);
            }
        });
    }

    public Iterable<Entity> getPermittedProjectCustomFields(Entity user, EntityId bundleId, Security.CustomFieldsAccess access) {
        BasePermissionsData permissionData = this.getPermissionData(user);
        Iterable<Entity> result = permissionData == null ? this.doGetPermittedProjectCustomFields(user, BundleImpl.fromEntityId(bundleId), access.sorted, access.read) : (access.read ? permissionData.getBundleReadPermittedCustomFields(bundleId) : permissionData.getBundleWritePermittedCustomFields(bundleId));
        return access.removed ? result : Sequence.fromIterable(result).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.isRemoved((Entity)it);
            }
        });
    }

    public Iterable<Entity> getPermittedProjectCustomFieldPrototypes(Entity user, Entity bundle, Security.CustomFieldsAccess access) {
        BasePermissionsData permissionData = this.getPermissionData(user);
        Iterable<Object> result = permissionData == null ? QueryOperations.selectDistinct(this.doGetPermittedProjectCustomFields(user, bundle, access.sorted, access.read), (String)"prototype") : (access.read ? permissionData.getBundleReadPermittedCustomFieldPrototypes(bundle) : permissionData.getBundleWritePermittedCustomFieldPrototypes(bundle));
        return access.removed ? result : Sequence.fromIterable(result).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.isRemoved((Entity)it);
            }
        });
    }

    public Map<Entity, Operation> getProjectToReadOperation(Entity user, Entity prototype) {
        BasePermissionsData permissionData = this.getPermissionData(user);
        if (permissionData != null) {
            return permissionData.getProjectsToReadOperation(prototype);
        }
        Iterable<Entity> permitted = this.getPermittedProjectCustomFields(user, Security.CustomFieldsAccess.UNSORTED_READ, prototype);
        final HashMap<Entity, Operation> result = new HashMap<Entity, Operation>();
        Sequence.fromIterable(permitted).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                result.put(AssociationSemantics.getToOne((Entity)it, (String)"project"), Permission.valueOf((String)((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"readPermissionName", String.class, null))).getOperation());
            }
        });
        return result;
    }

    public Map<Entity, Operation> getProjectToWriteOperation(Entity user, Entity prototype) {
        BasePermissionsData permissionData = this.getPermissionData(user);
        if (permissionData != null) {
            return permissionData.getProjectsToWriteOperation(prototype);
        }
        Iterable<Entity> permitted = this.getPermittedProjectCustomFields(user, Security.CustomFieldsAccess.UNSORTED_WRITE, prototype);
        final HashMap<Entity, Operation> result = new HashMap<Entity, Operation>();
        Sequence.fromIterable(permitted).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                result.put(AssociationSemantics.getToOne((Entity)it, (String)"project"), Permission.valueOf((String)((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"writePermissionName", String.class, null))).getOperation());
            }
        });
        return result;
    }

    public Iterable<Entity> getPermittedProjectCustomFields(Entity user, Security.CustomFieldsAccess access, Entity prototype) {
        ISequence result;
        BasePermissionsData permissionData = this.getPermissionData(user);
        if (permissionData == null) {
            ISequence permissionNames = access.read ? Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)prototype, (String)"instances")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

                public String select(Entity it) {
                    return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"readPermissionName", String.class, null);
                }
            }).distinct() : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)prototype, (String)"instances")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

                public String select(Entity it) {
                    return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"writePermissionName", String.class, null);
                }
            }).distinct();
            result = QueryOperations.query(this.doGetPermittedProjectCustomFields(user, access.sorted, access.read, (Iterable<String>)permissionNames), (String)"ProjectCustomField", (NodeBase)new LinkEqual("prototype", prototype));
        } else {
            result = access.read ? permissionData.getReadPermittedCustomFields(prototype) : permissionData.getWritePermittedCustomFields(prototype);
        }
        return access.removed ? result : Sequence.fromIterable(result).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !EntityOperations.isRemoved((Entity)it);
            }
        });
    }
}

