/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import jetbrains.charisma.errors.SecurityUtil;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;

public class DraftsProvider {
    private final Entity user;

    public DraftsProvider(Entity user) {
        this.user = user;
    }

    public Entity getNewDraft(boolean tmp) {
        return this.getNewDraft(null, tmp);
    }

    public Entity getNewDraft(Entity inProject) {
        return this.getNewDraft(inProject, false);
    }

    public Entity getNewDraft(Entity inProject, boolean tmp) {
        if (EntityOperations.equals((Entity)inProject, null) || !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)this.user, (String)"User")).hasPermission(Permission.CREATE_ISSUE, inProject, this.user)) {
            inProject = this.getDraftInitialProject();
        }
        return IssueImpl.createDraft(this.user, inProject, tmp);
    }

    public Iterable<Entity> getOrderedDrafts() {
        return QueryOperations.query((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)this.user, (String)"draft"), (String)"Issue", (NodeBase)new And((NodeBase)new UnaryNot((NodeBase)new PropertyEqual("tmp", (Comparable)Boolean.TRUE)), (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("deleted", (Comparable)Boolean.TRUE)))), (String)"Issue", (NodeBase)new SortByProperty(null, "updated", false));
    }

    public Entity findDraftById(String id) {
        Entity result = DnqUtils.cast((Object)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString(id, Entity.class.getName()), (String)"Issue");
        if (EntityOperations.equals((Entity)result, null) || !QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)this.user, (String)"draft"), (Entity)result)) {
            return null;
        }
        return result;
    }

    public Entity getDraftInitialProject() {
        Entity project;
        List projects = ((Security)ServiceLocator.getBean((String)"security")).getProjects(this.user, Permission.CREATE_ISSUE, false);
        if (projects.isEmpty()) {
            SecurityUtil.throwAccessSecurityException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.No_projects_with_permission_to_create_issues_found", new Object[0]), this.user);
        }
        if (EntityOperations.equals((Entity)(project = this.getUserFolderProject()), null)) {
            project = this.getLastCreatedIssueProject();
        }
        if (projects.contains(project)) {
            return project;
        }
        return (Entity)projects.iterator().next();
    }

    public Entity getUserFolderProject() {
        Iterable projects;
        Entity folder = AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)this.user, (String)"profile"), (String)"filterFolder");
        if (!EntityOperations.equals((Entity)folder, null) && QueryOperations.getSize((Iterable)(projects = ((IssueFolderImpl)DnqUtils.getPersistentClassInstance((Entity)folder, (String)"IssueFolder")).getQueryProjects(folder))) == 1) {
            return QueryOperations.getFirst((Iterable)projects);
        }
        return null;
    }

    public Entity getLastCreatedIssueProject() {
        return AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)this.user, (String)"profile"), (String)"lastCreated"), (String)"project");
    }
}

