/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.plugins.UserMergeHandler;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public class IssueRelatedUserMergeHandler
implements UserMergeHandler {
    @Override
    public void userDeleted(Entity deleted, Entity successor) {
        this.reassignIssues(deleted, (Entity)ServiceLocator.getBean((String)"deletedUser"));
        this.reassignComments(deleted, (Entity)ServiceLocator.getBean((String)"deletedUser"));
        this.reassignAttachments(deleted, (Entity)ServiceLocator.getBean((String)"deletedUser"));
    }

    @Override
    public Integer priority() {
        return 10000;
    }

    @Override
    public void userMerged(Entity from, final Entity into) {
        this.reassignIssues(from, ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)into, (String)"User")).isGuest(into) ? (Entity)ServiceLocator.getBean((String)"deletedUser") : into);
        this.reassignComments(from, ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)into, (String)"User")).isGuest(into) ? (Entity)ServiceLocator.getBean((String)"deletedUser") : into);
        this.reassignAttachments(from, ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)into, (String)"User")).isGuest(into) ? (Entity)ServiceLocator.getBean((String)"deletedUser") : into);
        if (!((UserImpl)DnqUtils.getPersistentClassInstance((Entity)into, (String)"User")).isGuest(into)) {
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)from, (String)"votedIssues")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity __addallit__) {
                    UndirectedAssociationSemantics.createManyToMany((Entity)into, (String)"votedIssues", (String)"voters", (Entity)__addallit__);
                }
            });
        }
    }

    private void reassignComments(Entity from, final Entity into) {
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"IssueComment", (NodeBase)new LinkEqual("author", from))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.setToOne((Entity)it, (String)"author", (Entity)into);
            }
        });
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"IssueComment", (NodeBase)new LinkEqual("updatedBy", from))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.setToOne((Entity)it, (String)"updatedBy", (Entity)into);
            }
        });
    }

    public void reassignIssues(final Entity from, final Entity into) {
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new LinkEqual("reporter", from))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)into, (String)"User")).isGuest(into)) {
                    DirectedAssociationSemantics.setToOne((Entity)it, (String)"reporter", (Entity)(EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)it, (String)"project"), (String)"leader"), (Object)from) ? (Entity)ServiceLocator.getBean((String)"deletedUser") : AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)it, (String)"project"), (String)"leader")));
                } else {
                    DirectedAssociationSemantics.setToOne((Entity)it, (String)"reporter", (Entity)into);
                }
            }
        });
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new LinkEqual("updatedBy", from))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.setToOne((Entity)it, (String)"updatedBy", (Entity)into);
            }
        });
    }

    public void reassignAttachments(Entity from, final Entity into) {
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)from, (String)"uploadedFiles")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                DirectedAssociationSemantics.createToMany((Entity)into, (String)"uploadedFiles", (Entity)__addallit__);
            }
        });
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"IssueAttachment", (NodeBase)new LinkEqual("author", from))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.setToOne((Entity)it, (String)"author", (Entity)into);
            }
        });
    }
}

