/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import jetbrains.charisma.errors.SecurityUtil;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.security.UserGroupRootImpl;
import jetbrains.charisma.persistence.user.DefaultAvatarUrlHolder;
import jetbrains.charisma.persistence.user.InaccessibleUserProfileImpl;
import jetbrains.charisma.persistence.user.ObsoleteUserRegistrationHandlers;
import jetbrains.charisma.persistence.user.UserPermissionsUtil;
import jetbrains.charisma.persistence.user.UserProfileImpl;
import jetbrains.charisma.persistent.DraftCommentImpl;
import jetbrains.charisma.service.UserProfileService;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Or;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.userManagement.runtime.user.BaseUserImpl;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.ring.RingConfig;
import jetbrains.youtrack.api.ring.RingUrls;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.PermissionAux;
import jetbrains.youtrack.core.security.Permissions;
import jetbrains.youtrack.core.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class UserImpl
extends BaseUserImpl {
    private static String __ENTITY_TYPE__ = "User";
    public static final String GUEST_LOGIN = "guest";
    public static final String VOTED_ISSUES_VIEW_NAME = "Voted Issues";
    private static final Log securityLog = LogFactory.getLog((String)"security");
    protected static Log log = LogFactory.getLog(UserImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        this.register(entity);
        return entity;
    }

    protected Entity _constructor(String login, String _entityType_) {
        Entity entity = this._constructor(login, false, _entityType_);
        return entity;
    }

    protected Entity _constructor(String login, boolean allowBanned, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"login", (Comparable)((Object)login), String.class);
        PrimitiveAssociationSemantics.setHashed((Entity)entity, (String)"password", (String)"");
        this.register(entity);
        return entity;
    }

    protected Entity _constructor(boolean fake, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"registered", (Comparable)Long.valueOf(System.currentTimeMillis()));
        Entity profile = InaccessibleUserProfileImpl.constructor();
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"profile", (Entity)profile);
        DirectedAssociationSemantics.setToOne((Entity)profile, (String)"user", (Entity)entity);
        return entity;
    }

    protected Entity _constructor(String login, String email, String password, String name, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"login", (Comparable)((Object)login), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"email", (Comparable)((Object)email), String.class);
        PrimitiveAssociationSemantics.setHashed((Entity)entity, (String)"password", (String)password);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"fullName", name != null && name.length() > 0 ? name : null, String.class);
        return entity;
    }

    public void destructor(Entity entity) {
        if (!EntityOperations.isNew((Entity)entity)) {
            securityLog.info((Object)("user " + this.getVisibleNameWithLogin(entity) + " deleted"));
        }
        super.destructor(entity);
    }

    public String getDisplayName(Entity entity) {
        super.getDisplayName(entity);
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.user_{user_name}", new Object[]{PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"login", String.class, (Object)"<no user>")});
    }

    public void markAsRoot(Entity entity) {
        if (!((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"root", Boolean.class, null)).booleanValue()) {
            Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("root", (Comparable)Boolean.TRUE))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity it) {
                    PrimitiveAssociationSemantics.set((Entity)it, (String)"root", (Comparable)Boolean.valueOf(false), Boolean.class);
                    securityLog.info((Object)("User " + ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"User")).getVisibleNameWithLogin(it) + " is no longer root"));
                }
            });
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"root", (Comparable)Boolean.valueOf(true), Boolean.class);
            securityLog.info((Object)("User " + this.getVisibleNameWithLogin(entity) + " is now root"));
        }
    }

    public void register(Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"registered", (Comparable)Long.valueOf(System.currentTimeMillis()));
        Entity profile = UserProfileImpl.constructor();
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"profile", (Entity)profile);
        DirectedAssociationSemantics.setToOne((Entity)profile, (String)"user", (Entity)entity);
        ((ObsoleteUserRegistrationHandlers)ServiceLocator.getBean((String)"userRegistrationHandlers")).register(entity);
        securityLog.info((Object)("user " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>") + " created"));
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        if (!EntityOperations.isNew((Entity)entity) && UserImpl.eq_xudj6d_a0a0b0k(PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"login", String.class, (Object)"<no user>"), GUEST_LOGIN) && EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"login")) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.The_operation_is_prohibited_for_guest", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.The_operation_is_prohibited_for_guest", new Object[0]), (Entity)((TransientEntity)entity)));
        }
        if (!(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"User")).isSystem(entity) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"User")).isService(entity) || LoginUtils.isValidLogin((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null))) || !EntityOperations.isNew((Entity)entity) && !EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"login"))) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.{0}_is_not_a_valid_user_login", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>")}))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.{0}_is_not_a_valid_user_login", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>")}), (Entity)((TransientEntity)entity)));
        }
        if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"login") && UserImpl.isEmpty_xudj6d_a0a3a01((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null))) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"fullName", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>")), String.class);
        }
    }

    public void fixLogin(Entity entity) {
        if (!LoginUtils.isValidLogin((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null)))) {
            String fixed = LoginUtils.fix((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null)));
            if (fixed == null || fixed.length() == 0) {
                throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.{0}_is_not_a_valid_login", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>")}))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.{0}_is_not_a_valid_login", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>")}), (Entity)((TransientEntity)entity)));
            }
            if (!((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>")).equals(fixed)) {
                int counter = 0;
                while (!EntityOperations.equals((Entity)UserImpl.findUser(fixed), null)) {
                    fixed = LoginUtils.increment((String)fixed, (int)(++counter));
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Invalid user login " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>") + " replaced with " + fixed));
                }
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"login", (Comparable)((Object)fixed), String.class);
            }
        }
    }

    public long getPersistentLocalId(Entity entity) {
        return entity.getId().getLocalId();
    }

    public String getVisibleName(Entity entity) {
        return UserImpl.isEmpty_xudj6d_a0a0a31((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null)) ? (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>") : (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null);
    }

    public String getVisibleNameWithLogin(Entity entity) {
        return UserImpl.isEmpty_xudj6d_a0a0a41((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null)) ? (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>") : (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null) + " (" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>") + ")";
    }

    public String getVisibleNameWithLoginAndEmail(Entity entity) {
        String result = this.getVisibleNameWithLogin(entity);
        if (UserImpl.isNotEmpty_xudj6d_a0b0p((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"email", String.class, null))) {
            result = result + ' ' + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"email", String.class, null);
        }
        return result;
    }

    public boolean isBanned(Entity entity) {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"banned", Boolean.class, null);
    }

    public boolean bannedHasChanges(Entity entity) {
        return EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"banned");
    }

    public void setBanned(boolean value, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"banned", (Comparable)Boolean.valueOf(value), Boolean.class);
    }

    public String getAvatarUrl(Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            return ((DefaultAvatarUrlHolder)ServiceLocator.getBean((String)"defaultAvatarUrl")).getUrl();
        }
        return ((RingConfig)ServiceLocator.getBean((String)"ringConfig")).isEnabled() ? ((RingUrls)ServiceLocator.getBean((String)"ringUrls")).getHubUserAvatarUrl(entity) : ((DefaultAvatarUrlHolder)ServiceLocator.getBean((String)"defaultAvatarUrl")).getUrl();
    }

    public Iterable<Entity> getUserGroups(Entity entity) {
        return QueryOperations.concat(UserGroupRootImpl.getAllUsersGroupSequence(), (Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"groups"));
    }

    public boolean hasPermission(Permission permission, Entity entity) {
        return ((Security)ServiceLocator.getBean((String)"security")).hasPermission(entity, permission);
    }

    public boolean hasPermissionInAtLeastOneProject(final Permission permission, Iterable<Entity> projects, final Entity entity) {
        if (QueryOperations.isEmpty(projects)) {
            return true;
        }
        return !QueryOperations.isEmpty((Iterable)Sequence.fromIterable(projects).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return UserImpl.this.hasPermission(permission, it, entity);
            }
        }));
    }

    public boolean hasPermissionInAllProject(final Permission permission, Iterable<Entity> projects, final Entity entity) {
        if (QueryOperations.isEmpty(projects)) {
            return true;
        }
        return QueryOperations.isEmpty((Iterable)Sequence.fromIterable(projects).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !UserImpl.this.hasPermission(permission, it, entity);
            }
        }));
    }

    public boolean hasPermission(String persistentClass, Operation operation, Entity entity) {
        return this.hasPermission(((PermissionAux)ServiceLocator.getBean((String)"permissionAux")).findPermission(persistentClass, operation), entity);
    }

    public boolean hasPermission(Permission permission, Entity project, Entity entity) {
        return ((Security)ServiceLocator.getBean((String)"security")).hasPermission(entity, permission, project);
    }

    public boolean hasPermission(String persistentClass, Operation operation, Entity project, Entity entity) {
        return this.hasPermission(((PermissionAux)ServiceLocator.getBean((String)"permissionAux")).findPermission(persistentClass, operation), project, entity);
    }

    @NotNull
    public Iterable<Entity> getPermittedProjectCustomFields(Security.CustomFieldsAccess access, Entity entity) {
        return ((Security)ServiceLocator.getBean((String)"security")).getPermittedProjectCustomFields(entity, access);
    }

    public Iterable<Entity> getPermittedProjectCustomFields(Security.CustomFieldsAccess access, Entity prototype, Entity entity) {
        return ((Security)ServiceLocator.getBean((String)"security")).getPermittedProjectCustomFields(entity, access, prototype);
    }

    public boolean isInGroup(String groupName, Entity entity) {
        Entity group = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"UserGroup", (NodeBase)new PropertyEqual("name", (Comparable)((Object)groupName))));
        if (EntityOperations.equals((Entity)group, null)) {
            return false;
        }
        return this.isInGroup(group, entity);
    }

    public boolean isInGroup(Entity group, Entity entity) {
        if (EntityOperations.equals((Entity)group, null) || ((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            return true;
        }
        return QueryOperations.contains(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"User")).getUserGroups(entity), (Entity)group);
    }

    public Iterable<Entity> getUserGroupsExcludingAllUsersGroup(Entity entity) {
        final Wrappers._T res = new Wrappers._T((Object)AssociationSemantics.getToMany((Entity)entity, (String)"groups"));
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"groups")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                Iterable<Entity> ancestors = ((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"UserGroup")).getAncestorsOrNull(it);
                if (ancestors != null) {
                    res.value = QueryOperations.union((Iterable)((Iterable)res.value), ancestors);
                }
            }
        });
        return (Iterable)res.value;
    }

    public Iterable<Entity> getVisibleUserGroupsSorted(Entity entity) {
        if (this.hasPermission(Permission.READ_USERGROUP, entity)) {
            return QueryOperations.concat(UserGroupRootImpl.getAllUsersGroupSequence(), (Iterable)QueryOperations.query(UserGroupRootImpl.getAllGroups(), (String)"UserGroup", (NodeBase)new SortByProperty(null, "name", true)));
        }
        return QueryOperations.concat(UserGroupRootImpl.getAllUsersGroupSequence(), (Iterable)QueryOperations.query(this.getUserGroupsExcludingAllUsersGroup(entity), (String)"UserGroup", (NodeBase)new SortByProperty(null, "name", true)));
    }

    public Iterable<Entity> applyPermissions(Iterable<Entity> issues, Entity entity) {
        Collection permittedProjects = ((Security)ServiceLocator.getBean((String)"security")).getProjectsUnordered(entity, Permission.READ_ISSUE, false);
        Collection createProjectsList = ((Security)ServiceLocator.getBean((String)"security")).getProjectsUnordered(entity, Permission.CREATE_ISSUE, false);
        HashSet createProjects = new HashSet(createProjectsList);
        SetSequence.fromSet((Set)createProjects).removeSequence((ISequence)CollectionSequence.fromCollection((Collection)permittedProjects));
        Iterable<Entity> visibleReported = QueryOperations.isEmpty((Iterable)createProjects) ? null : UserPermissionsUtil.applyVisibleReported(entity, issues, (Iterable<Entity>)createProjects, Collections.EMPTY_SET);
        Iterable result = QueryOperations.intersect(UserPermissionsUtil.filterByPermittedProjects(issues, permittedProjects, Collections.EMPTY_SET), ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"User")).applyGroupPermissions((Iterable<Entity>)QueryOperations.queryGetAll((String)"Issue"), entity));
        if (visibleReported != null) {
            result = QueryOperations.union((Iterable)result, visibleReported);
        }
        return ((Permissions)ServiceLocator.getBean((String)"permissions")).excludeDraftsAndDeleted(result);
    }

    protected Iterable<Entity> applyGroupPermissions(Iterable<Entity> issues, Entity entity) {
        Object result = QueryOperations.query(issues, (String)"Issue", (NodeBase)new Or((NodeBase)new Or((NodeBase)new LinkEqual("reporter", entity), (NodeBase)new And((NodeBase)new LinkEqual("permittedGroup", null), (NodeBase)new LinkEqual("permittedUser", null))), (NodeBase)new LinkEqual("permittedUser", entity)));
        for (Entity group : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"groups"))) {
            result = QueryOperations.union((Iterable)result, (Iterable)QueryOperations.query(issues, (String)"Issue", (NodeBase)new LinkEqual("permittedGroup", group)));
        }
        return result;
    }

    public boolean isGuest(Entity entity) {
        return ((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null)).equals(GUEST_LOGIN);
    }

    public boolean isRoot(Entity entity) {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"root", Boolean.class, null);
    }

    public boolean isAccessible(Operation operation, Entity forUser, Entity entity) {
        return !(!EntityOperations.equals((Entity)forUser, (Object)entity) && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)forUser, (String)"User")).hasPermission("User", operation, forUser) || operation == Operation.DELETE && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"root", Boolean.class, null) != false);
    }

    public Entity getCommentDraft(Entity issue, boolean create, Entity entity) {
        if (create) {
            return DraftCommentImpl.getOrCreate(entity, issue);
        }
        return QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"draftComments"), (String)"DraftComment", (NodeBase)new LinkEqual("issue", issue)));
    }

    public Entity getCommentDraft(Entity issue, Entity entity) {
        return this.getCommentDraft(issue, true, entity);
    }

    public boolean hasAccessToCommands(Entity entity) {
        return this.hasPermission(Permission.UPDATE_ISSUE, entity) || this.hasPermission(Permission.PRIVATE_UPDATE_ISSUE, entity) || this.hasPermission(Permission.CREATE_COMMENT, entity) || this.hasPermission(Permission.LINK_ISSUE, entity);
    }

    public void addGroup(Entity group, Entity entity) {
        ((Security)ServiceLocator.getBean((String)"security")).addUserToUserGroup(entity, group);
    }

    public void removeGroup(Entity group, Entity entity) {
        ((Security)ServiceLocator.getBean((String)"security")).removeUserFromUserGroup(entity, group);
    }

    public boolean isSystem(Entity entity) {
        return false;
    }

    public boolean isService(Entity entity) {
        return false;
    }

    public Iterable<Entity> getUserRolesInMemory(Entity entity) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Slow method getUserRolesInMemory() called", new Throwable());
        }
        HashSet result = new HashSet();
        for (Entity role : AssociationSemantics.getToMany((Entity)entity, (String)"userRoles")) {
            result.add(role);
        }
        for (Entity role : QueryOperations.distinct((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"groups")).translate((_FunctionTypes._return_P1_E0)new ITranslator2<Entity, Entity>(){

            public Iterable<Entity> translate(Entity it) {
                return AssociationSemantics.getToMany((Entity)it, (String)"groupRoles");
            }
        }))) {
            result.add(role);
        }
        return result;
    }

    public void checkAccess(_FunctionTypes._return_P1_E0<? extends Boolean, ? super Entity> check, String securityMsg, Entity entity) {
        if (!((Boolean)check.invoke((Object)entity)).booleanValue()) {
            SecurityUtil.throwAccessSecurityException(securityMsg, entity);
        }
    }

    public boolean shouldUseMarkdown(Entity entity) {
        return ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getGeneralUserProfile(entity).isUseMarkdown();
    }

    public static Entity constructor() {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Entity constructor(String login) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(login, __ENTITY_TYPE__);
    }

    public static Entity constructor(String login, boolean allowBanned) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(login, allowBanned, __ENTITY_TYPE__);
    }

    protected static Entity constructor(boolean fake) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(fake, __ENTITY_TYPE__);
    }

    private static Entity constructor(String login, String email, String password, String name) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(login, email, password, name, __ENTITY_TYPE__);
    }

    public static Entity findUser(String login) {
        if (login == null) {
            return null;
        }
        return QueryOperations.getFirst((Iterable)DnqUtils.getCurrentTransientSession().createPersistentEntityIterableWrapper(DnqUtils.getCurrentPersistentSession().find("User", "login", (Comparable)((Object)login))));
    }

    public static Entity findRoot() {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("root", (Comparable)Boolean.TRUE)));
    }

    public static Iterable<Entity> filterBanned(Iterable<Entity> users, boolean banned) {
        return banned ? QueryOperations.query(users, (String)"User", (NodeBase)new PropertyEqual("banned", (Comparable)Boolean.TRUE)) : QueryOperations.query(users, (String)"User", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("banned", (Comparable)Boolean.TRUE)));
    }

    public static Iterable<Entity> all() {
        return DnqUtils.getCurrentTransientSession().createPersistentEntityIterableWrapper(DnqUtils.getCurrentPersistentSession().getAll("User"));
    }

    protected static DnqUtils.QueryingEntityCreator getEntityCreator(String entityType, String login, String email, String password, String name, final Set<String> queriedParams) {
        final DnqUtils.QueryingEntityCreator parent = DnqUtils.getEntityCreator((String)entityType, queriedParams);
        final String __var__login = login;
        final String __var__email = email;
        final String __var__password = password;
        final String __var__fullName = name != null && name.length() > 0 ? name : null;
        return new DnqUtils.QueryingEntityCreator(entityType){

            public Iterable<Entity> query() {
                Iterable result = parent.query();
                if (queriedParams.contains("login")) {
                    result = QueryOperations.query((Iterable)result, (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)__var__login)));
                }
                if (queriedParams.contains("email")) {
                    result = QueryOperations.query((Iterable)result, (String)"User", (NodeBase)new PropertyEqual("email", (Comparable)((Object)__var__email)));
                }
                if (queriedParams.contains("password")) {
                    result = QueryOperations.query((Iterable)result, (String)"User", (NodeBase)new PropertyEqual("password", (Comparable)((Object)__var__password)));
                }
                if (queriedParams.contains("fullName")) {
                    result = QueryOperations.query((Iterable)result, (String)"User", (NodeBase)new PropertyEqual("fullName", (Comparable)((Object)__var__fullName)));
                }
                return result;
            }

            public void created(@NotNull Entity entity) {
                parent.created(entity);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"login", (Comparable)((Object)__var__login), String.class);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"email", (Comparable)((Object)__var__email), String.class);
                PrimitiveAssociationSemantics.setHashed((Entity)entity, (String)"password", (String)__var__password);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"fullName", (Comparable)((Object)__var__fullName), String.class);
            }
        };
    }

    public static Entity findOrCreate(String login, String email, String password, String name, String[] queriedParams) {
        return UserImpl.getEntityCreator(__ENTITY_TYPE__, login, email, password, name, BasePersistentClassImpl.buildSet((Object[])queriedParams)).create((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore"));
    }

    private static boolean eq_xudj6d_a0a0b0k(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    public static boolean isEmpty_xudj6d_a0a3a01(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_xudj6d_a0a0a31(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_xudj6d_a0a0a41(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty_xudj6d_a0b0p(String str) {
        return str != null && str.length() > 0;
    }
}

