/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.user;

import java.util.HashSet;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;

public class UserPermissionsUtil {
    private UserPermissionsUtil() {
    }

    public static Iterable<Entity> applyVisibleReported(Entity user, Iterable<Entity> issues, Iterable<Entity> permittedProjects, Set<EntityId> positiveProjects) {
        issues = UserPermissionsUtil.filterByPermittedProjects(issues, permittedProjects, positiveProjects);
        return QueryOperations.query(issues, (String)"Issue", (NodeBase)new LinkEqual("reporter", user));
    }

    public static Iterable<Entity> filterByPermittedProjects(Iterable<Entity> issues, Iterable<Entity> permittedProjects, Set<EntityId> positiveProjects) {
        int permittedProjectsCount;
        if (issues == null) {
            return null;
        }
        if (QueryOperations.isEmpty(permittedProjects)) {
            return QueryOperations.empty((String)"Issue");
        }
        int totalProjectsCount = QueryOperations.roughSize((Iterable)QueryOperations.queryGetAll((String)"Project"));
        if (totalProjectsCount != (permittedProjectsCount = QueryOperations.getSize(permittedProjects))) {
            boolean applyPermitted = true;
            if (!positiveProjects.isEmpty()) {
                HashSet<EntityId> positive = new HashSet<EntityId>(positiveProjects);
                for (Entity project : permittedProjects) {
                    positive.remove(project.getId());
                }
                if (positive.isEmpty()) {
                    applyPermitted = false;
                }
            }
            if (applyPermitted) {
                if (permittedProjectsCount <= totalProjectsCount / 2) {
                    TreeKeepingEntityIterable accessibleIssues = null;
                    for (Entity p : Sequence.fromIterable(permittedProjects)) {
                        TreeKeepingEntityIterable projectIssues = QueryOperations.query(issues, (String)"Issue", (NodeBase)new LinkEqual("project", p));
                        accessibleIssues = accessibleIssues == null ? projectIssues : QueryOperations.union((Iterable)accessibleIssues, (Iterable)projectIssues);
                    }
                    issues = accessibleIssues;
                } else {
                    for (Entity p : Sequence.fromIterable((Iterable)QueryOperations.exclude((Iterable)QueryOperations.queryGetAll((String)"Project"), permittedProjects))) {
                        issues = QueryOperations.query(issues, (String)"Issue", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("project", p)));
                    }
                }
            }
        }
        return issues;
    }
}

