/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import com.jetbrains.teamsys.dnq.database.MessageBuilder;
import java.util.Collection;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.CharismaLicenseCheckerContainer;
import jetbrains.charisma.persistent.ConstraintsErrorMessageUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;

public class BaseCommentImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "BaseComment";

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String text, String _entityType_) {
        Entity entity = this._constructor(text, System.currentTimeMillis(), _entityType_);
        return entity;
    }

    protected Entity _constructor(String text, Long created, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        this.checkLicense(entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"created", (Comparable)created);
        PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)entity, (String)"text", (String)text);
        return entity;
    }

    public IncomingLinkViolation createIncomingLinkViolation(String name) {
        String linkName = name;
        if ("permittedGroup".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerTypeErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ConstraintsErrorMessageUtil.createReportAboutComments(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("BaseComment.permitted_group_in", new Object[0]), linkedEntities, hasMore);
                        }
                    });
                }
            };
        }
        return new IncomingLinkViolation(linkName);
    }

    public boolean isPropertyRequired(String name, Entity entity) {
        if (name.equals("text")) {
            return this.isCommentTextRequired(entity);
        }
        return false;
    }

    public Entity getAuthor(Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public Entity getIssue(Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public boolean isCommentTextRequired(Entity entity) {
        return true;
    }

    public boolean isAccessible(Entity user, Operation operation, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public void copy(Entity comment, final Entity entity) {
        PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)entity, (String)"text", (String)PrimitiveAssociationSemantics.getBlobAsString((Entity)comment, (String)"text"));
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)comment, (String)"permittedGroup")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedComments", (Entity)__addallit__);
            }
        });
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)comment, (String)"permittedUser")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleComments", (Entity)__addallit__);
            }
        });
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"created", (Comparable)((Long)PrimitiveAssociationSemantics.get((Entity)comment, (String)"created", null)));
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"updated", (Comparable)((Long)PrimitiveAssociationSemantics.get((Entity)comment, (String)"updated", null)));
    }

    @Deprecated
    public Entity getPermittedGroup(Entity entity) {
        return QueryOperations.getFirst((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup"));
    }

    public boolean isSecured(Entity entity) {
        return !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) || !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser"));
    }

    public boolean isSecuredCommentAccessible(Entity user, Entity entity) {
        return QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) && QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser")) || QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser"), (Entity)user) || !QueryOperations.isEmpty((Iterable)QueryOperations.intersect((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup"), (Iterable)AssociationSemantics.getToMany((Entity)user, (String)"groups")));
    }

    public void setPermittedGroup(Entity group, Entity entity) {
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedComments");
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleComments");
        if (!EntityOperations.equals((Entity)group, null) && !((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedComments", (Entity)group);
        }
    }

    public void setPermitted(Iterable<Entity> groups, Iterable<Entity> users, final Entity entity) {
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedComments");
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleComments");
        Sequence.fromIterable(groups).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedComments", (Entity)__addallit__);
            }
        });
        Sequence.fromIterable(users).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleComments", (Entity)__addallit__);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLicense(Entity entity) {
        CharismaLicenseCheckerContainer charismaLicenseCheckerContainer = (CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker");
        synchronized (charismaLicenseCheckerContainer) {
            CharismaLicenseChecker.checkIsEnoughDiskSpace();
        }
    }

    public void addAttachment(Entity attachment, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public void removeAttachment(Entity attachment, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public Iterable<Entity> getAttachments(Entity entity) {
        return QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"attachments"), (String)"IssueAttachment", (NodeBase)new SortByProperty(null, "created", true));
    }

    public Iterable<Entity> getAttachmentsUnsorted(Entity entity) {
        return AssociationSemantics.getToMany((Entity)entity, (String)"attachments");
    }

    public boolean hasAttachments(Entity entity) {
        return !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"attachments"));
    }

    public static Entity constructor(String text) {
        return ((BaseCommentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(text, __ENTITY_TYPE__);
    }

    public static Entity constructor(String text, Long created) {
        return ((BaseCommentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(text, created, __ENTITY_TYPE__);
    }
}

