/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import jetbrains.charisma.persistent.BadCharsException;
import jetbrains.charisma.persistent.BadNameException;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ArrayUtils;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.apache.commons.lang.StringUtils;

public class Constraints {
    public static final String FORBIDDEN_PATH_CHARS = "</>";
    public static final String FORBIDDEN_PATH_CHARS_REPLACEMENT = IterableUtils.join((Iterable)Sequence.fromIterable((Iterable)ArrayUtils.fromCharacterArray((char[])"</>".toCharArray())).select((_FunctionTypes._return_P1_E0)new ISelector<Character, String>(){

        public String select(Character it) {
            return "_";
        }
    }), (String)"");

    public static void assertNoBadChars(Entity entity, String propertyName, String displayPropertyName, String restrictedChars) {
        String name = (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)propertyName, null, String.class);
        if (!Constraints.nameContainsNoBadChars(name, restrictedChars)) {
            throw new ConstraintsValidationException((DataIntegrityViolationException)new BadCharsException((TransientEntity)entity, propertyName, displayPropertyName, restrictedChars));
        }
    }

    public static boolean nameContainsNoBadChars(String name, String restrictedChars) {
        return StringUtils.containsNone((String)name, (String)restrictedChars);
    }

    public static void assertNoForbiddenPathChars(Entity entity, String propertyName, String displayPropertyName) {
        Constraints.assertNoBadChars(entity, propertyName, displayPropertyName, FORBIDDEN_PATH_CHARS);
        String propertyValue = (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)propertyName, null, String.class);
        if (Constraints.eq_i7hmz_a0a2a2(propertyValue, "..") || Constraints.eq_i7hmz_a0a2a2_0(propertyValue, ".")) {
            throw new ConstraintsValidationException((DataIntegrityViolationException)new BadNameException((TransientEntity)entity, propertyName, displayPropertyName, "..", "."));
        }
    }

    public static String unforbidPath(String toBeUnforbidden) {
        return StringUtils.replaceChars((String)toBeUnforbidden, (String)FORBIDDEN_PATH_CHARS, (String)FORBIDDEN_PATH_CHARS_REPLACEMENT);
    }

    public static String unforbidPath(String toBeUnforbidden, String forbiddenChars, char replacement) {
        return StringUtils.replaceChars((String)toBeUnforbidden, (String)forbiddenChars, (String)IterableUtils.join((Iterable)Sequence.fromIterable((Iterable)ArrayUtils.fromCharacterArray((char[])forbiddenChars.toCharArray())).select((_FunctionTypes._return_P1_E0)new ISelector<Character, String>(){

            public String select(Character it) {
                return "_";
            }
        }), (String)""));
    }

    public static void assertNameIsOk(Entity entity, String propertyName, String displayPropertyName, String ... restrictedNames) {
        if (restrictedNames == null || restrictedNames.length == 0) {
            return;
        }
        String propertyValue = (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)propertyName, null, String.class);
        if (propertyValue == null || propertyValue.length() == 0) {
            return;
        }
        for (int i = 0; i < restrictedNames.length; ++i) {
            if (!restrictedNames[i].equalsIgnoreCase(propertyValue)) continue;
            throw new ConstraintsValidationException((DataIntegrityViolationException)new BadNameException((TransientEntity)entity, propertyName, displayPropertyName, restrictedNames[i]));
        }
    }

    private static boolean eq_i7hmz_a0a2a2(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_i7hmz_a0a2a2_0(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

