/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import java.io.File;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistent.CronValidator;
import jetbrains.charisma.persistent.DatabaseBackupFolder;
import jetbrains.charisma.persistent.StringUtils;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyRange;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.application.DatabaseSettingsFactory;
import org.jetbrains.annotations.Nullable;

public class DatabaseBackupConfigImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "DatabaseBackupConfig";
    private static int ONE_MINUTE_TICKS = 60000;
    private static int ONE_HOUR_TICKS = ONE_MINUTE_TICKS * 60;
    private static int ONE_DAY_TICKS = ONE_HOUR_TICKS * 24;
    public static String[] FILE_FORMATS = new String[]{".zip", ".tar.gz"};

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"cronExpression", (Comparable)((Object)"0 0 9 * * ?"), String.class);
        return entity;
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        if (DatabaseBackupConfigImpl.isNotEmpty_26ghcf_a0c0c((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"cronExpression", String.class, null))) {
            ((CronValidator)ServiceLocator.getBean((String)"cronValidator")).assertValidCronExpression((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"cronExpression", String.class, null));
        }
    }

    public void checkDefaults(Entity entity) {
        if (PrimitiveAssociationSemantics.get((Entity)entity, (String)"backupLocation", String.class, null) == null) {
            ((DatabaseBackupConfigImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"DatabaseBackupConfig")).resetBackupLocationToDefault(entity);
        }
    }

    public void resetBackupLocationToDefault(Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"backupLocation", (Comparable)((Object)((DatabaseSettingsFactory)ServiceLocator.getBean((String)"databaseSettingsFactory")).resolveBackupLocation()), String.class);
    }

    public String getOrCreateCronExpression(Entity entity) {
        return DatabaseBackupConfigImpl.adjustCronExpression(DatabaseBackupConfigImpl.trim_26ghcf_a0a0a5((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"cronExpression", String.class, null)));
    }

    public void setCronExpression(String expression, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"cronExpression", (Comparable)((Object)expression), String.class);
    }

    public String getArchiveFormat(Entity entity) {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"zipArhive", Boolean.class, null) != false ? FILE_FORMATS[0] : FILE_FORMATS[1];
    }

    public long getAvailableBytes(Entity entity) {
        File backupDirectory = ((DatabaseBackupFolder)ServiceLocator.getBean((String)"backupFolder")).getRootBackupFolder();
        backupDirectory.mkdirs();
        return backupDirectory.getUsableSpace();
    }

    @Nullable
    public String getFormattedTimeToExhaustDisk(Entity entity) {
        long minutes;
        long time = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"timeToExhaustDisk", Long.class, null);
        if (time == 0L || time > (long)ONE_DAY_TICKS) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        long hours = time / (long)ONE_HOUR_TICKS;
        if (hours > 0L) {
            builder.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("DatabaseBackupConfig.{0}_hours", new Object[]{hours}));
        }
        if ((minutes = time % (long)ONE_HOUR_TICKS / (long)ONE_MINUTE_TICKS) > 0L) {
            builder.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("DatabaseBackupConfig.{0}{1}_minutes", new Object[]{minutes}));
        }
        if (builder.length() == 0) {
            builder.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("DatabaseBackupConfig.less_than_a_minute", new Object[0]));
        }
        return builder.toString();
    }

    public static Entity constructor() {
        return ((DatabaseBackupConfigImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static String getErrorForBackupFile(File file) {
        return (String)PrimitiveAssociationSemantics.get((Entity)QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"DatabaseBackupError", (NodeBase)new PropertyEqual("fileName", (Comparable)((Object)file.getName())))), (String)"errorMessage", String.class, null);
    }

    public static void deleteBackupsExceptLast() {
        DatabaseBackupConfigImpl.rotateBackups(1);
    }

    @Nullable
    public static Entity getLastError() {
        Iterable<File> backupFiles = ((DatabaseBackupFolder)ServiceLocator.getBean((String)"backupFolder")).listBackupFiles();
        if (Sequence.fromIterable(backupFiles).isEmpty()) {
            return null;
        }
        Long lastBackupDate = ((File)Sequence.fromIterable(backupFiles).first()).lastModified();
        return QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)((Entity)ServiceLocator.getBean((String)"databaseBackupConfig")), (String)"errors"), (String)"DatabaseBackupError", (NodeBase)new PropertyRange("date", PrimitiveAssociationSemantics.nextGreater((Comparable)lastBackupDate, Long.class), PrimitiveAssociationSemantics.positiveInfinity(Long.class))), (String)"DatabaseBackupError", (NodeBase)new SortByProperty(null, "date", false)));
    }

    public static void rotateBackups() {
        final int[] backupsToKeep = new int[]{0};
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                backupsToKeep[0] = ConfigurationUtil.isYoutrackHosted() ? 1 : (Integer)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"databaseBackupConfig")), (String)"backupCountToKeep", Integer.class, null);
            }
        });
        if (backupsToKeep[0] > 0) {
            DatabaseBackupConfigImpl.rotateBackups(backupsToKeep[0]);
        }
    }

    private static void rotateBackups(final int backupsToKeep) {
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                Sequence.fromIterable(((DatabaseBackupFolder)ServiceLocator.getBean((String)"backupFolder")).listBackupFiles()).skip(backupsToKeep).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<File>(){

                    public void visit(File it) {
                        ((DatabaseBackupFolder)ServiceLocator.getBean((String)"backupFolder")).deleteBackup(it.getName());
                    }
                });
            }
        });
    }

    private static String adjustCronExpression(String ce) {
        if (ce != null && ce.length() > 0 && ce.charAt(0) == '*') {
            ce = '0' + StringUtils.substring(ce, 1);
        }
        return ce;
    }

    public static boolean isNotEmpty_26ghcf_a0c0c(String str) {
        return str != null && str.length() > 0;
    }

    public static String trim_26ghcf_a0a0a5(String str) {
        return str == null ? null : str.trim();
    }
}

