/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import com.jetbrains.teamsys.dnq.database.MessageBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.CharismaLicenseCheckerContainer;
import jetbrains.charisma.persistence.security.PermittedGroupUtil;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.Base64Attach;
import jetbrains.charisma.persistent.BaseCommentImpl;
import jetbrains.charisma.persistent.ConstraintsErrorMessageUtil;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.service.UserService;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.user.PasswordGenerator;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.url.UrlUtil;

public class IssueAttachmentImpl
extends PersistentFileImpl {
    private static String __ENTITY_TYPE__ = "IssueAttachment";

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(InputStream content, String name, String charset, String mimeType, String _entityType_) {
        Entity entity = super._constructor(content, name, charset, mimeType, _entityType_);
        this.init(entity);
        return entity;
    }

    protected Entity _constructor(DiskFileItem diskFileItem, String _entityType_) {
        Entity entity = super._constructor(diskFileItem, _entityType_);
        this.init(entity);
        return entity;
    }

    protected Entity _constructor(File file, String name, String _entityType_) {
        Entity entity = super._constructor(file, name, _entityType_);
        this.init(entity);
        return entity;
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor((InputStream)null, null, _entityType_);
        return entity;
    }

    public IncomingLinkViolation createIncomingLinkViolation(String name) {
        String linkName = name;
        if ("author".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerTypeErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ConstraintsErrorMessageUtil.createReportAboutAttachments(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueAttachment.author_of_attachments_in", new Object[0]), linkedEntities, hasMore);
                        }
                    });
                }
            };
        }
        return new IncomingLinkViolation(linkName);
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        boolean groupChanged = EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"permittedGroup");
        boolean userChanged = EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"permittedUser");
        if ((groupChanged || userChanged) && !PermittedGroupUtil.isPermittedGroupAllowed(AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) && (groupChanged && !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) || userChanged && !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser")))) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueAttachment.You_can_t_set_permitted_group_to_attachment_due_to_license_restrictions", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueAttachment.You_can_t_set_permitted_group_to_attachment_due_to_license_restrictions", new Object[0]), (Entity)((TransientEntity)entity)));
        }
    }

    public void setContent(InputStream content, Entity entity) {
        ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueAttachment")).checkLicenseSpaceLimitation(entity);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)content);
    }

    public void init(Entity entity) {
        ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueAttachment")).checkLicenseSpaceLimitation(entity);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"author", (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"created", (Comparable)Long.valueOf(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLicenseSpaceLimitation(Entity entity) {
        CharismaLicenseCheckerContainer charismaLicenseCheckerContainer = (CharismaLicenseCheckerContainer)ServiceLocator.getBean((String)"charismaLicenseChecker");
        synchronized (charismaLicenseCheckerContainer) {
            CharismaLicenseChecker.checkIsEnoughDiskSpace();
        }
    }

    @NotNull
    public Long getUpdated(Entity entity) {
        Long result;
        Long updated = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"updated", null);
        Long l = result = updated == null ? (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"created", null) : updated;
        if (result == null) {
            return 0L;
        }
        return result;
    }

    public boolean isAccessible(Entity user, Operation operation, Entity entity) {
        Entity issue = AssociationSemantics.getToOne((Entity)entity, (String)"issue");
        if (EntityOperations.equals((Entity)user, null)) {
            user = ((UserService)ServiceLocator.getBean((String)"userService")).getGuest();
        }
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isBanned(user)) {
            return false;
        }
        if (!EntityOperations.equals((Entity)issue, null) && ((Boolean)PrimitiveAssociationSemantics.get((Entity)issue, (String)"deleted", Boolean.class, null)).booleanValue() && operation != Operation.DELETE) {
            return false;
        }
        if (EntityOperations.equals((Entity)user, (Object)AssociationSemantics.getToOne((Entity)entity, (String)"author"))) {
            return true;
        }
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"comment"), null) && !((BaseCommentImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"comment"), (String)"BaseComment")).isAccessible(user, Operation.READ, AssociationSemantics.getToOne((Entity)entity, (String)"comment"))) {
            return false;
        }
        if (EntityOperations.equals((Entity)issue, null) || ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isAccessible(Operation.READ, user, issue)) {
            if (((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueAttachment")).isSecuredAttachmentAccessible(user, issue, entity)) {
                if (!EntityOperations.equals((Entity)issue, null)) {
                    return operation == Operation.READ || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission("IssueAttachment", operation, AssociationSemantics.getToOne((Entity)issue, (String)"project"), user);
                }
                return operation == Operation.READ || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission("IssueAttachment", operation, user);
            }
            return false;
        }
        return false;
    }

    public boolean isSecuredAttachmentAccessible(Entity user, Entity issue, Entity entity) {
        if (!EntityOperations.equals((Entity)issue, null) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.READ_HIDDEN_STUFF, AssociationSemantics.getToOne((Entity)issue, (String)"project"), user) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.READ_ISSUE, AssociationSemantics.getToOne((Entity)issue, (String)"project"), user)) {
            return true;
        }
        return QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) && QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser")) || QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser"), (Entity)user) || !QueryOperations.isEmpty((Iterable)QueryOperations.intersect((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup"), (Iterable)AssociationSemantics.getToMany((Entity)user, (String)"groups")));
    }

    public String getAccessCode(Entity entity) {
        if (IssueAttachmentImpl.isEmpty_m09u9q_a0a0n((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"accessCode", String.class, null))) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"accessCode", (Comparable)((Object)PasswordGenerator.generate()), String.class);
        }
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"accessCode", String.class, null);
    }

    public void setDraft(boolean isDraft, Entity entity) {
        if (isDraft) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"draft", (Comparable)Boolean.valueOf(true), Boolean.class);
        } else {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"draft", null);
        }
    }

    public void setPermittedGroup(Entity group, Entity entity) {
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedAttachments");
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleAttachments");
        if (!EntityOperations.equals((Entity)group, null) && !((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedAttachments", (Entity)group);
        }
    }

    public void setPermitted(Iterable<Entity> groups, Iterable<Entity> users, final Entity entity) {
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedAttachments");
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleAttachments");
        Sequence.fromIterable(groups).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedAttachments", (Entity)__addallit__);
            }
        });
        Sequence.fromIterable(users).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleAttachments", (Entity)__addallit__);
            }
        });
    }

    public boolean isSecured(Entity entity) {
        return !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) || !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser"));
    }

    public void updateFromBase64(Base64Attach base64, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"size", (Comparable)Long.valueOf(base64.getSize()), Long.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"mimeType", (Comparable)((Object)base64.getMimeType()), String.class);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)base64.getContent());
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"metaData", null, String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"charset", (Comparable)((Object)"UTF-8"), String.class);
        String newExtension = FilenameUtils.getExtension((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"mimeType", String.class, null)).replaceAll("/", "."));
        if (newExtension != null && newExtension.length() > 0) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"extension", (Comparable)((Object)newExtension), String.class);
        }
        if (this.isImage(entity)) {
            for (Entity item : Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"AttachmentThumbnail", (NodeBase)new LinkEqual("imageFile", entity)))) {
                EntityOperations.remove((Entity)item);
            }
        }
    }

    public String getUrl(Entity entity) {
        StringBuilder sb = new StringBuilder(UrlUtil.getPersistentFileUrl((Entity)entity, null, null, (Boolean)true));
        sb.append("&updated=").append(((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"IssueAttachment")).getUpdated(entity));
        return sb.toString();
    }

    public static Entity constructor(InputStream content, String name, String charset, String mimeType) {
        return ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(content, name, charset, mimeType, __ENTITY_TYPE__);
    }

    public static Entity constructor(DiskFileItem diskFileItem) {
        return ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(diskFileItem, __ENTITY_TYPE__);
    }

    public static Entity constructor(File file, String name) {
        return ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(file, name, __ENTITY_TYPE__);
    }

    public static Entity constructor() {
        return ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static boolean checkAccess(Entity attachment) {
        return IssueAttachmentImpl.checkAccess(attachment, Operation.READ);
    }

    public static boolean checkAccess(Entity attachment, Operation operation) {
        return IssueAttachmentImpl.checkAccess(attachment, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), operation);
    }

    public static boolean checkAccess(Entity attachment, Entity user, Operation operation) {
        return DnqUtils._instanceOf((Object)attachment, (String)"IssueAttachment") ? ((IssueAttachmentImpl)DnqUtils.getPersistentClassInstance((Entity)attachment, (String)"IssueAttachment")).isAccessible(user, operation, attachment) : true;
    }

    public static boolean canCreateAttachment(Entity issue) {
        return IssueAttachmentImpl.canCreateAttachment(issue, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
    }

    public static boolean canCreateAttachment(Entity issue, Entity user) {
        if (EntityOperations.equals((Entity)issue, null) || ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isAccessible(Operation.READ, user, issue)) {
            return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission("IssueAttachment", Operation.CREATE, AssociationSemantics.getToOne((Entity)issue, (String)"project"), user);
        }
        return false;
    }

    public static Iterable<Entity> applyPermissions(Iterable<Entity> attachments) {
        return IssueAttachmentImpl.applyPermissions(attachments, Operation.READ);
    }

    public static Iterable<Entity> applyPermissions(Iterable<Entity> attachments, Operation operation) {
        return IssueAttachmentImpl.applyPermissions(attachments, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), operation);
    }

    public static Iterable<Entity> applyPermissions(Iterable<Entity> attachments, final Entity user, final Operation operation) {
        return Sequence.fromIterable(attachments).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return IssueAttachmentImpl.checkAccess(it, user, operation);
            }
        });
    }

    public static void moveAttachments(final Entity source, final Entity target) {
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)source, (String)"attachments")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.removeToMany((Entity)source, (String)"attachments", (Entity)it);
                DirectedAssociationSemantics.createToMany((Entity)target, (String)"attachments", (Entity)it);
                DirectedAssociationSemantics.setToOne((Entity)it, (String)"issue", (Entity)target);
            }
        });
    }

    @Nullable
    public static Entity fromBase64(Base64Attach base64) {
        Entity attachment = IssueAttachmentImpl.constructor(base64.getContent(), base64.getName(), "UTF-8", base64.getMimeType());
        PrimitiveAssociationSemantics.set((Entity)attachment, (String)"size", (Comparable)Long.valueOf(base64.getSize()), Long.class);
        return attachment;
    }

    public static boolean isEmpty_m09u9q_a0a0n(String str) {
        return str == null || str.length() == 0;
    }
}

