/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import com.jetbrains.teamsys.dnq.database.MessageBuilder;
import com.jetbrains.teamsys.dnq.database.TransientEntityIterable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.event.EventMergeProvider;
import jetbrains.charisma.event.IEventIssueListener;
import jetbrains.charisma.links.persistent.DirectedLink;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeUtil;
import jetbrains.charisma.links.persistent.LinkAssociationsCache;
import jetbrains.charisma.links.persistent.LinkDirection;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.persistence.customfields.AbstractCustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.CustomFieldPrototypeImpl;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.DraftsProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.BaseCommentImpl;
import jetbrains.charisma.persistent.ConstraintsErrorMessageUtil;
import jetbrains.charisma.persistent.IssueAccessUtil;
import jetbrains.charisma.persistent.IssueAttachmentImpl;
import jetbrains.charisma.persistent.IssueCommentImpl;
import jetbrains.charisma.persistent.IssueCopyHandlers;
import jetbrains.charisma.persistent.IssueIdCache;
import jetbrains.charisma.persistent.IssueLinkTypeAux;
import jetbrains.charisma.service.IssueStateService;
import jetbrains.charisma.smartui.dto.IssueRequestDataHolder;
import jetbrains.charisma.smartui.persistent.IssueTagImpl;
import jetbrains.charisma.smartui.watchFolder.StarService;
import jetbrains.charisma.smartui.watchFolder.WatchFolderImpl;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinkNotNull;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.issue.IssueKeyImpl;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Permissions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.BaseApplication;

public class IssueImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "Issue";
    private static final Log securityLog = LogFactory.getLog((String)"security");
    private static final ThreadLocal<Boolean> DISABLE_UPDATE = new ThreadLocal();
    private static final ThreadLocal<Boolean> DISABLE_DUPLICATES_PROCESSING = new ThreadLocal();
    public static final String ISSUE_ID_REGEX = "[a-zA-Z0-9_]+\\-\\d+";
    protected static Log log = LogFactory.getLog(IssueImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(Entity reporter, Entity project, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        this.init(reporter, project, entity);
        this.trace("New issue created", entity);
        return entity;
    }

    protected Entity _constructor(Entity copy, String _entityType_) {
        final Entity entity = this._constructor(AssociationSemantics.getToOne((Entity)copy, (String)"reporter"), AssociationSemantics.getToOne((Entity)copy, (String)"project"), _entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"summary", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)copy, (String)"summary", String.class, null)), String.class);
        PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)entity, (String)"description", (String)PrimitiveAssociationSemantics.getBlobAsString((Entity)copy, (String)"description"));
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"usesMarkdown", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)copy, (String)"usesMarkdown", Boolean.class, null)), Boolean.class);
        if (!QueryOperations.isEmpty((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)copy, (String)"tags")).disjunction(Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"tags")))) || !QueryOperations.isEmpty((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"tags")).disjunction(Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)copy, (String)"tags"))))) {
            UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"tags", (String)"issues");
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)copy, (String)"tags")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity __addallit__) {
                    UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"tags", (String)"issues", (Entity)__addallit__);
                }
            });
        }
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)copy, (String)"permittedGroup")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedIssues", (Entity)__addallit__);
            }
        });
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)copy, (String)"permittedUser")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleIssues", (Entity)__addallit__);
            }
        });
        if (!QueryOperations.isEmpty((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)copy, (String)"comments")).disjunction(Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"comments")))) || !QueryOperations.isEmpty((Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"comments")).disjunction(Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)copy, (String)"comments"))))) {
            AggregationAssociationSemantics.clearOneToMany((Entity)entity, (String)"comments");
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)copy, (String)"comments")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity __addallit__) {
                    AggregationAssociationSemantics.createOneToMany((Entity)entity, (String)"comments", (String)"issue", (Entity)__addallit__);
                }
            });
        }
        IssueLinkPrototypeUtil.moveAllLinksTo(copy, entity);
        IssueAttachmentImpl.moveAttachments(copy, entity);
        ((IssueCopyHandlers)ServiceLocator.getBean((String)"issueCopyHandlers")).handle(copy, entity);
        return entity;
    }

    public IncomingLinkViolation createIncomingLinkViolation(String name) {
        String linkName = name;
        if ("reporter".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerTypeErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ConstraintsErrorMessageUtil.createReportAboutIssues(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.reporter_of", new Object[0]), linkedEntities, hasMore);
                        }
                    });
                }
            };
        }
        if ("updatedBy".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerTypeErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ConstraintsErrorMessageUtil.createReportAboutIssues(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.user_who_has_updated", new Object[0]), linkedEntities, hasMore);
                        }
                    });
                }
            };
        }
        return new IncomingLinkViolation(linkName);
    }

    public boolean isPropertyRequired(String name, Entity entity) {
        if (name.equals("created")) {
            return !this.isDraft(entity);
        }
        if (name.equals("numberInProject")) {
            return !this.isDraft(entity);
        }
        if (name.equals("summary")) {
            return !this.isDraft(entity);
        }
        if (name.equals("updated")) {
            return !this.isDraft(entity);
        }
        return false;
    }

    public String getDisplayName(Entity entity) {
        super.getDisplayName(entity);
        return (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"project"), (String)"shortName", String.class, null) + "-" + PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"numberInProject", Long.class, null);
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
    }

    public void delete(Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"deleted", (Comparable)Boolean.valueOf(true), Boolean.class);
    }

    public void undelete(Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"deleted", (Comparable)Boolean.valueOf(false), Boolean.class);
    }

    private void markDeleted(Entity entity) {
        jetbrains.exodus.core.dataStructures.hash.HashSet rec = new jetbrains.exodus.core.dataStructures.hash.HashSet();
        Entity duplicate = ((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate();
        Sequence.fromIterable(IssueLinkPrototypeUtil.getLinkedIssues(entity, ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)duplicate, (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.BOTH, duplicate))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Set)rec){
            final /* synthetic */ Set val$rec;
            {
                this.val$rec = set;
            }

            public void visit(Entity it) {
                this.val$rec.add(it);
            }
        });
        IssueLinkPrototypeUtil.clearAllLinks(entity, LinkDirection.BOTH);
        for (Entity it : rec) {
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).recountVotes(it);
        }
    }

    public Entity getRootIssue(Entity entity) {
        Entity root = entity;
        while (!EntityOperations.equals((Entity)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).getParentIssue(root), null)) {
            root = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).getParentIssue(root);
        }
        return root;
    }

    public Entity getParentIssue(Entity entity) {
        return IssueImpl.getParentIssue(IssueLinkPrototypeImpl.getSubtaskAssociations(), entity);
    }

    public Iterable<Entity> getSubtasks(Entity entity) {
        Iterable<Entity> result = IssueLinkPrototypeUtil.getLinkedIssues(entity, ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getSubtask(), (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.OUTWARD, ((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getSubtask()));
        if (result instanceof TransientEntityIterable && QueryOperations.isEmpty(result)) {
            return Collections.EMPTY_LIST;
        }
        return Sequence.fromIterable(result).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).isDraft(it);
            }
        });
    }

    public Entity self(Entity entity) {
        return entity;
    }

    public Entity clone(Entity entity) {
        Entity issue = IssueImpl.constructor(entity);
        return issue;
    }

    private void trace(String msg, Entity entity) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getId(entity) + "] " + msg));
        }
    }

    public void clear(final Entity entity) {
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).trace("Clear issue", entity);
        if (!this.isDraft(entity)) {
            throw new RuntimeException("Can only clear a draft issue");
        }
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"attachments")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.removeToMany((Entity)entity, (String)"attachments", (Entity)it);
                EntityOperations.remove((Entity)it);
            }
        });
        AggregationAssociationSemantics.clearOneToMany((Entity)entity, (String)"comments");
        IssueLinkPrototypeUtil.clearAllLinks(entity, LinkDirection.BOTH);
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"tags", (String)"issues");
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedIssues");
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleIssues");
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).init(AssociationSemantics.getToOne((Entity)entity, (String)"reporter"), null, entity);
    }

    private void init(Entity reporter, Entity project, Entity entity) {
        CharismaLicenseChecker.checkIsEnoughDiskSpace();
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"reporter", (Entity)reporter);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"summary", null, String.class);
        PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)entity, (String)"description", null);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"votes", (Comparable)Integer.valueOf(0), Integer.class);
        if (EntityOperations.equals((Entity)project, null)) {
            AggregationAssociationSemantics.setManyToOne((Entity)new DraftsProvider(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()).getDraftInitialProject(), (String)"issues", (String)"project", (Entity)entity);
        } else {
            AggregationAssociationSemantics.setManyToOne((Entity)project, (String)"issues", (String)"project", (Entity)entity);
        }
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"numberInProject", (Comparable)Integer.valueOf(0), Long.class);
        Long _now = ((IEventIssueListener)ServiceLocator.getBean((String)"eventIssueListener")).getCurrentTime();
        Entity _loggedInUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"updated", (Comparable)_now);
        DirectedAssociationSemantics.setToOne((Entity)entity, (String)"updatedBy", (Entity)_loggedInUser);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"created", (Comparable)_now);
        this.setDefaultCustomFieldValues(entity);
    }

    public void setSummaryAndDescription(String summary, String description, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"summary", summary == null || summary.length() == 0 ? null : summary.replaceAll("\\r|\\n", " "), String.class);
        PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)entity, (String)"description", description == null || description.length() == 0 ? null : description);
    }

    public void checkSummary(Entity entity) {
        if (IssueImpl.isEmpty_i3gncs_a0a0t((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"summary", String.class, null))) {
            throw new LocalizedLogicException((Localization)new LocalizationObject("Errors.Summary_is_required", new Object[0]));
        }
    }

    public String getId(Entity entity) {
        StringBuilder builder = new StringBuilder();
        this.appendId(builder, entity);
        return builder.toString();
    }

    public long getPersistentLocalId(Entity entity) {
        return entity.getId().getLocalId();
    }

    public boolean isDraft(Entity entity) {
        return !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"draftOwner"), null);
    }

    public boolean isReported(Entity entity) {
        return !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isDraft(entity) && !EntityOperations.isNew((Entity)entity) && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"deleted", Boolean.class, null) == false;
    }

    public boolean becomesReported(Entity entity) {
        return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"draftOwner"), null) && (!EntityOperations.equals((Entity)QueryOperations.getFirst((Iterable)AssociationSemantics.getRemovedLinks((TransientEntity)((TransientEntity)entity), (String)"draftOwner")), null) || EntityOperations.isNew((Entity)entity));
    }

    public String getFirstId(Entity entity) {
        StringBuilder builder = new StringBuilder();
        Entity firstKey = QueryOperations.getFirst((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"projectTrace"));
        if (EntityOperations.equals((Entity)firstKey, null)) {
            this.appendId(builder, entity);
        } else {
            ((IssueKeyImpl)DnqUtils.getPersistentClassInstance((Entity)firstKey, (String)"IssueKey")).appendId(builder, firstKey);
        }
        return builder.toString();
    }

    public String getTitle(Entity entity) {
        String summary = (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"summary", String.class, null);
        int summaryLength = summary == null || summary.length() == 0 ? 0 : summary.length();
        StringBuilder builder = new StringBuilder(summaryLength + 16);
        this.appendId(builder, entity);
        builder.append(": ");
        builder.append(summary);
        return builder.toString();
    }

    public void update(Entity entity) {
        if (IssueImpl.isUpdateEnabled()) {
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).doUpdate(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), entity);
        }
    }

    public void doUpdate(Entity currentUser, Entity entity) {
        if (!EntityOperations.equals((Entity)currentUser, null) && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).isSystem(currentUser)) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"updated", (Comparable)Long.valueOf(((IEventIssueListener)ServiceLocator.getBean((String)"eventIssueListener")).getCurrentTime()));
            DirectedAssociationSemantics.setToOne((Entity)entity, (String)"updatedBy", (Entity)currentUser);
        }
    }

    public void watch(Entity user, Entity entity) {
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isGuest(user)) {
            return;
        }
        Entity tag = ((StarService)ServiceLocator.getBean((String)"starService")).findOrCreateStar(user);
        UndirectedAssociationSemantics.createManyToMany((Entity)tag, (String)"issues", (String)"tags", (Entity)entity);
    }

    public void unwatch(Entity user, Entity entity) {
        Entity tag = ((StarService)ServiceLocator.getBean((String)"starService")).findStar(user);
        if (!EntityOperations.equals((Entity)tag, null)) {
            UndirectedAssociationSemantics.removeManyToMany((Entity)tag, (String)"issues", (String)"tags", (Entity)entity);
        }
    }

    public boolean isResolved(Entity entity) {
        return DateTimeOperations.isNotNull((Long)((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"resolved", null)));
    }

    public boolean becomesResolved(Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isResolved(entity) && EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"resolved");
    }

    public boolean becomesUnresolved(Entity entity) {
        return !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isResolved(entity) && EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"resolved");
    }

    public boolean isEmptySummaryAndDescription(Entity entity) {
        return IssueImpl.isEmpty_i3gncs_a0a0a43_0((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"summary", String.class, null)) && IssueImpl.isEmpty_i3gncs_a0a0a43(PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"description"));
    }

    public boolean hasAttachments(Entity entity) {
        return !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"attachments"));
    }

    public boolean isAccessible(Operation operation, Entity entity) {
        return this.isAccessible(operation, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), entity);
    }

    public boolean isAccessible(Operation operation, Entity user, Entity entity) {
        if (user == null) {
            return false;
        }
        Entity draftOwner = AssociationSemantics.getToOne((Entity)entity, (String)"draftOwner");
        if (draftOwner != null) {
            if (!EntityOperations.equals((Entity)draftOwner, (Object)user)) {
                return false;
            }
            if (operation == Operation.DELETE) {
                return true;
            }
        }
        if (AssociationSemantics.getToOne((Entity)entity, (String)"project") != null) {
            return IssueAccessUtil.isAccessibleNonDraft(entity, operation, user, null, null, AssociationSemantics.getToOne((Entity)entity, (String)"project"));
        }
        return EntityOperations.equals((Entity)user, (Object)AssociationSemantics.getToOne((Entity)entity, (String)"reporter"));
    }

    public boolean isAccessibleWith(Operation operation, Entity user, IssueAccessUtil.GroupsGetter groupsGetter, IssueAccessUtil.UsersGetter usersGetter, IssueAccessUtil.ProjectGetter projectGetter, Entity entity) {
        if (user == null) {
            return false;
        }
        Entity draftOwner = AssociationSemantics.getToOne((Entity)entity, (String)"draftOwner");
        if (draftOwner != null && !EntityOperations.equals((Entity)draftOwner, (Object)user)) {
            return false;
        }
        Entity project = projectGetter == null ? AssociationSemantics.getToOne((Entity)entity, (String)"project") : projectGetter.invoke();
        if (project != null) {
            return IssueAccessUtil.isAccessibleNonDraft(entity, operation, user, groupsGetter, usersGetter, project);
        }
        return EntityOperations.equals((Entity)user, (Object)AssociationSemantics.getToOne((Entity)entity, (String)"reporter"));
    }

    public Entity getDuplicateRoot(Entity entity) {
        long cluster = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"duplicateCluster", Long.class, null);
        if (cluster == 0L) {
            return null;
        }
        int typeId = entity.getId().getTypeId();
        return DnqUtils.getCurrentTransientSession().getEntity((EntityId)new PersistentEntityId(typeId, cluster - 1L));
    }

    public Iterable<Entity> getDuplicateCluster(Entity entity) {
        long cluster = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"duplicateCluster", Long.class, null);
        if (cluster == 0L) {
            return QueryOperations.singleton((Entity)entity);
        }
        return QueryOperations.query(null, (String)"Issue", (NodeBase)new PropertyEqual("duplicateCluster", (Comparable)Long.valueOf(cluster)));
    }

    private void recursiveDuplicateSearch(List<Entity> output, LongHashSet visited, Entity entity) {
        visited.add(this.getPersistentLocalId(entity));
        DirectedLink duplicates = ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate(), (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.OUTWARD, ((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate());
        for (Entity issue : Sequence.fromIterable(IssueLinkPrototypeUtil.getLinkedIssues(entity, duplicates))) {
            if (visited.contains(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getPersistentLocalId(issue))) continue;
            ListSequence.fromList(output).addElement((Object)issue);
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).recursiveDuplicateSearch(output, visited, issue);
        }
    }

    private Tuples._2<Entity, List<Entity>> getDuplicateClusterUnflushed(Entity entity) {
        Entity root = this.getRootDuplicate(entity);
        List<Entity> cached = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).getCachedDuplicateClusterUnflushed(root);
        if (cached != null) {
            return MultiTuple.from((Object)root, cached);
        }
        IListSequence result = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)result).addElement((Object)root);
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).recursiveDuplicateSearch((List<Entity>)result, new LongHashSet(), root);
        ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).setCachedDuplicateClusterUnflushed((List<Entity>)result, root);
        return MultiTuple.from((Object)root, (Object)result);
    }

    @Nullable
    private List<Entity> getCachedDuplicateClusterUnflushed(Entity entity) {
        IssueRequestDataHolder dto = IssueRequestDataHolder.get();
        if (dto == null) {
            return null;
        }
        return dto.getDuplicateClusterUnflushed(entity);
    }

    private void setCachedDuplicateClusterUnflushed(List<Entity> cluster, Entity entity) {
        IssueRequestDataHolder dto = IssueRequestDataHolder.get();
        if (dto != null) {
            dto.setDuplicateClusterUnflushed(entity, cluster);
        }
    }

    public boolean isSecured(Entity entity) {
        return !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) || !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser"));
    }

    public void setPermittedGroup(Entity group, Entity entity) {
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedIssues");
        if (!EntityOperations.equals((Entity)group, null) && !((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedIssues", (Entity)group);
        }
    }

    public void setPermitted(Iterable<Entity> groups, Iterable<Entity> users, final Entity entity) {
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedIssues");
        UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleIssues");
        Sequence.fromIterable(groups).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedIssues", (Entity)__addallit__);
            }
        });
        Sequence.fromIterable(users).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity __addallit__) {
                UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleIssues", (Entity)__addallit__);
            }
        });
    }

    @Deprecated
    public Entity getPermittedGroup(Entity entity) {
        return QueryOperations.getFirst((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup"));
    }

    public Iterable<Entity> getAllVoters(Map<Entity, Entity> voteFor, Entity entity) {
        Iterable rep;
        Iterable component;
        long cluster = 0L;
        Entity reporter = AssociationSemantics.getToOne((Entity)entity, (String)"reporter");
        if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isDuplicateRoot(entity) && (cluster = ((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"duplicateCluster", Long.class, null)).longValue()) != 0L) {
            component = QueryOperations.query((Iterable)QueryOperations.exclude((Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new PropertyEqual("duplicateCluster", (Comparable)Long.valueOf(cluster))), (Iterable)AssociationSemantics.getToMany((Entity)reporter, (String)"votedIssues")), (String)"Issue", (NodeBase)new LinkNotNull("voters"));
            rep = QueryOperations.query((Iterable)QueryOperations.exclude((Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new PropertyEqual("duplicateCluster", (Comparable)Long.valueOf(cluster))), (Iterable)AssociationSemantics.getToMany((Entity)reporter, (String)"votedIssues")), (String)"Issue", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("reporter", reporter)));
        } else {
            component = QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"voters"), (Entity)reporter) ? QueryOperations.empty((String)"Issue") : QueryOperations.singleton((Entity)entity);
            rep = QueryOperations.empty((String)"Issue");
        }
        if (voteFor != null) {
            Entity dupReporter;
            for (Entity issue : Sequence.fromIterable((Iterable)component)) {
                for (Entity user : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"voters"))) {
                    MapSequence.fromMap(voteFor).put((Object)user, (Object)issue);
                }
                if (cluster == 0L || cluster == ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getPersistentLocalId(issue) + 1L) continue;
                dupReporter = AssociationSemantics.getToOne((Entity)issue, (String)"reporter");
                if (!EntityOperations.equals((Entity)((Entity)MapSequence.fromMap(voteFor).get((Object)dupReporter)), null)) continue;
                MapSequence.fromMap(voteFor).put((Object)dupReporter, (Object)issue);
            }
            for (Entity issue : Sequence.fromIterable((Iterable)rep)) {
                dupReporter = AssociationSemantics.getToOne((Entity)issue, (String)"reporter");
                if (!EntityOperations.equals((Entity)((Entity)MapSequence.fromMap(voteFor).get((Object)dupReporter)), null)) continue;
                MapSequence.fromMap(voteFor).put((Object)dupReporter, (Object)issue);
            }
        }
        return QueryOperations.union((Iterable)QueryOperations.selectManyDistinct((Iterable)component, (String)"voters"), (Iterable)QueryOperations.selectDistinct((Iterable)rep, (String)"reporter"));
    }

    public Iterable<Entity> getDuplicateVoters(Map<Entity, Entity> voteFor, Entity entity) {
        Iterable duplicateVoters = QueryOperations.empty((String)"User");
        if (this.isDuplicateRoot(entity)) {
            final Entity currentUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
            duplicateVoters = Sequence.fromIterable((Iterable)QueryOperations.exclude(this.getAllVoters(voteFor, entity), (Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"voters"))).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return !EntityOperations.equals((Entity)it, null);
                }
            });
            boolean voteForThisIssue = QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"voters"), (Entity)currentUser);
            if (voteForThisIssue) {
                duplicateVoters = Sequence.fromIterable((Iterable)duplicateVoters).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                    public boolean accept(Entity it) {
                        return !EntityOperations.equals((Entity)it, (Object)currentUser);
                    }
                });
            }
        }
        return Sequence.fromIterable((Iterable)duplicateVoters).toListSequence();
    }

    public Iterable<Entity> getDuplicatesWithTag(Entity tag, Entity entity) {
        return QueryOperations.query(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getDuplicateCluster(entity), (String)"Issue", (NodeBase)new LinkEqual("tags", tag));
    }

    public boolean isDuplicateRoot(Entity entity) {
        long cluster = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"duplicateCluster", Long.class, null);
        if (cluster == 0L) {
            return false;
        }
        return cluster == ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getPersistentLocalId(entity) + 1L;
    }

    public boolean isInDuplicateCluster(Entity entity) {
        return (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"duplicateCluster", Long.class, null) > 0L;
    }

    public Entity getDuplicates(Entity entity) {
        return QueryOperations.getFirst(IssueLinkPrototypeUtil.getLinkedIssues(entity, ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate(), (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.INWARD, ((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate())));
    }

    private Entity duplicatesRootSearch(Set<Entity> was, Entity entity) {
        DirectedLink duplicatedParent = ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate(), (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.INWARD, ((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate());
        for (Entity duplicatedIssue : Sequence.fromIterable(IssueLinkPrototypeUtil.getLinkedIssues(entity, duplicatedParent))) {
            Entity root;
            if (EntityOperations.equals((Entity)duplicatedIssue, null)) continue;
            if (was == null) {
                was = new HashSet<Entity>();
            }
            was.add(entity);
            if (was.contains(duplicatedIssue) || EntityOperations.equals((Entity)(root = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)duplicatedIssue, (String)"Issue")).duplicatesRootSearch(was, duplicatedIssue)), null)) continue;
            return root;
        }
        return entity;
    }

    public Entity getRootDuplicate(Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).duplicatesRootSearch(null, entity);
    }

    public boolean hasComments(Entity entity) {
        return !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"comments")) && !QueryOperations.isEmpty(this.getAccessibleComments(false, entity));
    }

    public boolean hasTags(Entity entity) {
        return !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"tags"));
    }

    public long getCommentsCount(Entity entity) {
        Entity me = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        boolean canReadComments = ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)me, (String)"User")).hasPermission(Permission.READ_COMMENT, AssociationSemantics.getToOne((Entity)entity, (String)"project"), me);
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getCommentsCount(canReadComments, true, entity);
    }

    public long getCommentsCount(boolean canReadComments, boolean exact, Entity entity) {
        Integer c;
        if (canReadComments && (c = (Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"commentsCount", Integer.class, null)) != null && c >= 0) {
            return c.intValue();
        }
        Iterable<Entity> iterable = this.getAccessibleComments(true, canReadComments, entity);
        if (exact) {
            return QueryOperations.getSize(iterable);
        }
        return QueryOperations.roughSize(iterable);
    }

    public Iterable<Entity> getComments(Entity entity) {
        return this.getComments(true, entity);
    }

    private Iterable<Entity> getComments(boolean exceptDeleted, Entity entity) {
        TreeKeepingEntityIterable issueComments = QueryOperations.query(null, (String)"IssueComment", (NodeBase)new LinkEqual("issue", entity));
        if (exceptDeleted) {
            issueComments = QueryOperations.query((Iterable)issueComments, (String)"IssueComment", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("deleted", (Comparable)Boolean.TRUE)));
        }
        return issueComments;
    }

    public Iterable<Entity> getAccessibleComments(boolean exceptDeleted, Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getAccessibleComments(exceptDeleted, ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).hasPermission("IssueComment", Operation.READ, AssociationSemantics.getToOne((Entity)entity, (String)"project"), ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()), entity);
    }

    private Iterable<Entity> getAccessibleComments(boolean exceptDeleted, boolean canReadComments, Entity entity) {
        Iterable<Entity> issueComments = this.getComments(exceptDeleted, entity);
        return ((Permissions)ServiceLocator.getBean((String)"permissions")).apply(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), canReadComments, issueComments);
    }

    public Iterable<Entity> getAccessibleCommentsSorted(boolean asc, Entity entity) {
        TreeKeepingEntityIterable issueComments = QueryOperations.query(this.getComments(false, entity), (String)"IssueComment", (NodeBase)new SortByProperty(null, "created", asc));
        Entity currentUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        boolean canReadComments = ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).hasPermission("IssueComment", Operation.READ, AssociationSemantics.getToOne((Entity)entity, (String)"project"), currentUser);
        return ((Permissions)ServiceLocator.getBean((String)"permissions")).apply(currentUser, canReadComments, (Iterable)issueComments);
    }

    private void setDefaultCustomFieldValues(Entity entity) {
        TreeKeepingEntityIterable projectFields = QueryOperations.query(null, (String)"ProjectCustomField", (NodeBase)new LinkEqual("project", AssociationSemantics.getToOne((Entity)entity, (String)"project")));
        for (Entity cf : Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)projectFields, (String)"ProjectCustomField", (NodeBase)new LinkEqual("condition", null)))) {
            ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)cf, (String)"prototype"), (String)"CustomFieldPrototype")).setValues(entity, ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)cf, (String)"ProjectCustomField")).getDefaultValues(cf), AssociationSemantics.getToOne((Entity)cf, (String)"prototype"));
        }
        for (Entity cf : Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)projectFields, (String)"ProjectCustomField", (NodeBase)new UnaryNot((NodeBase)new LinkEqual("condition", null))))) {
            if (((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)cf, (String)"ProjectCustomField")).isVisibleInIssue(entity, cf)) {
                ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)cf, (String)"prototype"), (String)"CustomFieldPrototype")).setValues(entity, ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)cf, (String)"ProjectCustomField")).getDefaultValues(cf), AssociationSemantics.getToOne((Entity)cf, (String)"prototype"));
                continue;
            }
            ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)cf, (String)"prototype"), (String)"CustomFieldPrototype")).setValue(entity, null, AssociationSemantics.getToOne((Entity)cf, (String)"prototype"));
        }
    }

    public String getUrl(Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getUrl(false, entity);
    }

    public String getUrl(boolean local, Entity entity) {
        String prefix = local && BaseApplication.isInsideRequestProcessing() ? BaseApplication.getRequest().getContextPath() : (String)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"baseUrl", String.class, null);
        return prefix + "/issue/" + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getId(entity);
    }

    public Iterable<Entity> getAccessibleCustomFields(final Entity user, final Entity entity) {
        return Sequence.fromIterable((Iterable)((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"Project")).getSortedFields(AssociationSemantics.getToOne((Entity)entity, (String)"project"))).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).isReadAccessible(entity, user, it);
            }
        });
    }

    public Iterable<Entity> getAccessibleCustomFields(Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getAccessibleCustomFields(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), entity);
    }

    public boolean hasVote(Entity user, Entity entity) {
        return this.isDuplicateRoot(entity) ? !QueryOperations.isEmpty((Iterable)QueryOperations.intersect((Iterable)QueryOperations.union((Iterable)AssociationSemantics.getToMany((Entity)user, (String)"votedIssues"), (Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new LinkEqual("reporter", user))), this.getDuplicateCluster(entity))) : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)user, (String)"votedIssues")).contains((Object)entity);
    }

    public boolean canVote(Entity currentUser, Entity entity) {
        return !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"reporter"), (Object)currentUser) && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).isGuest(currentUser) && !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).hasVote(currentUser, entity);
    }

    public boolean canChangeProject(Entity entity) {
        return this.isDraft(entity) || this.isAccessible(Operation.PRIVATE_UPDATE, entity);
    }

    public boolean canChangeProject(Entity user, Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isDraft(entity) || ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isAccessible(Operation.PRIVATE_UPDATE, user, entity);
    }

    public boolean canUnvote(Entity currentUser, Entity entity) {
        return !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"reporter"), (Object)currentUser) && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).isGuest(currentUser) && ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).hasVote(currentUser, entity);
    }

    public String toggleVote(Entity entity) {
        Entity currentUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).hasVote(currentUser, entity)) {
            this.unvote(currentUser, entity);
        } else {
            if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"reporter"), (Object)currentUser)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.You_can_t_vote_for_an_issue_that_you_reported", new Object[0]);
            }
            if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)currentUser, (String)"User")).isGuest(currentUser)) {
                return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.Guest_can_t_vote_for_issues", new Object[0]);
            }
            this.vote(currentUser, entity);
        }
        return null;
    }

    public void vote(Entity currentUser, Entity entity) {
        if (this.canVote(currentUser, entity)) {
            UndirectedAssociationSemantics.createManyToMany((Entity)entity, (String)"voters", (String)"votedIssues", (Entity)currentUser);
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"votes", (Comparable)Integer.valueOf((Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"votes", Integer.class, null) + 1), Integer.class);
        }
    }

    public void unvote(Entity currentUser, Entity entity) {
        if (this.canUnvote(currentUser, entity)) {
            UndirectedAssociationSemantics.removeManyToMany((Entity)entity, (String)"voters", (String)"votedIssues", (Entity)currentUser);
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"votes", (Comparable)Integer.valueOf((Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"votes", Integer.class, null) - 1), Integer.class);
        }
    }

    private void recountVotes(Entity entity) {
        IssueRequestDataHolder dto = IssueRequestDataHolder.get();
        if (dto != null && dto.areVotesRecountedFor(entity)) {
            return;
        }
        DirectedLink duplicates = ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate(), (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.INWARD, ((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate());
        if (!QueryOperations.isEmpty(IssueLinkPrototypeUtil.getLinkedIssues(entity, duplicates))) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"votes", (Comparable)Long.valueOf(AssociationSemantics.getToManySize((Entity)entity, (String)"voters")), Integer.class);
        } else {
            ISequence cluster = ListSequence.fromList((List)((List)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getDuplicateClusterUnflushed(entity)._1())).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return !EntityOperations.equals((Entity)it, null) && !EntityOperations.isRemoved((Entity)it);
                }
            });
            Entity reporter = AssociationSemantics.getToOne((Entity)entity, (String)"reporter");
            long reporterId = EntityOperations.equals((Entity)reporter, null) ? -1L : ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)reporter, (String)"User")).getPersistentLocalId(reporter);
            LongHashSet votersAndReporters = new LongHashSet();
            for (Entity issue : Sequence.fromIterable((Iterable)cluster)) {
                for (Entity user : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"voters"))) {
                    long userId = ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getPersistentLocalId(user);
                    if (userId == reporterId) continue;
                    votersAndReporters.add(userId);
                }
                reporter = AssociationSemantics.getToOne((Entity)issue, (String)"reporter");
                long userId = EntityOperations.equals((Entity)reporter, null) ? -1L : ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)reporter, (String)"User")).getPersistentLocalId(reporter);
                if (userId == reporterId) continue;
                votersAndReporters.add(userId);
            }
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"votes", (Comparable)Integer.valueOf(votersAndReporters.size()), Integer.class);
        }
        if (dto != null) {
            dto.votesRecountedFor(entity);
        }
    }

    public Entity getProject(Entity entity) {
        return AssociationSemantics.getToOne((Entity)entity, (String)"project");
    }

    public Iterable<Entity> getTags(Entity user, Entity entity) {
        return IssueTagImpl.applyPermissions(user, AssociationSemantics.getToMany((Entity)entity, (String)"tags"));
    }

    public Iterable<Entity> getTags(Entity entity) {
        return this.getTags(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), entity);
    }

    public List<Entity> getExplicitTags(Entity entity) {
        Entity loggedInUser = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getExplicitTags(((StarService)ServiceLocator.getBean((String)"starService")).findStar(loggedInUser), loggedInUser, entity);
    }

    public List<Entity> getExplicitTags(final Entity star, final Entity user, Entity entity) {
        Object result = Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"tags")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"WatchFolder")).isAccessible(Operation.READ, user, it) && !EntityOperations.equals((Entity)it, (Object)star);
            }
        }).toListSequence();
        if (QueryOperations.isEmpty((Iterable)result)) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public List<Entity> getExplicitTags(Entity user, Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getExplicitTags(((StarService)ServiceLocator.getBean((String)"starService")).findStar(user), user, entity);
    }

    public boolean hasTag(String name, Entity entity) {
        return !QueryOperations.isEmpty((Iterable)Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"tags"), (String)"IssueTag", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name)))).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return ((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"WatchFolder")).isAccessible(Operation.READ, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), it);
            }
        }));
    }

    public boolean isStarred(Entity entity) {
        Entity star = ((StarService)ServiceLocator.getBean((String)"starService")).findStar(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).hasTag(star, entity);
    }

    public boolean isStarred(Entity user, Entity entity) {
        Entity star = ((StarService)ServiceLocator.getBean((String)"starService")).findStar(user);
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).hasTag(star, entity);
    }

    public boolean hasTag(@Nullable Entity tag, Entity entity) {
        if (EntityOperations.equals((Entity)tag, null)) {
            return false;
        }
        return QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"tags"), (Entity)tag);
    }

    public boolean isUpdatedOnlyInstantly(Entity entity) {
        if (EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"updatedBy"), (Object)AssociationSemantics.getToOne((Entity)entity, (String)"reporter"))) {
            long diff = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"updated", null) - (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"created", null);
            return diff < ((EventMergeProvider)ServiceLocator.getBean((String)"eventMergeProvider")).getMergeIdleTime();
        }
        return false;
    }

    public Iterable<Entity> getAttachments(Entity entity) {
        return AssociationSemantics.getToMany((Entity)entity, (String)"attachments");
    }

    public void clearAttachments(Entity entity) {
        DirectedAssociationSemantics.clearToMany((Entity)entity, (String)"attachments");
    }

    public void addAttachment(Entity attachment, Entity entity) {
        DirectedAssociationSemantics.createToMany((Entity)entity, (String)"attachments", (Entity)attachment);
        DirectedAssociationSemantics.setToOne((Entity)attachment, (String)"issue", (Entity)entity);
    }

    public void removeAttachment(Entity attachment, Entity entity) {
        DirectedAssociationSemantics.removeToMany((Entity)entity, (String)"attachments", (Entity)attachment);
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)attachment, (String)"comment"), null)) {
            UndirectedAssociationSemantics.removeOneToMany((Entity)AssociationSemantics.getToOne((Entity)attachment, (String)"comment"), (String)"attachments", (String)"comment", (Entity)attachment);
        }
        PrimitiveAssociationSemantics.setBlob((Entity)attachment, (String)"content", (InputStream)null);
        PrimitiveAssociationSemantics.set((Entity)attachment, (String)"removed", (Comparable)Boolean.valueOf(true), Boolean.class);
    }

    public boolean hasNotOwnVisibleCommentsAdd(Entity u, Entity entity) {
        for (Entity it : AssociationSemantics.getAddedLinks((TransientEntity)((TransientEntity)entity), (String)"comments")) {
            if (EntityOperations.equals((Entity)((IssueCommentImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"IssueComment")).getUpdatedBy(it), (Object)u) || !((IssueCommentImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"IssueComment")).isAccessible(u, Operation.READ, it)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTagsChanges(Entity u, Entity entity) {
        for (Entity it : AssociationSemantics.getAddedLinks((TransientEntity)((TransientEntity)entity), (String)"tags")) {
            if (!((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"WatchFolder")).isAccessible(Operation.READ, u, it)) continue;
            return true;
        }
        for (Entity it : AssociationSemantics.getRemovedLinks((TransientEntity)((TransientEntity)entity), (String)"tags")) {
            if (!((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"WatchFolder")).isAccessible(Operation.READ, u, it)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPropertiesChanges(Entity user, Entity entity) {
        ArrayList<String> properties = new ArrayList<String>();
        for (Entity pcf : Sequence.fromIterable(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getAccessibleCustomFields(user, entity))) {
            properties.add(((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)pcf, (String)"prototype"), (String)"AbstractCustomFieldPrototype")).getId(AssociationSemantics.getToOne((Entity)pcf, (String)"prototype")));
        }
        return EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String[])properties.toArray(new String[properties.size()]));
    }

    public boolean hasSummaryOrDescriptionChanges(Entity entity) {
        return EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"summary") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"description");
    }

    public Entity addComment(String text, Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).addComment(text, null, entity);
    }

    public Entity addComment(String text, @Nullable Entity author, Entity entity) {
        return IssueCommentImpl.constructor(text, EntityOperations.equals((Entity)author, null) ? ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get() : author, entity);
    }

    private void assignIssueNumberToMovedIssue(Entity entity) {
        Entity project = AssociationSemantics.getToOne((Entity)entity, (String)"project");
        Entity issueKey = QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"projectTrace"), (String)"IssueKey", (NodeBase)new LinkEqual("project", project)));
        if (EntityOperations.equals((Entity)project, null)) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"numberInProject", (Comparable)Integer.valueOf(0), Long.class);
            return;
        }
        if (EntityOperations.equals((Entity)issueKey, null) || !QueryOperations.isEmpty((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)project, (String)"issues"), (String)"Issue", (NodeBase)new PropertyEqual("numberInProject", (Comparable)((Long)PrimitiveAssociationSemantics.get((Entity)issueKey, (String)"numberInProject", Long.class, null)))))) {
            if (!EntityOperations.equals((Entity)issueKey, null)) {
                EntityOperations.remove((Entity)issueKey);
            }
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"numberInProject", (Comparable)Long.valueOf(EntityOperations.equals((Entity)project, null) ? 0L : ((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)project, (String)"Project")).nextIssueNumber(project)), Long.class);
        } else {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"numberInProject", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)issueKey, (String)"numberInProject", Long.class, null)), Long.class);
        }
    }

    private void clearFieldsOnMovedIssue(final Entity entity) {
        Entity prevProject = AssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"project");
        Iterable fields = AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"fields");
        if (!EntityOperations.equals((Entity)prevProject, null)) {
            Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)prevProject, (String)"fields")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity it) {
                    ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).moveValue(entity, AssociationSemantics.getToOne((Entity)entity, (String)"project"), it);
                }
            });
        }
        Sequence.fromIterable((Iterable)fields).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return (Boolean)PrimitiveAssociationSemantics.get((Entity)it, (String)"canBeEmpty", Boolean.class, null) == false && Sequence.fromIterable(((AbstractCustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)it, (String)"prototype"), (String)"AbstractCustomFieldPrototype")).getValues(entity, AssociationSemantics.getToOne((Entity)it, (String)"prototype"))).isEmpty();
            }
        }).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)it, (String)"prototype"), (String)"CustomFieldPrototype")).setValues(entity, ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).getDefaultValues(it), AssociationSemantics.getToOne((Entity)it, (String)"prototype"));
            }
        });
        if (this.isDraft(entity)) {
            Sequence.fromIterable((Iterable)fields).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return !((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).isWriteAccessible(entity, it);
                }
            }).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                public void visit(Entity it) {
                    ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)it, (String)"prototype"), (String)"CustomFieldPrototype")).setValues(entity, ((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).getDefaultValues(it), AssociationSemantics.getToOne((Entity)it, (String)"prototype"));
                }
            });
        }
        Sequence.fromIterable((Iterable)fields).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"ProjectCustomField")).isVisibleInIssue(entity, it);
            }
        }).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                ((CustomFieldPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)it, (String)"prototype"), (String)"CustomFieldPrototype")).setValue(entity, null, AssociationSemantics.getToOne((Entity)it, (String)"prototype"));
            }
        });
    }

    private void resetNumberInProject(Entity entity) {
        Entity project = AssociationSemantics.getToOne((Entity)entity, (String)"project");
        if (EntityOperations.equals((Entity)project, null)) {
            throw new IllegalStateException("No project for issue " + entity);
        }
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"numberInProject", (Comparable)Long.valueOf(((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)project, (String)"Project")).nextIssueNumber(project)), Long.class);
    }

    private void appendId(StringBuilder builder, Entity entity) {
        if (this.isDraft(entity)) {
            builder.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.Draft", new Object[0]));
            return;
        }
        builder.append((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"shortName", String.class, null));
        builder.append('-');
        long numberInProject = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"numberInProject", Long.class, null);
        if (numberInProject <= 0L) {
            builder.append("???");
        } else {
            builder.append(numberInProject);
        }
    }

    private void updateVotesForDuplicates(Entity entity) {
        jetbrains.exodus.core.dataStructures.hash.HashSet toRecount = new jetbrains.exodus.core.dataStructures.hash.HashSet();
        DirectedLink duplicates = ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate(), (String)"IssueLinkPrototype")).getDirectedLink(LinkDirection.INWARD, ((IssueLinkTypeAux)ServiceLocator.getBean((String)"issueLinkTypeAux")).getDuplicate());
        Entity oldDup = QueryOperations.getFirst(IssueLinkPrototypeUtil.getRemoveLinkedIssues(entity, duplicates));
        if (!EntityOperations.equals((Entity)oldDup, null)) {
            try {
                oldDup = DnqUtils.fromPersistentId((PersistentEntityId)DnqUtils.toPersistentId((Entity)oldDup));
            }
            catch (EntityRemovedInDatabaseException eride) {
                oldDup = null;
            }
        }
        Entity newDup = QueryOperations.getFirst(IssueLinkPrototypeUtil.getLinkedIssues(entity, duplicates));
        if ((Integer)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"votes", Integer.class, null) > (Integer)PrimitiveAssociationSemantics.get((Entity)entity, (String)"votes", Integer.class, null) && !QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"voters"), (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
            ISequence cluster = ListSequence.fromList((List)((List)((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getDuplicateClusterUnflushed(entity)._1())).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return !EntityOperations.equals((Entity)it, null) && !EntityOperations.isRemoved((Entity)it);
                }
            });
            Sequence.fromIterable((Iterable)cluster).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Set)toRecount){
                final /* synthetic */ Set val$toRecount;
                {
                    this.val$toRecount = set;
                }

                public void visit(Entity issue) {
                    if ((Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"voters")).isNotEmpty() || !QueryOperations.isEmpty((Iterable)AssociationSemantics.getAddedLinks((TransientEntity)((TransientEntity)issue), (String)"voters"))) && Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"voters")).contains((Object)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())) {
                        UndirectedAssociationSemantics.removeManyToMany((Entity)issue, (String)"voters", (String)"votedIssues", (Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
                        this.val$toRecount.add(issue);
                    }
                }
            });
        }
        if (!EntityOperations.equals((Entity)oldDup, (Object)newDup)) {
            if (!EntityOperations.equals((Entity)oldDup, null) && !EntityOperations.isRemoved((Entity)oldDup)) {
                toRecount.add(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)oldDup, (String)"Issue")).getRootDuplicate(oldDup));
            }
            if (!(EntityOperations.equals((Entity)oldDup, null) && (Integer)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"votes", Integer.class, null) == 0 || EntityOperations.equals((Entity)newDup, null))) {
                toRecount.add(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)newDup, (String)"Issue")).getRootDuplicate(newDup));
            }
            if (EntityOperations.equals((Entity)newDup, null) || EntityOperations.equals((Entity)oldDup, null)) {
                toRecount.add(entity);
            }
        }
        if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"voters")) {
            toRecount.add(entity);
        }
        toRecount.add(this.getRootDuplicate(entity));
        for (Entity issue : toRecount) {
            if (EntityOperations.equals((Entity)issue, null)) continue;
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).recountVotes(issue);
        }
    }

    public int updateCommentsCount(Entity entity) {
        int result = 0;
        for (Entity comment : AssociationSemantics.getToMany((Entity)entity, (String)"comments")) {
            if (((Boolean)PrimitiveAssociationSemantics.get((Entity)comment, (String)"deleted", Boolean.class, (Object)false)).booleanValue()) continue;
            ++result;
            if (!((BaseCommentImpl)DnqUtils.getPersistentClassInstance((Entity)comment, (String)"BaseComment")).isSecured(comment)) continue;
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"commentsCount", (Comparable)Integer.valueOf(-1), Integer.class);
            return -1;
        }
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"commentsCount", (Comparable)Integer.valueOf(result), Integer.class);
        return result;
    }

    public void updateDuplicateCluster(Entity entity) {
        block6: {
            if (!IssueLinkPrototypeUtil.hasLinksChanges(entity)) break block6;
            Tuples._2<Entity, List<Entity>> duplicateCluster = this.getDuplicateClusterUnflushed(entity);
            Entity root = (Entity)duplicateCluster._0();
            ISequence cluster = ListSequence.fromList((List)((List)duplicateCluster._1())).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return !EntityOperations.equals((Entity)it, null) && !EntityOperations.isRemoved((Entity)it);
                }
            });
            if (QueryOperations.getSize((Iterable)cluster) <= 1) {
                PrimitiveAssociationSemantics.set((Entity)root, (String)"duplicateCluster", null, Long.class);
            } else {
                long clusterId = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)root, (String)"Issue")).getPersistentLocalId(root) + 1L;
                TreeKeepingEntityIterable markedCluster = QueryOperations.query(null, (String)"Issue", (NodeBase)new PropertyEqual("duplicateCluster", (Comparable)Long.valueOf(clusterId)));
                EntityIterableBase clusterInstance = ((EntityIterableBase)markedCluster.instantiate()).getSource();
                if (clusterInstance != EntityIterableBase.EMPTY) {
                    EntityIdSet clusterSet = clusterInstance.toSet((PersistentStoreTransaction)((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getCurrentTransaction());
                    int issueTypeId = entity.getId().getTypeId();
                    for (Entity issue : Sequence.fromIterable((Iterable)cluster)) {
                        if (clusterSet.contains(issueTypeId, ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getPersistentLocalId(issue))) continue;
                        PrimitiveAssociationSemantics.set((Entity)issue, (String)"duplicateCluster", (Comparable)Long.valueOf(clusterId), Long.class);
                    }
                } else {
                    for (Entity issue : Sequence.fromIterable((Iterable)cluster)) {
                        PrimitiveAssociationSemantics.set((Entity)issue, (String)"duplicateCluster", (Comparable)Long.valueOf(clusterId), Long.class);
                    }
                }
            }
        }
    }

    public void afterWorkflow(Entity entity) {
        if (EntityOperations.isRemoved((Entity)entity)) {
            return;
        }
        IssueLinkPrototypeUtil.assertNoAggregationLinkCycles(entity);
        if ((EntityOperations.isNew((Entity)entity) || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String[])new String[]{"permittedGroup"})) && QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup"), (Entity)((Entity)ServiceLocator.getBean((String)"allUsersGroup")))) {
            UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedGroup", (String)"securedIssues");
            UndirectedAssociationSemantics.clearManyToMany((Entity)entity, (String)"permittedUser", (String)"visibleIssues");
        }
        if (!EntityOperations.isNew((Entity)entity) && EntityOperations.hasChangesExcepting((TransientEntity)((TransientEntity)entity), (String[])new String[]{"reporter", "projectTrace", "tags", "updated", "updatedBy", "voters", "votes", "notifiedUsers", "duplicateCluster", "tmp"})) {
            if (EntityOperations.hasChangesExcepting((TransientEntity)((TransientEntity)entity), (String[])((String[])SetSequence.fromSet(((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).getAllAssociations()).concat(Sequence.fromIterable((Iterable)Sequence.singleton((Object)"mentionedUsers"))).toGenericArray(String.class)))) {
                this.update(entity);
            } else if (!QueryOperations.isEmpty(IssueImpl.excludeDraftsAndDeletedInMemory(IssueLinkPrototypeUtil.getAllAddedLinkedIssues(entity))) || !QueryOperations.isEmpty(IssueImpl.excludeDraftsAndDeletedInMemory(IssueLinkPrototypeUtil.getAllRemovedLinkedIssues(entity)))) {
                this.update(entity);
            }
        }
        IssueStateService.updateResolvedDateAndUntag(entity);
        if (!((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isDraft(entity)) {
            if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"deleted", Boolean.class, null)).booleanValue()) {
                if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"deleted")) {
                    this.markDeleted(entity);
                    securityLog.info((Object)("Issue " + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getId(entity) + " has been deleted"));
                }
            } else {
                if (IssueImpl.isDuplicatesProcessingEnabled()) {
                    this.updateDuplicateCluster(entity);
                    this.updateVotesForDuplicates(entity);
                }
                if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"comments") && QueryOperations.isEmpty((Iterable)AssociationSemantics.getAddedLinks((TransientEntity)((TransientEntity)entity), (String)"comments"))) {
                    this.updateCommentsCount(entity);
                }
            }
        }
    }

    public void beforeWorkflow(Entity entity) {
        if (EntityOperations.isRemoved((Entity)entity)) {
            return;
        }
        boolean isNew = EntityOperations.isNew((Entity)entity);
        if (isNew || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"summary") || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"description")) {
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).setSummaryAndDescription((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"summary", String.class, null), PrimitiveAssociationSemantics.getBlobAsString((Entity)entity, (String)"description"), entity);
        }
        boolean projectChanged = EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"project") && !isNew;
        boolean isDraft = this.isDraft(entity);
        if (!UserGroupImpl.isPermittedGroupChangeAllowed() && (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"permittedUser") && !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser")) || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"permittedGroup") && !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) && !QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup"), (Entity)((Entity)ServiceLocator.getBean((String)"allUsersGroup"))))) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.You_can_t_set_permitted_group_to_issue_due_to_license_restrictions", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.You_can_t_set_permitted_group_to_issue_due_to_license_restrictions", new Object[0]), (Entity)((TransientEntity)entity)));
        }
        if (this.becomesReported(entity) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"reporter"), (String)"User")).isService(AssociationSemantics.getToOne((Entity)entity, (String)"reporter"))) {
            throw new LogicException("Service users are not permitted to create issue. Consider using regular user account instead.");
        }
        if (projectChanged) {
            this.resetProjectData(isDraft, isNew, false, entity);
        }
        if (!isDraft && (isNew || EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"draftOwner"))) {
            long numberInProject = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"numberInProject", Long.class, null);
            if (numberInProject == 0L) {
                this.resetNumberInProject(entity);
                numberInProject = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"numberInProject", Long.class, null);
            }
            Entity project = AssociationSemantics.getToOne((Entity)entity, (String)"project");
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).checkIssueIdUniqueness(project, numberInProject, entity);
            ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).checkIssueKeysUniqueness(project, numberInProject, entity);
        }
        IssueStateService.updateResolvedDateAndUntag(entity);
    }

    public void resetProjectData(boolean isDraft, boolean isNew, boolean forceResetingNumber, Entity entity) {
        if (isDraft) {
            if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isEmptySummaryAndDescription(entity)) {
                ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).setDefaultCustomFieldValues(entity);
            } else if (!isNew) {
                this.clearFieldsOnMovedIssue(entity);
            }
        } else {
            Entity oldProject;
            if (!isNew || forceResetingNumber) {
                ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).clearFieldsOnMovedIssue(entity);
                this.assignIssueNumberToMovedIssue(entity);
            }
            if (!isNew && !EntityOperations.equals((Entity)(oldProject = AssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"project")), null) && QueryOperations.isEmpty((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"projectTrace"), (String)"IssueKey", (NodeBase)new LinkEqual("project", oldProject)))) {
                DirectedAssociationSemantics.createToMany((Entity)entity, (String)"projectTrace", (Entity)IssueKeyImpl.constructor((Entity)oldProject, (long)((Long)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"numberInProject", Long.class, null))));
            }
        }
        this.moveComments(entity);
    }

    private void moveComments(Entity entity) {
        boolean hasComments = false;
        for (Entity comment : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"comments"))) {
            DirectedAssociationSemantics.setToOne((Entity)comment, (String)"project", (Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"));
            hasComments = true;
        }
        if (hasComments) {
            for (Entity comment : Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"IssueComment", (NodeBase)new LinkEqual("issue", entity)))) {
                DirectedAssociationSemantics.setToOne((Entity)comment, (String)"project", (Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"));
            }
        }
    }

    private void checkIssueIdUniqueness(Entity project, long numberInProject, Entity entity) {
        for (Entity issue : QueryOperations.query(null, (String)"Issue", (NodeBase)new PropertyEqual("numberInProject", (Comparable)Long.valueOf(numberInProject)))) {
            if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)issue, (String)"project"), (Object)project) || ((Boolean)PrimitiveAssociationSemantics.get((Entity)issue, (String)"deleted", Boolean.class, null)).booleanValue() || EntityOperations.equals((Entity)issue, (Object)entity)) continue;
            String message = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.Issue_{0}_already_exists", new Object[]{((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getId(entity)});
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(message)) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(message, (Entity)((TransientEntity)entity)));
        }
    }

    private void checkIssueKeysUniqueness(Entity project, long numberInProject, Entity entity) {
        for (Entity key : QueryOperations.query(null, (String)"IssueKey", (NodeBase)new And((NodeBase)new LinkEqual("project", project), (NodeBase)new PropertyEqual("numberInProject", (Comparable)Long.valueOf(numberInProject))))) {
            for (Entity issue : QueryOperations.query(null, (String)"Issue", (NodeBase)new And((NodeBase)new LinkEqual("projectTrace", key), (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("deleted", (Comparable)Boolean.TRUE))))) {
                if (EntityOperations.equals((Entity)issue, (Object)entity)) continue;
                String message = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.Issue_{0}_was_created_earlier_and_moved_to_another_project_{1}", new Object[]{((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getId(entity), ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue)});
                throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(message)) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(message, (Entity)((TransientEntity)entity)));
            }
        }
    }

    public static Entity constructor(Entity reporter, Entity project) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(reporter, project, __ENTITY_TYPE__);
    }

    private static Entity constructor(Entity copy) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(copy, __ENTITY_TYPE__);
    }

    @Nullable
    public static Entity fromId(String id) {
        if (id == null) {
            return null;
        }
        IssueIdCache idCache = (IssueIdCache)ServiceLocator.getBean((String)"issueIdCache");
        Entity result = idCache.fromId(id);
        if (EntityOperations.equals((Entity)result, null)) {
            String[] _id = id.split("-");
            if (_id.length < 2) {
                return null;
            }
            Entity project = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("shortName", (Comparable)((Object)_id[0]))));
            if (EntityOperations.equals((Entity)project, null)) {
                return null;
            }
            long numberInProject = IssueImpl.parseNumberInProject(_id[1]);
            if (numberInProject < 1L) {
                return null;
            }
            result = idCache.fromProjectAndId(numberInProject, project, id);
        }
        return result;
    }

    private static Iterable<Entity> excludeDraftsAndDeletedInMemory(Iterable<Entity> issues) {
        return Sequence.fromIterable(issues).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).isDraft(it) && (Boolean)PrimitiveAssociationSemantics.get((Entity)it, (String)"deleted", Boolean.class, null) == false;
            }
        });
    }

    private static long parseNumberInProject(String numStr) {
        try {
            return Long.parseLong(numStr);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static void setUpdateEnabled(boolean value) {
        if (value) {
            DISABLE_UPDATE.remove();
        } else {
            DISABLE_UPDATE.set(Boolean.TRUE);
        }
    }

    public static void setDuplicatesProcessingEnabled(boolean value) {
        if (value) {
            DISABLE_DUPLICATES_PROCESSING.remove();
        } else {
            DISABLE_DUPLICATES_PROCESSING.set(Boolean.TRUE);
        }
    }

    public static boolean isUpdateEnabled() {
        Boolean b = DISABLE_UPDATE.get();
        return b == null || b == false;
    }

    public static boolean isDuplicatesProcessingEnabled() {
        Boolean disabled = DISABLE_DUPLICATES_PROCESSING.get();
        return disabled == null || disabled == false;
    }

    public static Entity createDraft(Entity owner, Entity project) {
        return IssueImpl.createDraft(owner, project, false);
    }

    public static Entity createDraft(Entity owner, Entity project, boolean tmp) {
        Entity issue = IssueImpl.constructor(owner, project);
        UndirectedAssociationSemantics.setManyToOne((Entity)owner, (String)"draft", (String)"draftOwner", (Entity)issue);
        PrimitiveAssociationSemantics.set((Entity)issue, (String)"tmp", (Comparable)Boolean.valueOf(tmp), Boolean.class);
        PrimitiveAssociationSemantics.set((Entity)issue, (String)"usesMarkdown", (Comparable)Boolean.valueOf(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)owner, (String)"User")).shouldUseMarkdown(owner)), Boolean.class);
        return issue;
    }

    public static Iterable<Entity> getDrafts(Entity _project) {
        return QueryOperations.query(null, (String)"Issue", (NodeBase)new And((NodeBase)new LinkEqual("project", _project), (NodeBase)new UnaryNot((NodeBase)new LinkEqual("draftOwner", null))));
    }

    public static Iterable<Entity> getNonDrafts() {
        return QueryOperations.query(null, (String)"Issue", (NodeBase)new LinkEqual("draftOwner", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entity getParentIssue(Set<String> subtaskAssociations, Entity child) {
        Iterable<Entity> linked = IssueLinkPrototypeUtil.getLinkedIssues(child, subtaskAssociations);
        Iterator<Entity> itr = linked.iterator();
        try {
            while (itr.hasNext()) {
                Entity issue = itr.next();
                if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isDraft(issue)) continue;
                Entity entity = issue;
                return entity;
            }
        }
        finally {
            EntityIterator ei;
            if (itr instanceof EntityIterator && (ei = (EntityIterator)itr).shouldBeDisposed()) {
                ei.dispose();
            }
        }
        return null;
    }

    public static boolean isEmpty_i3gncs_a0a0t(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_i3gncs_a0a0a43(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_i3gncs_a0a0a43_0(String str) {
        return str == null || str.length() == 0;
    }
}

