/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import jetbrains.charisma.persistent.CharismaJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserActionJob
extends CharismaJob {
    protected static Log log = LogFactory.getLog(UserActionJob.class);
    private volatile State state = State.QUEUED;
    private Runnable action;
    private final Object monitor = new Object();

    public UserActionJob(Runnable action, Object id) {
        super(id);
        this.action = action;
    }

    public UserActionJob(Object id) {
        this(null, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute() throws Throwable {
        Object object = this.monitor;
        synchronized (object) {
            block5: {
                this.state = State.EXECUTING;
                try {
                    this.executeAction();
                    this.state = State.FINISHED;
                }
                catch (Throwable t) {
                    this.state = State.ERROR;
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Exception on executing user action ", t);
                }
            }
        }
    }

    protected void executeAction() {
        this.action.run();
    }

    public State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAction(Runnable action1) {
        Object object = this.monitor;
        synchronized (object) {
            switch (this.state) {
                case QUEUED: {
                    this.action = action1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Can't set action for job in state: " + (Object)((Object)this.state));
                }
            }
        }
    }

    public static enum State {
        QUEUED,
        EXECUTING,
        ERROR,
        FINISHED;

    }
}

