/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.plugins;

import java.util.Collections;
import java.util.List;
import jetbrains.charisma.plugins.NamedEntity;
import jetbrains.charisma.plugins.SortableValueRenderer;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.customfields.DetalizationLevel;
import jetbrains.youtrack.api.customfields.FieldValueRenderer;

public class MultyValueRenderer<T extends Entity>
extends FieldValueRenderer<Iterable<T>> {
    private SortableValueRenderer<T> singleValueRenderer;

    public MultyValueRenderer(SortableValueRenderer<T> singleValueRenderer) {
        super(singleValueRenderer.nullValueText);
        this.singleValueRenderer = singleValueRenderer;
    }

    public String getPresentation(Iterable<T> value, DetalizationLevel level) {
        return super.getPresentation(value, level);
    }

    public String renderValue(Iterable<T> value, final DetalizationLevel level) {
        if (Sequence.fromIterable(value).isEmpty()) {
            return this.nullValueText;
        }
        String delimiter = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("MultyValueRenderer.", new Object[0]);
        if (this.singleValueRenderer.isEagerSortSupported(level)) {
            List<NamedEntity<T>> allValues = this.singleValueRenderer.wrapValuesForEagerSort(value);
            if (allValues.size() > 1) {
                Collections.sort(allValues);
            }
            List<NamedEntity<T>> v = allValues;
            return IterableUtils.join((Iterable)Sequence.fromIterable(v).select((_FunctionTypes._return_P1_E0)new ISelector<NamedEntity<T>, String>(){

                public String select(NamedEntity<T> it) {
                    return it.name;
                }
            }), (String)delimiter);
        }
        return IterableUtils.join((Iterable)Sequence.fromIterable(this.singleValueRenderer.sort(value)).select((_FunctionTypes._return_P1_E0)new ISelector<T, String>(){

            public String select(T it) {
                return MultyValueRenderer.this.singleValueRenderer.renderValue(it, level);
            }
        }), (String)delimiter);
    }
}

