/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.refactoring;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.charisma.smartui.watchFolder.WatchFolderImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.watchFolder.RuleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RefactoringPinWatchfolderToUser
extends Refactoring {
    protected static Log log = LogFactory.getLog(RefactoringPinWatchfolderToUser.class);

    @Override
    public void apply(Entity a) {
        Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"WatchFolder")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                ((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"WatchFolder")).fixName(it);
            }
        });
        DnqUtils.getCurrentTransientSession().flush();
        this.doUnit("Pinned %d watch-folders", (_FunctionTypes._return_P1_E0<? extends Integer, ? super Integer>)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

            public Integer invoke(Integer count) {
                IListSequence toPin = Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"WatchFolder")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                    public boolean accept(Entity it) {
                        return !((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"WatchFolder")).isWatched(((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"WatchFolder")).getOwner(it), RuleType.PINNED, it);
                    }
                }), (int)count)).toListSequence();
                for (Entity wf : toPin) {
                    Entity owner = ((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)wf, (String)"WatchFolder")).getOwner(wf);
                    if (EntityOperations.equals((Entity)owner, null)) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("WatchFolder with null owner (name: " + (String)PrimitiveAssociationSemantics.get((Entity)wf, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) + "), eliminate it: " + wf));
                        }
                        EntityOperations.remove((Entity)wf);
                        continue;
                    }
                    ((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)wf, (String)"WatchFolder")).setPinned(owner, true, wf);
                }
                return QueryOperations.getSize((Iterable)toPin);
            }
        });
        ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)a, (String)"ApplicationMetaData")).saveAsAppliedRefactoring(this.getName(), a);
    }
}

