/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.refactoring;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jetbrains.charisma.refactoring.Refactoring;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RefactoringRestoreAllSearchesFromFile
extends Refactoring {
    protected static Log log = LogFactory.getLog(RefactoringRestoreAllSearchesFromFile.class);

    @Override
    public boolean shouldApply(Entity a) {
        return Boolean.getBoolean("jetbrains.youtrack.refactoring.restoreAllSearchesFromFile");
    }

    @Override
    public void apply(Entity a) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(System.getProperty("user.home") + File.separator + "teamsysdata" + File.separator + "sq.tsv"), "UTF-8"));
            TransientStoreSession session = ((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).getThreadSession();
            while ((line = reader.readLine()) != null) {
                String[] values = line.split("\t");
                String name = values[1];
                String queryText = values[2];
                if (name == null || name.length() <= 0 || queryText == null || queryText.length() <= 0) continue;
                EntityId id = session.toEntityId(values[0]);
                try {
                    Entity query = DnqUtils.cast((Object)session.getEntity(id), (String)"SavedQuery");
                    PrimitiveAssociationSemantics.set((Entity)query, (String)"name", (Comparable)((Object)name), String.class);
                    PrimitiveAssociationSemantics.set((Entity)query, (String)"query", (Comparable)((Object)queryText), String.class);
                }
                catch (EntityRemovedInDatabaseException ignore) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("SavedQuery " + id + " was removed"));
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

