/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.refactoring;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.List;
import java.util.Locale;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyNotNull;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RefactoringUtil {
    protected static Log log = LogFactory.getLog(RefactoringUtil.class);

    private RefactoringUtil() {
    }

    public static void doUnit(String message, _FunctionTypes._return_P1_E0<? extends Integer, ? super Integer> unit, String refactoringName) {
        RefactoringUtil.doUnit(message, -1, unit, refactoringName);
    }

    public static void processInBatches(String message, Iterable<Entity> elements, _FunctionTypes._void_P1_E0<? super Entity> process, int page) {
        boolean goOn = true;
        int skip = 0;
        while (goOn) {
            goOn = false;
            for (Entity value : Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)QueryOperations.skip(elements, (int)skip), (int)(skip + page - skip))).toListSequence()) {
                goOn = true;
                ++skip;
                process.invoke((Object)value);
            }
            DnqUtils.getCurrentTransientSession().flush();
            if (!goOn && skip != 0 || !log.isInfoEnabled()) continue;
            log.info((Object)String.format(message, skip));
        }
    }

    public static <T> void processListInBatches(String message, List<T> elements, _FunctionTypes._void_P1_E0<? super T> process, int page) {
        boolean goOn = true;
        int skip = 0;
        while (goOn) {
            goOn = false;
            for (Object value : ListSequence.fromList(elements).page(skip, skip + page).toListSequence()) {
                goOn = true;
                ++skip;
                process.invoke(value);
            }
            DnqUtils.getCurrentTransientSession().flush();
            if (!goOn && skip != 0 || !log.isInfoEnabled()) continue;
            log.info((Object)String.format(message, skip));
        }
    }

    public static <T> void processInBatchesReducingSequence(String message, Iterable<T> elements, _FunctionTypes._void_P1_E0<? super T> process, int page) {
        boolean goOn = true;
        int processed = 0;
        while (goOn) {
            goOn = false;
            for (Object value : Sequence.fromIterable(elements).take(page).toListSequence()) {
                goOn = true;
                process.invoke(value);
                ++processed;
            }
            DnqUtils.getCurrentTransientSession().flush();
            if (message == null || !goOn && processed != 0 || !log.isInfoEnabled()) continue;
            log.info((Object)String.format(message, processed));
        }
    }

    public static void doUnitTransactionalNew(String message, int total, final _FunctionTypes._return_P1_E0<? extends Integer, ? super Integer> unit, String refactoringName, final int packSize) {
        int totalProcessed = 0;
        while (true) {
            long start = System.currentTimeMillis();
            final Wrappers._int unitProcessed = new Wrappers._int();
            _Txn.runNew((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                public void invoke() {
                    unitProcessed.value = (Integer)unit.invoke((Object)packSize);
                }
            });
            if (unitProcessed.value == 0) break;
            totalProcessed += unitProcessed.value;
            float speedInMs = (float)unitProcessed.value / (float)(System.currentTimeMillis() - start);
            Long estimatedFinish = System.currentTimeMillis();
            if (total > 0) {
                int left = total - totalProcessed;
                estimatedFinish = estimatedFinish + (long)((float)left / speedInMs);
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)String.format(refactoringName + ": " + message, totalProcessed, Float.valueOf(speedInMs * 1000.0f), DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)estimatedFinish, (DateTimeZone)DateTimeZone.getDefault()), (DateTimeFormatter)DateTimeFormat.fullDateTime(), (Locale)Locale.ENGLISH)));
        }
    }

    public static void doUnit(String message, int total, _FunctionTypes._return_P1_E0<? extends Integer, ? super Integer> unit, String refactoringName) {
        int totalProcessed = 0;
        while (true) {
            long start = System.currentTimeMillis();
            int processed = (Integer)unit.invoke((Object)100);
            if (processed == 0) break;
            DnqUtils.getCurrentTransientSession().flush();
            totalProcessed += processed;
            float speedInMs = (float)processed / (float)(System.currentTimeMillis() - start);
            Long estimatedFinish = System.currentTimeMillis();
            if (total > 0) {
                int left = total - totalProcessed;
                estimatedFinish = System.currentTimeMillis() + (long)((float)left / speedInMs);
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)(refactoringName + ": " + String.format(message, totalProcessed, Float.valueOf(speedInMs * 1000.0f), DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)estimatedFinish, (DateTimeZone)DateTimeZone.getDefault()), (DateTimeFormatter)DateTimeFormat.fullDateTime(), (Locale)Locale.ENGLISH))));
        }
    }

    public static void renameProperty(final String entityType, final String oldName, final String newName, final Class<? extends Comparable> propertyType, String refactoringName) {
        int total = QueryOperations.getSize((Iterable)QueryOperations.queryGetAll((String)entityType));
        RefactoringUtil.doUnit(entityType + "[" + oldName + "->" + newName + "]: for %d entities property is renamed. Speed %1.1f instances/sec. Estimated finish at %s", total, (_FunctionTypes._return_P1_E0<? extends Integer, ? super Integer>)new _FunctionTypes._return_P1_E0<Integer, Integer>(){

            public Integer invoke(Integer packSize) {
                TreeKeepingEntityIterable pack = QueryOperations.query(null, (String)entityType, (NodeBase)new PropertyNotNull(oldName));
                IListSequence toRefactor = Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)pack, (int)packSize)).toListSequence();
                for (Entity entity : ListSequence.fromList((List)toRefactor)) {
                    Comparable value = (Comparable)PrimitiveAssociationSemantics.get((Entity)entity, (String)oldName, (Class)propertyType, null);
                    PrimitiveAssociationSemantics.set((Entity)entity, (String)newName, (Comparable)value, (Class)propertyType);
                    PrimitiveAssociationSemantics.set((Entity)entity, (String)oldName, null, (Class)propertyType);
                }
                return QueryOperations.getSize((Iterable)toRefactor);
            }
        }, refactoringName);
    }

    public static void renameEntityType(String oldName, String newName) {
        if (((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).entityTypeExists(oldName)) {
            ((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore")).renameEntityTypeRefactoring(oldName, newName);
        }
    }

    public static void doUnitWithTimeoutFlush(String message, final _FunctionTypes._return_P1_E0<? extends Iterable<Entity>, ? super Integer> getTail, final _FunctionTypes._void_P1_E0<? super Entity> process, String refactoringName, final long timeout) {
        final Wrappers._int totalProcessed = new Wrappers._int(0);
        while (true) {
            final Wrappers._long unitElapsedTime = new Wrappers._long(0L);
            final Wrappers._int unitProcessed = new Wrappers._int(0);
            _Txn.runNew((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                public void invoke() {
                    long start = System.currentTimeMillis();
                    for (Entity entity : Sequence.fromIterable((Iterable)((Iterable)getTail.invoke((Object)totalProcessed.value)))) {
                        process.invoke((Object)entity);
                        ++unitProcessed.value;
                        unitElapsedTime.value = System.currentTimeMillis() - start;
                        if (unitElapsedTime.value < timeout) continue;
                        break;
                    }
                }
            });
            if (unitProcessed.value == 0) {
                if (!log.isInfoEnabled()) break;
                log.info((Object)(refactoringName + ": finished"));
                break;
            }
            totalProcessed.value += unitProcessed.value;
            float speedEntityPerSeconds = (float)unitProcessed.value * 1000.0f / (float)unitElapsedTime.value;
            if (!log.isInfoEnabled()) continue;
            log.info((Object)String.format(refactoringName + ": " + message, totalProcessed.value, Float.valueOf(speedEntityPerSeconds)));
        }
    }
}

