/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.smartui.watchFolder.SpecialFolders;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import webr.framework.url.UrlUtil;

@XmlRootElement(name="issueFolder")
@XmlType(name="IssueFolder")
public class IssueFolder {
    @XmlAttribute(name="id")
    private String id;
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="presentation")
    private String presentation;
    @XmlAttribute(name="icon")
    private String icon;
    @XmlAttribute(name="fqFolderId")
    private String fqFolderId;
    @XmlAttribute(name="query")
    private String query;
    @XmlAttribute(name="pinned")
    private boolean pinned;
    @XmlElement(name="issuesUrl")
    private String issuesUrl;

    public IssueFolder() {
    }

    public IssueFolder(Entity folder) {
        this.id = this.evalId(folder);
        this.name = this.evalName(folder);
        this.presentation = this.evalPresentation(folder);
        this.icon = this.evalIcon(folder);
        this.fqFolderId = this.evalFqFolderId(folder);
        this.query = this.evalQuery(folder);
        this.pinned = this.evalPinned(folder);
        this.issuesUrl = this.evalIssuesUrl(folder);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPresentation() {
        return this.presentation;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getFqFolderId() {
        return this.fqFolderId;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean getPinned() {
        return this.pinned;
    }

    public String getIssuesUrl() {
        return this.issuesUrl;
    }

    private String evalId(Entity folder) {
        return folder.getId().toString();
    }

    private String evalName(Entity folder) {
        return (String)PrimitiveAssociationSemantics.get((Entity)folder, (String)"name", String.class, (Object)IssueFolderImpl.getNullName());
    }

    private String evalPresentation(Entity folder) {
        return SpecialFolders.getDisplayName(folder, IssueFolderImpl.getNullName());
    }

    private String evalIcon(Entity folder) {
        return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)folder, (String)"icon"), null) ? null : UrlUtil.getPersistentFileUrl((Entity)AssociationSemantics.getToOne((Entity)folder, (String)"icon"), null, null, (Boolean)true);
    }

    private String evalFqFolderId(Entity folder) {
        return SpecialFolders.getFqFolderId(folder);
    }

    private String evalQuery(Entity folder) {
        return IssueFolderUtil.getOrderedIssuesProvider(folder).getQuery();
    }

    private boolean evalPinned(Entity folder) {
        return ((IssueFolderImpl)DnqUtils.getPersistentClassInstance((Entity)folder, (String)"IssueFolder")).isNotUnpinned(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), folder);
    }

    private String evalIssuesUrl(Entity folder) {
        return SpecialFolders.getUrl(folder, "");
    }
}

