/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.restInternal;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.charisma.context.ContextProvider;
import jetbrains.charisma.context.ReorderData;
import jetbrains.charisma.context.StatefulContext;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.rest.HasStatefulWebrContext;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.restInternal.ReorderResult;
import jetbrains.charisma.smartui.watchFolder.SavedQueryImpl;
import jetbrains.charisma.smartui.watchFolder.SpecialFolders;
import jetbrains.charisma.smartui.watchFolder.WatchFolderImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.security.Operation;

@Path(value="/folder")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@HasStatefulWebrContext
public class FolderResource
implements Resource {
    @POST
    @Path(value="/{folder}/moveIssue")
    public ReorderResult post_FolderMoveIssue(@Transformer(value="folderId") @PathParam(value="folder") Entity folder, @QueryParam(value="moved") String moved, @QueryParam(value="leading") String leading, @QueryParam(value="query") String query, @QueryParam(value="orderExpected") boolean orderExpected) {
        IsLoggedInSecurityConstraint.check();
        if (moved == null || moved.length() == 0) {
            return new ReorderResult(folder, 500, (Iterable<String>)Sequence.singleton((Object)"Empty moved issue id"));
        }
        if (EntityOperations.equals((Entity)folder, null)) {
            try {
                folder = SavedQueryImpl.findHidden(query, true);
            }
            catch (ReadonlyTransactionException e) {
                return new ReorderResult(folder, 418, (Iterable<String>)Sequence.singleton((Object)((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Exception.readonly_mode", new Object[0])));
            }
        }
        if ((EntityOperations.equals((Entity)folder, null) || !SpecialFolders.hasCustomOrder(folder)) && orderExpected) {
            return new ReorderResult(folder, 406, null);
        }
        if (EntityOperations.equals((Entity)folder, null)) {
            return new ReorderResult(null, 404, null);
        }
        if (((IssueFolderImpl)DnqUtils.getPersistentClassInstance((Entity)folder, (String)"IssueFolder")).isAccessible(Operation.UPDATE, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), folder)) {
            Entity movedIssue = IssueImpl.fromId(moved);
            if (EntityOperations.equals((Entity)movedIssue, null)) {
                return new ReorderResult(folder, 500, (Iterable<String>)Sequence.singleton((Object)("Moved issue not found. Id: " + moved)));
            }
            Entity leadingIssue = IssueImpl.fromId(leading);
            if (leading != null && leading.length() > 0 && EntityOperations.equals((Entity)leadingIssue, null)) {
                return new ReorderResult(folder, 500, (Iterable<String>)Sequence.singleton((Object)("Leading issue not found. Id: " + leading)));
            }
            try {
                IssueFolderUtil.getOrderedIssuesProvider(folder).moveIssue(movedIssue, leadingIssue, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
                StatefulContext context = FolderResource.as_wu7qse_a0a1a4a5a0(ContextProvider.getContext(), StatefulContext.class);
                if (context != null) {
                    context.addData(folder, ReorderData.create(leadingIssue, movedIssue));
                }
                return new ReorderResult(folder, 200, null);
            }
            catch (ReadonlyTransactionException e) {
                return new ReorderResult(folder, 418, (Iterable<String>)Sequence.singleton((Object)((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Exception.readonly_mode", new Object[0])));
            }
            catch (LocalizedLogicException ex) {
                return new ReorderResult(folder, 400, (Iterable<String>)Sequence.singleton((Object)ex.getLocalizedMessage()));
            }
            catch (Exception ex) {
                return new ReorderResult(folder, 500, (Iterable<String>)Sequence.singleton((Object)ex.getLocalizedMessage()));
            }
        }
        return this.composeForbidden(folder);
    }

    @POST
    @Path(value="/{folder}/resetIssuePosition")
    public ReorderResult post_FolderResetIssuePosition(@Transformer(value="folderId") @PathParam(value="folder") Entity folder, @QueryParam(value="issue") String issue) {
        IsLoggedInSecurityConstraint.check();
        if (EntityOperations.equals((Entity)folder, null) || !SpecialFolders.hasCustomOrder(folder)) {
            return new ReorderResult(folder, 406, null);
        }
        if (((IssueFolderImpl)DnqUtils.getPersistentClassInstance((Entity)folder, (String)"IssueFolder")).isAccessible(Operation.UPDATE, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), folder)) {
            try {
                IssueFolderUtil.getOrderedIssuesProvider(folder).resetIssuePosition(IssueImpl.fromId(issue));
                return new ReorderResult(folder, 200, null);
            }
            catch (Exception ex) {
                return new ReorderResult(folder, 500, (Iterable<String>)Sequence.singleton((Object)ex.getLocalizedMessage()));
            }
        }
        return new ReorderResult(folder, 403, null);
    }

    private ReorderResult composeForbidden(Entity folder) {
        if (DnqUtils._instanceOf((Object)folder, (String)"WatchFolder")) {
            Entity watchFolder = DnqUtils.cast((Object)folder, (String)"WatchFolder");
            Entity updatableByGroup = ((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)watchFolder, (String)"WatchFolder")).getUpdateShareGroup(watchFolder);
            String updatableBy = !EntityOperations.equals((Entity)updatableByGroup, null) ? (String)PrimitiveAssociationSemantics.get((Entity)updatableByGroup, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale()) : (String)PrimitiveAssociationSemantics.get((Entity)((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)watchFolder, (String)"WatchFolder")).getOwner(watchFolder), (String)"login", String.class, (Object)"<no user>");
            return new ReorderResult(folder, 403, (Iterable<String>)Sequence.fromArray((Object[])new String[]{(String)PrimitiveAssociationSemantics.get((Entity)folder, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()), EntityOperations.equals((Entity)updatableByGroup, null) ? "user" : "group", updatableBy}));
        }
        Entity p = DnqUtils.cast((Object)folder, (String)"Project");
        return new ReorderResult(folder, 403, (Iterable<String>)Sequence.fromArray((Object[])new String[]{(String)PrimitiveAssociationSemantics.get((Entity)folder, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()), "user", (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)p, (String)"leader"), (String)"login", String.class, (Object)"<no user>")}));
    }

    private static <T> T as_wu7qse_a0a1a4a5a0(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }
}

