/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.restInternal;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.restInternal.JaxbStyledUnderline;
import jetbrains.charisma.restInternal.JaxbStyledUnderlineAndSuggest;
import jetbrains.charisma.restInternal.JaxbSuggest;
import jetbrains.charisma.smartui.parser.search.Parser;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.charisma.smartui.persistent.RecentQueryCache;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.parser.base.StyleRange;
import jetbrains.youtrack.parser.base.SuggestItem;
import org.jetbrains.annotations.Nullable;

@Path(value="/search")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class SearchResource
implements Resource {
    @GET
    @Path(value="/suggest")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    public JaxbSuggest get_Suggest(@QueryParam(value="wfId") Set<String> wfId, @QueryParam(value="query") String query, @QueryParam(value="caret") Integer caret, @QueryParam(value="optionsLimit") Integer optionsLimit) {
        IsLoggedInSecurityConstraint.check();
        Iterable<Entity> folders = this.getFolders(wfId);
        return this.getSuggests(query, caret, optionsLimit, folders);
    }

    @GET
    @Path(value="/underline")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    public JaxbStyledUnderline get_Underline(@QueryParam(value="wfId") Set<String> wfId, @QueryParam(value="query") String query) {
        IsLoggedInSecurityConstraint.check();
        Iterable<Entity> folders = this.getFolders(wfId);
        return this.getUnderline(query, folders);
    }

    @GET
    @Path(value="/underlineAndSuggest")
    @Produces(value={"application/x-javascript;charset=UTF-8", "application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    public JaxbStyledUnderlineAndSuggest get_UnderlineAndSuggest(@QueryParam(value="wfId") Set<String> wfId, @QueryParam(value="query") String query, @QueryParam(value="caret") Integer caret, @QueryParam(value="optionsLimit") Integer optionsLimit) {
        IsLoggedInSecurityConstraint.check();
        Iterable<Entity> folders = this.getFolders(wfId);
        return new JaxbStyledUnderlineAndSuggest(this.getUnderline(query, folders), this.getSuggests(query, caret, optionsLimit, folders));
    }

    private JaxbSuggest getSuggests(String query, Integer caret, Integer optionsLimit, Iterable<Entity> folder) {
        query = query == null ? "" : query;
        caret = caret == null ? query.length() : caret.intValue();
        return new JaxbSuggest(query, caret, this.getSuggestsItems(query, caret, optionsLimit, folder));
    }

    private Iterable<SuggestItem> getSuggestsItems(String query, Integer caret, Integer optionsLimit, Iterable<Entity> folders) {
        query = query == null ? "" : query;
        caret = caret == null ? query.length() : caret.intValue();
        optionsLimit = optionsLimit == null || optionsLimit < 1 ? 15 : optionsLimit;
        Iterable<SuggestItem> recentSuggestionsItems = RecentQueryCache.getSuggests(query, caret);
        ISequence suggestItems = Sequence.fromIterable(((Parser)ServiceLocator.getBean((String)"parser")).suggest(folders, query, new Context(), caret, optionsLimit)).concat(Sequence.fromIterable(recentSuggestionsItems));
        return suggestItems;
    }

    private JaxbStyledUnderline getUnderline(String query, Iterable<Entity> folders) {
        query = query == null ? "" : query;
        Iterable<StyleRange> ranges = ((Parser)ServiceLocator.getBean((String)"parser")).getStyleRanges(folders, query, new Context());
        return new JaxbStyledUnderline(query, ranges);
    }

    private Iterable<Entity> getFolders(@Nullable Set<String> ids) {
        int size;
        if (ids == null || (size = SetSequence.fromSet(ids).count()) == 0) {
            return QueryOperations.empty((String)"IssueFolder");
        }
        HashSet<Entity> result = new HashSet<Entity>(size);
        for (String id : SetSequence.fromSet(ids)) {
            Entity found = IssueFolderUtil.findById(id);
            if (EntityOperations.equals((Entity)found, null)) continue;
            result.add(found);
        }
        return result;
    }
}

