/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartadmin.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.security.UserRoleImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.charisma.smartadmin.rest.EntityGetterUtil;
import jetbrains.charisma.smartadmin.rest.ProjectRef;
import jetbrains.charisma.smartadmin.rest.RequirePermissionSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.charisma.smartadmin.rest.RestAdminUrls;
import jetbrains.charisma.smartadmin.rest.UserGroupBean;
import jetbrains.charisma.smartadmin.rest.UserGroupRef;
import jetbrains.charisma.smartadmin.rest.UserRole;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.runtime.requestProcessor.FileUploadRequestProcessor;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.security.Permission;
import org.apache.commons.fileupload.disk.DiskFileItem;

@Path(value="/admin/group")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class AdminGroupResource
implements Resource {
    @GET
    public List<UserGroupRef> get() {
        RequirePermissionSecurityConstraint.check(Permission.READ_USERGROUP, null);
        return ListSequence.fromListWithValues(new ArrayList(), (Iterable)Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)QueryOperations.queryGetAll((String)"UserGroup"), (String)"UserGroup", (NodeBase)new SortByProperty(null, "name", true))).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, UserGroupRef>(){

            public UserGroupRef select(Entity it) {
                return new UserGroupRef(it);
            }
        }));
    }

    @GET
    @Path(value="/visible")
    public List<UserGroupRef> get_Visible() {
        IsLoggedInSecurityConstraint.check();
        return Sequence.fromIterable(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).getVisibleUserGroupsSorted(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, UserGroupRef>(){

            public UserGroupRef select(Entity it) {
                return new UserGroupRef(it);
            }
        }).toListSequence();
    }

    @GET
    @Path(value="/{group}")
    public UserGroupBean get_Group(@PathParam(value="group") String group) {
        RequirePermissionSecurityConstraint.check(Permission.READ_USERGROUP, null);
        return new UserGroupBean(EntityGetterUtil.getUserGroup(group, true));
    }

    @PUT
    @Path(value="/{group}")
    public Response put_Group(@PathParam(value="group") String group, @QueryParam(value="description") String description, @QueryParam(value="autoJoin") Boolean autoJoin) {
        RequirePermissionSecurityConstraint.check(Permission.CREATE_USERGROUP, null);
        EntityGetterUtil.getUserGroup(group, false);
        Entity ug = UserGroupImpl.constructor(group);
        PrimitiveAssociationSemantics.set((Entity)ug, (String)"description", (Comparable)((Object)description), String.class);
        PrimitiveAssociationSemantics.set((Entity)ug, (String)"addNewUser", (Comparable)Boolean.valueOf(autoJoin == null ? false : autoJoin), Boolean.class);
        RestUtil.waitForPermissionCacheRecalculation();
        return ResponseUtil.created(RestAdminUrls.getUserGroupUrl(group));
    }

    @POST
    @Path(value="/{group}")
    public Response post_Group(@PathParam(value="group") String group, @QueryParam(value="newName") String newName, @QueryParam(value="description") String description, @QueryParam(value="autoJoin") Boolean autoJoin) {
        RequirePermissionSecurityConstraint.check(Permission.UPDATE_USERGROUP, null);
        Entity ug = EntityGetterUtil.getUserGroup(group, true);
        if (description != null) {
            PrimitiveAssociationSemantics.set((Entity)ug, (String)"description", (Comparable)((Object)description), String.class);
        }
        if (autoJoin != null) {
            PrimitiveAssociationSemantics.set((Entity)ug, (String)"addNewUser", (Comparable)autoJoin, Boolean.class);
        }
        String oldName = (String)PrimitiveAssociationSemantics.get((Entity)ug, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale());
        if (newName != null && newName.length() > 0 && AdminGroupResource.neq_xwsk0v_a0a5a4(newName, oldName)) {
            EntityGetterUtil.getUserGroup(newName, false);
            PrimitiveAssociationSemantics.set((Entity)ug, (String)"name", (Comparable)((Object)newName), String.class);
        }
        return ResponseUtil.updated(RestAdminUrls.getUserGroupUrl((String)PrimitiveAssociationSemantics.get((Entity)ug, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale())), oldName, newName);
    }

    @DELETE
    @Path(value="/{group}")
    public Response delete_Group(@PathParam(value="group") String group) {
        RequirePermissionSecurityConstraint.check(Permission.DELETE_USERGROUP, null);
        return ResponseUtil.deleted(EntityGetterUtil.getUserGroup(group, true), true);
    }

    @GET
    @Path(value="/{group}/role")
    public List<UserRole> get_GroupRole(@PathParam(value="group") String group) {
        RequirePermissionSecurityConstraint.check(Permission.READ_USERGROUP, null);
        RequirePermissionSecurityConstraint.check(Permission.READ_ROLE, null);
        return ListSequence.fromListWithValues(new ArrayList(), (Iterable)Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)EntityGetterUtil.getUserGroup(group, true), (String)"groupRoles")).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, UserRole>(){

            public UserRole select(Entity it) {
                IMapSequence projects = MapSequence.fromMap(new HashMap());
                Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)it, (String)"projects")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Map)projects){
                    final /* synthetic */ Map val$projects;
                    {
                        this.val$projects = map;
                    }

                    public void visit(Entity it) {
                        MapSequence.fromMap((Map)this.val$projects).put(PrimitiveAssociationSemantics.get((Entity)it, (String)"shortName", String.class, null), PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
                    }
                });
                return new UserRole((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)it, (String)"role"), (String)"name", String.class, (Object)"<no role>"), (Map<String, String>)projects);
            }
        }));
    }

    @GET
    @Path(value="/{group}/role/{role}")
    public UserRole get_GroupRoleRole(@PathParam(value="group") String group, @PathParam(value="role") String role) {
        RequirePermissionSecurityConstraint.check(Permission.UPDATE_USERGROUP, null);
        Entity ug = EntityGetterUtil.getUserGroup(group, true);
        Entity ur = EntityGetterUtil.getUserRole(ug, role, true);
        IMapSequence projects = MapSequence.fromMap(new HashMap());
        Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)ur, (String)"projects")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((Map)projects){
            final /* synthetic */ Map val$projects;
            {
                this.val$projects = map;
            }

            public void visit(Entity it) {
                MapSequence.fromMap((Map)this.val$projects).put(PrimitiveAssociationSemantics.get((Entity)it, (String)"shortName", String.class, null), PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()));
            }
        });
        return new UserRole((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)ur, (String)"role"), (String)"name", String.class, (Object)"<no role>"), (Map<String, String>)projects);
    }

    @PUT
    @Path(value="/{group}/role/{role}")
    public Response put_GroupRoleRole(@PathParam(value="group") String group, @PathParam(value="role") String role, UserRole userRole) {
        RequirePermissionSecurityConstraint.check(Permission.UPDATE_USERGROUP, null);
        ResponseUtil.ensure("Role", userRole != null, "Request body should contain UserRole");
        Entity ug = EntityGetterUtil.getUserGroup(group, true);
        this.replaceRole(ug, userRole);
        RestUtil.waitForPermissionCacheRecalculation();
        return ResponseUtil.created(RestAdminUrls.getUserRoleUrl(group, role));
    }

    @DELETE
    @Path(value="/{group}/role/{role}")
    public Response delete_GroupRoleRole(@PathParam(value="group") String group, @PathParam(value="role") String role) {
        RequirePermissionSecurityConstraint.check(Permission.UPDATE_USERGROUP, null);
        Entity ug = EntityGetterUtil.getUserGroup(group, true);
        Entity ur = EntityGetterUtil.getUserRole(ug, role, true);
        EntityOperations.remove((Entity)ur);
        RestUtil.waitForPermissionCacheRecalculation();
        return Response.ok().build();
    }

    @POST
    @Path(value="/{group}/icon")
    public Response post_GroupIcon(@PathParam(value="group") String group) {
        RequirePermissionSecurityConstraint.check(Permission.UPDATE_USERGROUP, null);
        Entity ug = EntityGetterUtil.getUserGroup(group, true);
        ResponseUtil.isRequired("request_body", Sequence.fromIterable((Iterable)FileUploadRequestProcessor.getFileItems()).count() > 0 ? Boolean.TRUE : null);
        DiskFileItem diskFileItem = (DiskFileItem)Sequence.fromIterable((Iterable)FileUploadRequestProcessor.getFileItems()).first();
        Entity f = PersistentFileImpl.constructor((DiskFileItem)diskFileItem);
        ((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)f, (String)"PersistentFile")).resize(16, 16, f);
        if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)ug, (String)"icon"), null)) {
            EntityOperations.remove((Entity)AssociationSemantics.getToOne((Entity)ug, (String)"icon"));
        }
        DirectedAssociationSemantics.setToOne((Entity)ug, (String)"icon", (Entity)f);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{group}/icon")
    public Response delete_GroupIcon(@PathParam(value="group") String group) {
        RequirePermissionSecurityConstraint.check(Permission.UPDATE_USERGROUP, null);
        Entity ug = EntityGetterUtil.getUserGroup(group, true);
        return ResponseUtil.deleted(AssociationSemantics.getToOne((Entity)ug, (String)"icon"));
    }

    private void replaceRole(Entity ug, UserRole userRoleJaxb) {
        Entity r = EntityGetterUtil.getRole(userRoleJaxb.getName(), true);
        TreeKeepingEntityIterable projects = userRoleJaxb.getProjectRef() == null ? QueryOperations.queryGetAll((String)"Project") : ListSequence.fromList(userRoleJaxb.getProjectRef()).select((_FunctionTypes._return_P1_E0)new ISelector<ProjectRef, Entity>(){

            public Entity select(ProjectRef it) {
                return EntityGetterUtil.getProject(it.getId(), true);
            }
        });
        Entity ur = QueryOperations.getFirst((Iterable)QueryOperations.query(((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)ug, (String)"UserGroup")).getUserRoles(ug), (String)"UserRole", (NodeBase)new LinksEqualDecorator("role", (NodeBase)new PropertyEqual("name", (Comparable)((Object)userRoleJaxb.getName())), "Role")));
        if (!EntityOperations.equals((Entity)ur, null)) {
            EntityOperations.remove((Entity)ur);
        }
        UserRoleImpl.createRoleWithCheck(r, (Iterable<Entity>)projects, ((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)ug, (String)"UserGroup")).getUserRoles(ug), ug, false);
    }

    private static boolean neq_xwsk0v_a0a5a4(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }
}

