/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartadmin.rest;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.rest.Count;
import jetbrains.charisma.rest.HasAdminReadSecurityConstraint;
import jetbrains.charisma.rest.HasAdminWriteSecurityConstraint;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.EntityGetterUtil;
import jetbrains.charisma.smartadmin.rest.IssueLinkPrototype;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.charisma.smartadmin.rest.RestAdminUrls;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

@Path(value="/admin/issueLinkType")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class AdminIssueLinkTypeResource
implements Resource {
    @GET
    public List<IssueLinkPrototype> get() {
        IsLoggedInSecurityConstraint.check();
        return ListSequence.fromListWithValues(new ArrayList(), (Iterable)Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)QueryOperations.queryGetAll((String)"IssueLinkPrototype"), (String)"IssueLinkPrototype", (NodeBase)new SortByProperty(null, "name", true))).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, IssueLinkPrototype>(){

            public IssueLinkPrototype select(Entity it) {
                return new IssueLinkPrototype(it);
            }
        }));
    }

    @GET
    @Path(value="/{name}")
    public IssueLinkPrototype get_Name(@PathParam(value="name") String name) {
        IsLoggedInSecurityConstraint.check();
        return new IssueLinkPrototype(EntityGetterUtil.getIssueLinkPrototype(name, true));
    }

    @GET
    @Path(value="/{name}/count")
    public Count get_NameCount(@PathParam(value="name") String name) {
        HasAdminReadSecurityConstraint.check();
        return new Count(((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)EntityGetterUtil.getIssueLinkPrototype(name, true), (String)"IssueLinkPrototype")).countUsages(EntityGetterUtil.getIssueLinkPrototype(name, true)));
    }

    @PUT
    @Path(value="/{name}")
    public Response put_Name(@PathParam(value="name") String name, @QueryParam(value="outwardName") String outwardName, @QueryParam(value="inwardName") String inwardName, @QueryParam(value="directed") boolean directed, @QueryParam(value="aggregation") Boolean aggregation) {
        HasAdminWriteSecurityConstraint.check();
        EntityGetterUtil.getIssueLinkPrototype(name, false);
        ResponseUtil.isRequired("outwardName", outwardName);
        if (directed) {
            ResponseUtil.isRequired("inwardName", inwardName);
        }
        if (aggregation == null) {
            aggregation = false;
        }
        IssueLinkPrototypeImpl.constructor(name, outwardName, inwardName, directed, aggregation);
        return ResponseUtil.created(RestAdminUrls.getIssueLinkType(name));
    }

    @POST
    @Path(value="/{name}")
    public Response post_Name(@PathParam(value="name") String name, @QueryParam(value="newName") String newName, @QueryParam(value="outwardName") String outwardName, @QueryParam(value="inwardName") String inwardName, @QueryParam(value="directed") Boolean directed, @QueryParam(value="aggregation") Boolean aggregation) {
        HasAdminWriteSecurityConstraint.check();
        Entity issueLinkPrototype = EntityGetterUtil.getIssueLinkPrototype(name, true);
        if (directed != null) {
            PrimitiveAssociationSemantics.set((Entity)issueLinkPrototype, (String)"directed", (Comparable)directed, Boolean.class);
        }
        if (aggregation != null) {
            PrimitiveAssociationSemantics.set((Entity)issueLinkPrototype, (String)"aggregation", (Comparable)aggregation, Boolean.class);
        }
        if (outwardName != null && outwardName.length() > 0) {
            PrimitiveAssociationSemantics.set((Entity)issueLinkPrototype, (String)"sourceToTarget", (Comparable)((Object)outwardName), String.class);
        }
        if (inwardName != null && inwardName.length() > 0) {
            PrimitiveAssociationSemantics.set((Entity)issueLinkPrototype, (String)"targetToSource", (Comparable)((Object)inwardName), String.class);
        }
        String oldName = (String)PrimitiveAssociationSemantics.get((Entity)issueLinkPrototype, (String)"name", String.class, null);
        if (newName != null && newName.length() > 0 && AdminIssueLinkTypeResource.neq_3t68qu_a0a8a4(newName, oldName)) {
            EntityGetterUtil.getIssueLinkPrototype(newName, false);
            PrimitiveAssociationSemantics.set((Entity)issueLinkPrototype, (String)"name", (Comparable)((Object)newName), String.class);
        }
        return ResponseUtil.updated(RestAdminUrls.getIssueLinkType((String)PrimitiveAssociationSemantics.get((Entity)issueLinkPrototype, (String)"name", String.class, null)), oldName, newName);
    }

    @DELETE
    @Path(value="/{name}")
    public Response delete_Name(@PathParam(value="name") String name) {
        HasAdminWriteSecurityConstraint.check();
        return ResponseUtil.deleted(EntityGetterUtil.getIssueLinkPrototype(name, true));
    }

    private static boolean neq_3t68qu_a0a8a4(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }
}

