/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartadmin.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistence.security.RoleImpl;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.charisma.smartadmin.rest.EntityGetterUtil;
import jetbrains.charisma.smartadmin.rest.Permission;
import jetbrains.charisma.smartadmin.rest.RequirePermissionSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.charisma.smartadmin.rest.RestAdminUrls;
import jetbrains.charisma.smartadmin.rest.Role;
import jetbrains.charisma.smartadmin.rest.RoleRef;
import jetbrains.exodus.entitystore.ComparableGetter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.ComparableGetterSort;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

@Path(value="/admin/role")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
public class AdminRoleResource
implements Resource {
    @GET
    public List<RoleRef> get() {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(jetbrains.youtrack.core.security.Permission.READ_ROLE, null);
        return ListSequence.fromListWithValues(new ArrayList(), (Iterable)Sequence.fromIterable((Iterable)QueryOperations.query((Iterable)QueryOperations.queryGetAll((String)"Role"), (String)"Role", (NodeBase)ComparableGetterSort.create(null, (ComparableGetter)new ComparableGetter(){

            public Comparable select(Entity it) {
                return ((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)"<no role>")).toLowerCase();
            }
        }, (boolean)true))).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, RoleRef>(){

            public RoleRef select(Entity it) {
                return new RoleRef((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)"<no role>"));
            }
        }));
    }

    @GET
    @Path(value="/{role}")
    public Role get_Role(@PathParam(value="role") String role) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(jetbrains.youtrack.core.security.Permission.READ_ROLE, null);
        Entity r = EntityGetterUtil.getRole(role, true);
        return new Role((String)PrimitiveAssociationSemantics.get((Entity)r, (String)"name", String.class, (Object)"<no role>"), PrimitiveAssociationSemantics.getBlobAsString((Entity)r, (String)"description"));
    }

    @PUT
    @Path(value="/{role}")
    public Response put_Role(@PathParam(value="role") String role, @QueryParam(value="description") String description) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(jetbrains.youtrack.core.security.Permission.CREATE_ROLE, null);
        EntityGetterUtil.getRole(role, false);
        Entity r = RoleImpl.constructor(role);
        PrimitiveAssociationSemantics.setBlob((Entity)r, (String)"description", (String)description);
        return ResponseUtil.created(RestAdminUrls.getRoleUrl(role));
    }

    @POST
    @Path(value="/{role}")
    public Response post_Role(@PathParam(value="role") String role, @QueryParam(value="newName") String newName, @QueryParam(value="description") String description) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(jetbrains.youtrack.core.security.Permission.UPDATE_ROLE, null);
        Entity r = EntityGetterUtil.getRole(role, true);
        if (description != null) {
            PrimitiveAssociationSemantics.setBlob((Entity)r, (String)"description", (String)description);
        }
        String oldName = (String)PrimitiveAssociationSemantics.get((Entity)r, (String)"name", String.class, (Object)"<no role>");
        if (newName != null && newName.length() > 0 && AdminRoleResource.neq_hj5321_a0a5a3(newName, oldName)) {
            EntityGetterUtil.getRole(newName, false);
            PrimitiveAssociationSemantics.set((Entity)r, (String)"name", (Comparable)((Object)newName), String.class);
        }
        return ResponseUtil.updated(RestAdminUrls.getRoleUrl(role), oldName, newName);
    }

    @GET
    @Path(value="/{role}/permission")
    public List<Permission> get_RolePermission(@PathParam(value="role") String role) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(jetbrains.youtrack.core.security.Permission.READ_ROLE, null);
        return ListSequence.fromListWithValues(new ArrayList(), (Iterable)Sequence.fromIterable(RoleImpl.fromDeprecated(AssociationSemantics.getToMany((Entity)EntityGetterUtil.getRole(role, true), (String)"permissions"))).sort((_FunctionTypes._return_P1_E0)new ISelector<jetbrains.youtrack.core.security.Permission, Comparable<?>>(){

            public Comparable<?> select(jetbrains.youtrack.core.security.Permission it) {
                return it.name();
            }
        }, true).select((_FunctionTypes._return_P1_E0)new ISelector<jetbrains.youtrack.core.security.Permission, Permission>(){

            public Permission select(jetbrains.youtrack.core.security.Permission it) {
                return new Permission(it.name(), it.getHumanizedName());
            }
        }));
    }

    @POST
    @Path(value="/{role}/permission/{permission}")
    public Response post_RolePermissionPermission(@PathParam(value="role") String role, @PathParam(value="permission") String permission) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(jetbrains.youtrack.core.security.Permission.UPDATE_ROLE, null);
        Entity r = EntityGetterUtil.getRole(role, true);
        jetbrains.youtrack.core.security.Permission p = EntityGetterUtil.getPermission(permission, true);
        ((RoleImpl)DnqUtils.getPersistentClassInstance((Entity)r, (String)"Role")).addPermission(p, r);
        RestUtil.waitForPermissionCacheRecalculation();
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{role}/permission/{permission}")
    public Response delete_RolePermissionPermission(@PathParam(value="role") String role, @PathParam(value="permission") String permission) {
        IsLoggedInSecurityConstraint.check();
        RequirePermissionSecurityConstraint.check(jetbrains.youtrack.core.security.Permission.UPDATE_ROLE, null);
        Entity r = EntityGetterUtil.getRole(role, true);
        jetbrains.youtrack.core.security.Permission p = EntityGetterUtil.getPermission(permission, true);
        ((RoleImpl)DnqUtils.getPersistentClassInstance((Entity)r, (String)"Role")).removePermission(p, r);
        RestUtil.waitForPermissionCacheRecalculation();
        return Response.ok().build();
    }

    private static boolean neq_hj5321_a0a5a3(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }
}

