/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartadmin.rest;

import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permission;

public class EntityGetterUtil {
    public static Entity getRole(String roleName, boolean shouldExist) {
        Entity role = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Role", (NodeBase)new PropertyEqual("name", (Comparable)((Object)roleName))));
        ResponseUtil.assertExist("Role", role, roleName, shouldExist);
        return role;
    }

    public static Permission getPermission(String permissionName, boolean shouldExist) {
        Permission permission = null;
        try {
            permission = Enum.valueOf(Permission.class, permissionName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ResponseUtil.assertExist("Permission", permission, permissionName, shouldExist);
        return permission;
    }

    public static Entity getUser(String login, boolean shouldExist) {
        Entity user = UserImpl.findUser(login);
        ResponseUtil.assertExist("User", user, login, shouldExist);
        return user;
    }

    public static Entity getUserGroup(String groupName, boolean shouldExist) {
        Entity userGroup = UserGroupImpl.findUserGroup(groupName);
        ResponseUtil.assertExist("Group", userGroup, groupName, shouldExist);
        return userGroup;
    }

    public static Entity getUserRole(Entity group, String userRoleName, boolean shouldExist) {
        Entity userRole = QueryOperations.getFirst((Iterable)QueryOperations.query(((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)group, (String)"UserGroup")).getUserRoles(group), (String)"UserRole", (NodeBase)new LinksEqualDecorator("role", (NodeBase)new PropertyEqual("name", (Comparable)((Object)userRoleName)), "Role")));
        ResponseUtil.assertExist("Role", userRole, userRoleName, shouldExist);
        return userRole;
    }

    public static Entity getProject(String projectShortName, boolean shouldExist) {
        Entity project = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("shortName", (Comparable)((Object)projectShortName))));
        ResponseUtil.assertExist("Project", project, projectShortName, shouldExist);
        return project;
    }

    public static Entity getIssueLinkPrototype(String linkName, boolean shouldExist) {
        Entity issueLinkPrototype = IssueLinkPrototypeImpl.find(linkName);
        ResponseUtil.assertExist("Issue link type", issueLinkPrototype, linkName, shouldExist);
        return issueLinkPrototype;
    }
}

