/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartadmin.rest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.provider.exception.RESTNotFoundException;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.ProjectImpl;

public class RequireReadPermissionToProjectFieldSecurityConstraint {
    public static void check(String projectId, String fieldName) {
        Entity project = ProjectImpl.findProject((String)projectId);
        if (EntityOperations.equals((Entity)project, null)) {
            throw new ForbiddenException("You have no permission for project [ " + projectId + " ]");
        }
        Entity field = QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)project, (String)"fields"), (String)"ProjectCustomField", (NodeBase)new LinksEqualDecorator("prototype", (NodeBase)new PropertyEqual("name", (Comparable)((Object)fieldName)), "CustomFieldPrototype")));
        if (EntityOperations.equals((Entity)field, null)) {
            throw new RESTNotFoundException("No field with name [ " + fieldName + " ] found attached to project [ " + projectId + " ]");
        }
        if (!((ProjectCustomFieldImpl)DnqUtils.getPersistentClassInstance((Entity)field, (String)"ProjectCustomField")).isReadAccessible(field)) {
            throw new ForbiddenException("You have no permission for field [ " + fieldName + " ] in project [ " + projectId + " ]");
        }
    }
}

