/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.comments;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.BaseCommentImpl;
import jetbrains.charisma.persistent.DraftCommentImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;

public class CommentWrapper {
    public Entity comment;
    private Entity issue;

    public CommentWrapper(Entity comment, Entity issue) {
        this.comment = comment;
        this.issue = issue;
    }

    public Entity getIssue() {
        return this.issue;
    }

    private void createDraft() {
        this.comment = ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).getCommentDraft(this.issue, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
    }

    public CommentWrapper reattach() {
        Entity comment = this.getComment();
        if (EntityOperations.equals((Entity)comment, null) || EntityOperations.isRemoved((Entity)comment)) {
            this.createDraft();
        }
        return this;
    }

    public CommentWrapper reattachDraftCommentIfExists() {
        Entity comment = this.getComment();
        if (!EntityOperations.equals((Entity)comment, null) && EntityOperations.isRemoved((Entity)comment)) {
            this.createDraft();
        }
        return this;
    }

    public void setComment(Entity comment) {
        this.comment = comment;
    }

    public Entity getComment() {
        return this.comment;
    }

    public void report() {
        if (this.isDraftComment()) {
            ((DraftCommentImpl)DnqUtils.getPersistentClassInstance((Entity)DnqUtils.cast((Object)this.comment, (String)"DraftComment"), (String)"DraftComment")).report(DnqUtils.cast((Object)this.comment, (String)"DraftComment"));
        }
    }

    public void addAttachment(Entity attachment) {
        ((BaseCommentImpl)DnqUtils.getPersistentClassInstance((Entity)this.comment, (String)"BaseComment")).addAttachment(attachment, this.comment);
    }

    public void removeAttachment(Entity attachment) {
        ((BaseCommentImpl)DnqUtils.getPersistentClassInstance((Entity)this.comment, (String)"BaseComment")).removeAttachment(attachment, this.comment);
    }

    public Iterable<Entity> getAttachments() {
        return ((BaseCommentImpl)DnqUtils.getPersistentClassInstance((Entity)this.comment, (String)"BaseComment")).getAttachments(this.comment);
    }

    public Iterable<Entity> getAttachmentsUnsorted() {
        return ((BaseCommentImpl)DnqUtils.getPersistentClassInstance((Entity)this.comment, (String)"BaseComment")).getAttachmentsUnsorted(this.comment);
    }

    public boolean hasAttachments() {
        return ((BaseCommentImpl)DnqUtils.getPersistentClassInstance((Entity)this.comment, (String)"BaseComment")).hasAttachments(this.comment);
    }

    public boolean isDraftComment() {
        return DnqUtils._instanceOf((Object)this.comment, (String)"DraftComment");
    }

    public String getText() {
        return !EntityOperations.equals((Entity)this.comment, null) ? PrimitiveAssociationSemantics.getBlobAsString((Entity)this.comment, (String)"text") : "";
    }

    public void setText(String value) {
        if (EntityOperations.equals((Entity)this.comment, null) && CommentWrapper.isEmpty_48uoq2_a0a0a0a0(value)) {
            return;
        }
        this.reattach();
        PrimitiveAssociationSemantics.setBlobWithFixedNewlines((Entity)this.comment, (String)"text", (String)value);
    }

    public boolean getUsesMarkdown() {
        return !EntityOperations.equals((Entity)this.comment, null) ? ((Boolean)PrimitiveAssociationSemantics.get((Entity)this.comment, (String)"usesMarkdown", Boolean.class, null)).booleanValue() : ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).shouldUseMarkdown(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
    }

    public void setUsesMarkdown(boolean value) {
        if (EntityOperations.equals((Entity)this.comment, null) && !value) {
            return;
        }
        this.reattach();
        PrimitiveAssociationSemantics.set((Entity)this.comment, (String)"usesMarkdown", (Comparable)Boolean.valueOf(value), Boolean.class);
    }

    public Iterable<Entity> getGroupsAndUsers() {
        return !EntityOperations.equals((Entity)this.comment, null) ? QueryOperations.concat((Iterable)AssociationSemantics.getToMany((Entity)this.comment, (String)"permittedGroup"), (Iterable)AssociationSemantics.getToMany((Entity)this.comment, (String)"permittedUser")) : QueryOperations.empty((String)"UserGroup");
    }

    public void setGroupsAndUsers(Iterable<Entity> value) {
        this.reattach();
        ArrayList<Entity> groups = new ArrayList<Entity>();
        ArrayList<Entity> users = new ArrayList<Entity>();
        for (Entity entity : Sequence.fromIterable(value)) {
            if ("UserGroup".equals(entity.getType())) {
                groups.add(entity);
                continue;
            }
            users.add(entity);
        }
        ((BaseCommentImpl)DnqUtils.getPersistentClassInstance((Entity)this.comment, (String)"BaseComment")).setPermitted(groups, users, this.comment);
    }

    public static boolean isEmpty_48uoq2_a0a0a0a0(String str) {
        return str == null || str.length() == 0;
    }
}

