/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.content;

import java.util.LinkedHashMap;
import java.util.Map;

public class Timings {
    private Map<String, Long> data = new LinkedHashMap<String, Long>();
    private long lastEncounter = System.nanoTime();

    public void checkpoint(String title) {
        long nextEncounter = System.nanoTime();
        this.data.put(title, nextEncounter - this.lastEncounter);
        this.lastEncounter = nextEncounter;
    }

    public long getTotal() {
        long total = 0L;
        for (Long value : this.data.values()) {
            total += value.longValue();
        }
        return total;
    }

    public Map<String, Long> getData() {
        return this.data;
    }

    public static String formatNanos(long nanos) {
        return String.format("%.2f", (double)nanos / 1000000.0);
    }
}

