/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.executor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jetbrains.charisma.misc.Message;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.workflow.exceptions.FieldRequiredException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.LinkUtil;
import jetbrains.mps.webr.runtime.util.ContentBuilder;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.JsCommandResponse;
import webr.framework.runtime.response.JsCompositeCommandResponse;
import webr.framework.textBuilder.TBuilderContext;

public class ComponentCallback {
    private static final String SESSION_FIELD = "issue2components";
    protected static Log log = LogFactory.getLog(ComponentCallback.class);
    private Map<String, _FunctionTypes._void_P1_E0<? super String>> componentToCallBack = MapSequence.fromMap(new HashMap());
    private Entity issue;

    private ComponentCallback(Entity issue) {
        this.issue = issue;
    }

    private boolean handleFieldRequiredException(FieldRequiredException fre) {
        _FunctionTypes._void_P1_E0 callback = (_FunctionTypes._void_P1_E0)MapSequence.fromMap(this.componentToCallBack).get((Object)fre.getFieldName());
        if (callback != null) {
            this.trace("Handle field required by component callback " + callback);
            callback.invoke((Object)fre.getMessage());
            return true;
        }
        return false;
    }

    public void register(String propertyName, _FunctionTypes._void_P1_E0<? super String> callback) {
        MapSequence.fromMap(this.componentToCallBack).put((Object)propertyName, callback);
    }

    private void trace(String msg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.issue, (String)"Issue")).getId(this.issue) + "] " + msg));
        }
    }

    private static ComponentCallback create(Entity issue) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + "] Register callbacks"));
        }
        if (BaseApplication.getSessionField((String)SESSION_FIELD, (boolean)false) == null) {
            BaseApplication.setSessionField((String)SESSION_FIELD, new HashMap(), (boolean)false);
        }
        ComponentCallback callback = new ComponentCallback(issue);
        ((Map)BaseApplication.getSessionField((String)SESSION_FIELD, (boolean)false)).put(issue, callback);
        return callback;
    }

    @NotNull
    public static ComponentCallback getCallback(Entity issue) {
        ComponentCallback callback;
        Map sessionMap = (Map)BaseApplication.getSessionField((String)SESSION_FIELD, (boolean)false);
        if (sessionMap != null && (callback = (ComponentCallback)sessionMap.get(issue)) != null) {
            return callback;
        }
        return ComponentCallback.create(issue);
    }

    public static void handledFieldRequiredException(final FieldRequiredException e) {
        ComponentCallback callback;
        Entity issue = e.getIssue();
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getId(issue) + "] Handle exception: " + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage()));
        }
        if ((callback = ComponentCallback.getCallback(issue)) != null && callback.handleFieldRequiredException(e)) {
            return;
        }
        Message.show(e.getMessage(), issue);
        JsCompositeCommandResponse commandResponse = BaseApplication.getCompositeCommand();
        if (commandResponse != null) {
            final String fieldName = e.getFieldName();
            commandResponse.addCommand((JsCommandResponse)ResponseFactory.getJsResponseFactory().getEvalResponse(ContentBuilder.toString((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TBuilderContext>(){

                public void invoke(TBuilderContext builderContext) {
                    LinkUtil.addScriptDependencies((TBuilderContext)builderContext, (Iterable)ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"jetbrains.charisma.smartui.js.CommonController", "jetbrains.youtrack.commands.ui.CommandDialogSupport"}));
                    builderContext.appendIndent();
                    builderContext.append("//select issue");
                    builderContext.appendNewLine();
                    builderContext.appendIndent();
                    builderContext.append("commonController.selectIssue(\"");
                    builderContext.append(JsStringUtil.stringLiteral((Object)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).toString((Object)e.getIssue())));
                    builderContext.append("\");");
                    builderContext.appendNewLine();
                    builderContext.appendIndent();
                    builderContext.append("//show command window");
                    builderContext.appendNewLine();
                    builderContext.appendIndent();
                    builderContext.append("commandDialog.show(\"");
                    builderContext.append(JsStringUtil.stringLiteral((Object)fieldName));
                    builderContext.append("\" + \" \");");
                    builderContext.appendNewLine();
                }
            }, (boolean)false)));
        }
    }
}

