/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.filter;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.smartui.filter.FilterParam;
import jetbrains.charisma.smartui.filter.FiltersSideBar_HtmlTemplateComponent;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterCounts {
    protected static Log log = LogFactory.getLog(FilterCounts.class);
    private Map<FilterParam, Integer> filterToCount = new HashMap();
    private boolean isCounting = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(FilterParam p) {
        FilterCounts filterCounts = this;
        synchronized (filterCounts) {
            Integer oldCount = this.filterToCount.get(p);
            if (oldCount != null) {
                return oldCount;
            }
            Integer newCount = QueryOperations.roughCount(p.getIntersectedIssues());
            this.filterToCount.put(p, newCount);
            return newCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(FiltersSideBar_HtmlTemplateComponent tpl) {
        if (!this.isCounting) {
            this.isCounting = true;
            boolean complete = true;
            try {
                long start = System.currentTimeMillis();
                FilterCounts filterCounts = this;
                synchronized (filterCounts) {
                    Integer count;
                    Set<FilterParam> keySet = this.filterToCount.keySet();
                    IListSequence filters = ListSequence.fromList(new ArrayList());
                    for (FilterParam fp : keySet) {
                        count = this.filterToCount.get(fp);
                        if (count != null && count != -1) continue;
                        ListSequence.fromList((List)filters).addElement((Object)fp);
                    }
                    for (FilterParam fp : keySet) {
                        count = this.filterToCount.get(fp);
                        if (count == null || count == -1) continue;
                        ListSequence.fromList((List)filters).addElement((Object)fp);
                    }
                    for (FilterParam fp : ListSequence.fromList((List)filters)) {
                        count = this.filterToCount.get(fp);
                        int oldCount = count == null ? -1 : count;
                        int newCount = QueryOperations.roughCount(fp.getIntersectedIssues());
                        if (newCount == -1) {
                            try {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Count is -1 for query [" + fp.getParseResult().getInputQuery() + "] group [" + fp.getGroupName() + "] param [" + fp.getFilterField() + "] owner [" + (String)PrimitiveAssociationSemantics.get((Entity)fp.getOwner(), (String)"login", String.class, (Object)"<no user>") + "]"));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (newCount != -1 && newCount != oldCount) {
                            this.filterToCount.put(fp, newCount);
                            fp.evalUpdateCountJs(tpl, newCount);
                        }
                        if (newCount == -1) {
                            complete = false;
                        }
                        if (System.currentTimeMillis() - start <= 100L) continue;
                        complete = false;
                        break;
                    }
                }
                boolean bl = complete;
                return bl;
            }
            finally {
                this.isCounting = false;
            }
        }
        return false;
    }
}

