/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.filter;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.smartui.filter.CountingOrderedEntityListener;
import jetbrains.charisma.smartui.filter.SortOrderReseter;
import jetbrains.charisma.smartui.parser.search.CheckedOptions;
import jetbrains.charisma.smartui.parser.search.FieldSort;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.parser.search.ParseResultUtil;
import jetbrains.charisma.smartui.parser.search.Parser;
import jetbrains.charisma.smartui.parser.search.RequestBuilderFactory;
import jetbrains.charisma.smartui.parser.search.SortProperty;
import jetbrains.charisma.smartui.parser.searchRequest.ParseError;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.charisma.smartui.watchFolder.SavedQueryImpl;
import jetbrains.charisma.smartui.watchFolder.SpecialFolders;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IPrefixTrees;
import jetbrains.youtrack.api.parser.RequestBuilder;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.security.Operation;
import org.jetbrains.annotations.NotNull;

public class FilterData
implements Serializable {
    private Entity folder;
    private String query;
    private CountingOrderedEntityListener orderListener = new CountingOrderedEntityListener();
    protected Entity user;
    private IParseResult parseResult;
    private CheckedOptions checkedOptions;
    private final Map<Object, Object> userObjects = new HashMap();
    private Context context;

    public FilterData(Entity folder, String query, Entity user, int pageSize) {
        this.folder = folder;
        this.query = query;
        this.user = user;
        this.parse();
    }

    public void refresh() {
        if (EntityOperations.isRemoved((Entity)this.folder)) {
            this.folder = null;
        }
        this.orderListener.reset();
        this.parse();
    }

    private void parse() {
        this.context = new Context(EntityOperations.equals((Entity)this.folder, null) ? null : this.orderListener);
        this.parseResult = ((Parser)ServiceLocator.getBean((String)"parser")).parse(QueryOperations.singleton((Entity)this.folder), this.query, this.context);
        this.checkedOptions = new CheckedOptions(this.parseResult);
    }

    public IParseResult getFilter() {
        return this.parseResult;
    }

    public Iterable<? extends ParseError> getParseErrors() {
        return this.parseResult.getParseErrors(this.context, this.user);
    }

    public Iterable<Entity> getPage(int from, int pageSize) {
        return QueryOperations.take((Iterable)QueryOperations.skip(this.getIssues(true, true), (int)from), (int)(from + pageSize - from));
    }

    public Iterable<Entity> getIssues(boolean secured, boolean sorted) {
        if (FilterData.neq_3myg1d_a0a0f(this.getFolder(), QueryOperations.getFirst(this.getContext().getContextFolders()))) {
            this.orderListener.reset();
            this.parse();
        }
        RequestBuilder builder = ((RequestBuilderFactory)ServiceLocator.getBean((String)"requestBuilderFactory")).newRequestBuilder(this.parseResult, this.context).me(this.user);
        if (secured) {
            builder = builder.secure();
        }
        if (sorted && this.canBeSortedByRelevance()) {
            sorted = false;
        }
        if (sorted) {
            builder = builder.sort();
        }
        Iterable issues = builder.issues();
        return issues;
    }

    public CheckedOptions getCheckedOptions() {
        return this.checkedOptions;
    }

    public String setSort(Iterable<FieldSort> sortProperties) {
        return ((ParseResultUtil)ServiceLocator.getBean((String)"parseResultUtil")).setSortProperties(this.parseResult, sortProperties, (IPrefixTrees)ServiceLocator.getBean((String)"prefixTrees"));
    }

    public Iterable<SortProperty> getSort() {
        return this.canBeSortedByRelevance() ? Sequence.fromIterable(Collections.emptyList()) : ((ParseResultUtil)ServiceLocator.getBean((String)"parseResultUtil")).getSortProperties(this.parseResult, this.folder);
    }

    public Object getUserObject(Object key, _FunctionTypes._return_P0_E0<? extends Object> userObjectCreator) {
        Object userObject = this.userObjects.get(key);
        if (userObject == null) {
            userObject = userObjectCreator.invoke();
            this.userObjects.put(key, userObject);
        }
        return userObject;
    }

    public void clearUserObjects() {
        this.userObjects.clear();
    }

    public void removeUserObject(Object key) {
        this.userObjects.remove(key);
    }

    public Entity getUser() {
        return this.user;
    }

    public Context getContext() {
        return this.context;
    }

    public Entity getFolder() {
        return this.folder;
    }

    public void setFolder(Entity watchFolder) {
        this.folder = watchFolder;
    }

    public long getNumberOfOrderedIssues() {
        return this.orderListener.getCount();
    }

    public boolean canBeSortedByRelevance() {
        return ((ParseResultUtil)ServiceLocator.getBean((String)"parseResultUtil")).canBeSortedByRelevance(this.user, this.parseResult, this.folder);
    }

    public boolean canSwitchToSortingByRelevance() {
        return ((ParseResultUtil)ServiceLocator.getBean((String)"parseResultUtil")).canBeSortedByRelevance(this.parseResult, this.folder);
    }

    public boolean hasLooksLikeSearch() {
        return !QueryOperations.isEmpty(this.parseResult.getLooksLikeSearch((IField)ServiceLocator.getBean((String)"predefinedFieldSimilarTo")));
    }

    public void resetOrder() {
        if (!EntityOperations.equals((Entity)this.folder, null) && ((IssueFolderImpl)DnqUtils.getPersistentClassInstance((Entity)this.folder, (String)"IssueFolder")).isAccessible(Operation.UPDATE, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), this.folder)) {
            this.orderListener.reset();
            if (SpecialFolders.isHidden(this.folder)) {
                EntityOperations.remove((Entity)this.folder);
                this.refresh();
            } else {
                ((SortOrderReseter)ServiceLocator.getBean((String)"sortOrderReseter")).resetSortOrder(this.folder);
            }
        }
    }

    @NotNull
    public static FilterData create(String query, Entity folder, Entity owner, int resultsPerPage) {
        String string = query = query == null ? null : query.trim();
        if (!EntityOperations.equals((Entity)folder, null) && !((IssueFolderImpl)DnqUtils.getPersistentClassInstance((Entity)folder, (String)"IssueFolder")).isAccessible(Operation.READ, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), folder)) {
            folder = null;
        }
        if (EntityOperations.equals((Entity)folder, null)) {
            folder = SavedQueryImpl.findHidden(query, false);
        }
        return new FilterData(folder, query, owner, resultsPerPage);
    }

    private static boolean neq_3myg1d_a0a0f(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }
}

