/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.filter;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.charisma.smartui.filter.FilterData;
import jetbrains.charisma.smartui.filter.FilterParam;
import jetbrains.charisma.smartui.filter.FilterParams;
import jetbrains.charisma.smartui.filter.LazyLoadFilterParams;
import jetbrains.charisma.smartui.keyword.FieldPoolUtil;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IField;

public class FilterParamsCalculator {
    public static final int EXPAND_INC = 42;
    private static final int TOTAL_FILTERS = 16;
    Map<IField, FilterParams> filters;
    private AtomicBoolean ready = new AtomicBoolean();
    private AtomicInteger progress = new AtomicInteger();
    private AtomicReference<Exception> exception = new AtomicReference();
    private FilterData filterData;
    private IParseResult parsedFilter;
    private Map<String, FilterParam> filterParams = new HashMap<String, FilterParam>();
    private Iterable<Entity> unsortedIssues;

    public FilterParamsCalculator(FilterData filterData) {
        this.filterData = filterData;
        this.parsedFilter = filterData.getFilter();
        this.unsortedIssues = filterData.getIssues(true, false);
        this.calculate();
    }

    public boolean isReady() {
        Exception e = this.exception.get();
        if (e != null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return this.ready.get();
    }

    public int getProgress() {
        return this.progress.get() * 100 / 16;
    }

    public Map<String, FilterParam> getParams() {
        return this.filterParams;
    }

    private void incProgress() {
        this.progress.incrementAndGet();
    }

    private void calculate() {
        Iterable<Entity> issues = this.getIssuesUnsorted();
        Entity user = this.filterData.getUser();
        this.filters = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        Entity singleProject = null;
        for (IField field : Sequence.fromIterable(FieldPoolUtil.getAccessibleFilterFields(user))) {
            Set<FilterParam> projectParams;
            FilterParams filterParams = this.add(field, issues, singleProject, user);
            if (((IField)ServiceLocator.getBean((String)"predefinedFieldProject")).equals(field) && SetSequence.fromSet(projectParams = filterParams.getFoundParams()).count() == 1) {
                singleProject = DnqUtils.cast((Object)((FilterParam)SetSequence.fromSet(projectParams).first()).getFilterField().getFieldValue(), (String)"Project");
            }
            MapSequence.fromMap(this.filters).put((Object)field, (Object)filterParams);
        }
        this.ready.set(true);
    }

    private FilterParams add(IField field, Iterable<Entity> issues, Entity singleProject, Entity meUser) {
        FilterParams filterParams = LazyLoadFilterParams.createFilterParams(issues, singleProject, field, meUser, true, this.parsedFilter, true);
        filterParams.setFilterParamsCalculation(this);
        this.updateFilterParams(filterParams);
        this.incProgress();
        return filterParams;
    }

    public void updateFilterParams(FilterParams filterParams) {
        for (FilterParam filterParam : SetSequence.fromSet(filterParams.getFoundParams())) {
            MapSequence.fromMap(this.filterParams).put((Object)filterParam.getId(), (Object)filterParam);
        }
    }

    public Iterable<Entity> getIssuesUnsorted() {
        return this.unsortedIssues;
    }
}

