/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.inplaceSimilarIssue;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import jetbrains.charisma.persistent.CharismaJob;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Transaction;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permissions;
import jetbrains.youtrack.textindex.TextIndexManagerCompat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.BeanContainerAwareSingleThreadDelegatingJobProcessor;
import webr.framework.controller.WebLocalScope;

public class SimilarIssuesCalculator {
    public static final int NEW_ISSUE_SIMILAR = 7;
    public static final float SAME_PROJECT_SCORE_MULTIPLE;
    public static final float NOT_SIMILAR_THRESHOLD;
    protected static Log log;
    private Entity owner;

    public SimilarIssuesCalculator(Entity owner) {
        this.owner = owner;
    }

    public void findSimilar(Entity issue, int count, _FunctionTypes._void_P1_E0<? super List<Entity>> onFinish) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        SimilarIssuesSearchJob searchJob = new SimilarIssuesSearchJob(issue, this.owner, onFinish, WebLocalScope.getContainer(), count);
        if (log.isTraceEnabled()) {
            log.trace((Object)("added search job: " + searchJob.getId()));
        }
        ((BeanContainerAwareSingleThreadDelegatingJobProcessor)ServiceLocator.getBean((String)"asyncUIJobProcessor")).queue((Job)searchJob, Priority.highest);
    }

    public static Iterable<Entity> findSimilar(Entity sample, Entity loggedInUser, boolean applyPermissions) {
        EntityIterable similar = ((TextIndexManagerCompat)ServiceLocator.getBean((String)"textIndexManager")).findSimilarIssues(((TransientEntity)sample).getPersistentEntity());
        TransientStoreSession session = DnqUtils.getCurrentTransientSession();
        EntityIterable wrapped = session.createPersistentEntityIterableWrapper(similar);
        if (applyPermissions) {
            return ((Permissions)ServiceLocator.getBean((String)"permissions")).applyPreserveDraftsAndDeleted(loggedInUser, (Iterable)wrapped);
        }
        return wrapped;
    }

    static {
        log = LogFactory.getLog(SimilarIssuesCalculator.class);
        String multiple = System.getProperty("jetbrains.charisma.similarIssues.sameProjectMultiple");
        float f = 1.6179775f;
        try {
            if (multiple != null) {
                f = Float.parseFloat(multiple);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SAME_PROJECT_SCORE_MULTIPLE = f;
        multiple = System.getProperty("jetbrains.charisma.similarIssues.notSimilarThreshold");
        f = 0.045f;
        try {
            if (multiple != null) {
                f = Float.parseFloat(multiple);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NOT_SIMILAR_THRESHOLD = f;
    }

    private static class SimilarIssuesSearchJob
    extends CharismaJob {
        private final Entity sample;
        private final _FunctionTypes._void_P1_E0<? super List<Entity>> handleSearchFinish;
        private final Entity requester;
        private final BeanContainer container;
        private final int count;

        public SimilarIssuesSearchJob(Entity issue, Entity requester, _FunctionTypes._void_P1_E0<? super List<Entity>> onFinish, BeanContainer container, int count) {
            super(issue);
            this.sample = issue;
            this.handleSearchFinish = onFinish;
            this.requester = requester;
            this.container = container;
            this.count = count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute() throws Throwable {
            BeanContainer oldContainer = WebLocalScope.getContainerDontCreate();
            try {
                WebLocalScope.setLocalBeanContainer((BeanContainer)this.container);
                try {
                    ((TextIndexManagerCompat)ServiceLocator.getBean((String)"textIndexManager")).executeSearchAction(new Runnable(){

                        @Override
                        public void run() {
                            this.doExecute();
                        }
                    });
                }
                finally {
                    Transaction unfinishedTxn = ((ContextualEnvironment)((Environment)ServiceLocator.getBean((String)"textIndexDataEnvironment"))).getCurrentTransaction();
                    if (unfinishedTxn != null) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Text index transaction leak detected, resolving...");
                        }
                        unfinishedTxn.abort();
                    }
                }
            }
            finally {
                if (oldContainer != null) {
                    WebLocalScope.setLocalBeanContainer((BeanContainer)oldContainer);
                } else {
                    WebLocalScope.removeLocalBeanContainer();
                }
            }
        }

        private void doExecute() {
            long t = System.nanoTime();
            long attempt = 0L;
            final Wrappers._T summary = new Wrappers._T();
            final Wrappers._T description = new Wrappers._T();
            final Wrappers._boolean summaryAndDescrChanged = new Wrappers._boolean();
            final Wrappers._T id = new Wrappers._T(null);
            do {
                _Txn.runReadonly((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                    public void invoke() {
                        if (id.value == null) {
                            id.value = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)sample, (String)"Issue")).getId(sample);
                        }
                        summary.value = PrimitiveAssociationSemantics.get((Entity)sample, (String)"summary", String.class, null);
                        description.value = PrimitiveAssociationSemantics.getBlobAsString((Entity)sample, (String)"description");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Looking for similar for [" + (String)id.value + "]: " + (String)summary.value));
                        }
                        handleSearchFinish.invoke((Object)Sequence.fromIterable((Iterable)QueryOperations.take((Iterable)Sequence.fromIterable(SimilarIssuesCalculator.findSimilar(sample, requester, true)).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                            public boolean accept(Entity it) {
                                return !EntityOperations.isRemoved((Entity)it);
                            }
                        }), (int)count)).toListSequence());
                        DnqUtils.getCurrentTransientSession().revert();
                        summaryAndDescrChanged.value = SimilarIssuesSearchJob.neq_1mdyn7_a0a0g0a0a0a0a7a1a_0(summary.value, PrimitiveAssociationSemantics.get((Entity)sample, (String)"summary", String.class, null)) || SimilarIssuesSearchJob.neq_1mdyn7_a0a0g0a0a0a0a7a1a(description.value, PrimitiveAssociationSemantics.getBlobAsString((Entity)sample, (String)"description"));
                    }
                });
            } while (attempt++ < 100L && summaryAndDescrChanged.value);
            t = System.nanoTime() - t;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get similar issues for [" + (String)id.value + "] in " + String.format("%.2f", (double)t / 1000000.0) + "ms " + (attempt > 1L ? " using " + attempt + " attempts" : "")));
            }
        }

        private static boolean neq_1mdyn7_a0a0g0a0a0a0a7a1a(Object a, Object b) {
            return !(a == null ? a == b : a.equals(b));
        }

        private static boolean neq_1mdyn7_a0a0g0a0a0a0a7a1a_0(Object a, Object b) {
            return !(a == null ? a == b : a.equals(b));
        }
    }
}

