/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.issueCommon;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.filter.FilterData;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;

public class IssueHierarchyNode
implements Comparable<IssueHierarchyNode> {
    private final int index;
    private final Entity member;
    private final SortedSet<IssueHierarchyNode> children = new TreeSet<IssueHierarchyNode>();

    private IssueHierarchyNode(Entity member, long memberId, Map<Long, Integer> indices) {
        Integer idx;
        this.index = EntityOperations.equals((Entity)member, null) ? Integer.MAX_VALUE : ((idx = indices.get(memberId)) == null ? (int)memberId + indices.size() : idx);
        this.member = member;
    }

    @Override
    public int compareTo(IssueHierarchyNode other) {
        int y;
        int x = this.getIndex();
        return x < (y = other.getIndex()) ? -1 : (x == y ? 0 : 1);
    }

    private int getIndex() {
        return Math.abs(this.index);
    }

    public boolean notMatchesSearch() {
        return this.index < 0;
    }

    public Entity getIssue() {
        return DnqUtils.cast((Object)this.member, (String)"Issue");
    }

    public Entity getParent(Entity issue) {
        return this.getParent(issue, null);
    }

    public Entity getParent(Entity issue, Entity parent) {
        if (EntityOperations.equals((Entity)this.member, (Object)issue)) {
            return parent;
        }
        if (this.children != null) {
            for (IssueHierarchyNode child : this.children) {
                Entity result = child.getParent(issue, this.getIssue());
                if (EntityOperations.equals((Entity)result, null)) continue;
                return result;
            }
        }
        return null;
    }

    public SortedSet<IssueHierarchyNode> getChildren() {
        return this.children;
    }

    public void addIssues(Iterable<Entity> issues, final LongHashSet visited, final Map<Long, Integer> indices, final FilterData filterData, final EntityIdSet found) {
        Sequence.fromIterable(issues).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                long id = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).getPersistentLocalId(it);
                if (!visited.contains(id) && (indices.get(id) != null || IssueHierarchyNode.this.matches(it, filterData, found))) {
                    visited.add(id);
                    if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).isAccessible(Operation.READ, it)) {
                        IssueHierarchyNode child = new IssueHierarchyNode(it, id, indices);
                        IssueHierarchyNode.this.children.add(child);
                        child.addIssues(((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Issue")).getSubtasks(it), visited, indices, filterData, found);
                    }
                }
            }
        });
    }

    private boolean matches(Entity it, FilterData filterData, EntityIdSet found) {
        if (found != null) {
            return found.contains(it.getId());
        }
        return filterData.getFilter().matchesIssue(it, filterData.getContext(), ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
    }

    public static IssueHierarchyNode buildHierarchy(Iterable<Entity> issues, FilterData filterData, EntityIdSet found) {
        LinkedHashSet<Entity> topLevelIssues = new LinkedHashSet<Entity>();
        LongHashSet visited = new LongHashSet();
        int i = 1;
        LongHashMap indices = new LongHashMap();
        for (Entity issue : issues) {
            long id = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getPersistentLocalId(issue);
            if (visited.contains(id)) continue;
            while (true) {
                Entity parent;
                if (EntityOperations.equals((Entity)(parent = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).getParentIssue(issue)), null) || !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)parent, (String)"Issue")).isAccessible(Operation.READ, parent)) {
                    topLevelIssues.add(issue);
                    break;
                }
                long parentId = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)parent, (String)"Issue")).getPersistentLocalId(parent);
                if (indices.get(parentId) != null) break;
                indices.put(parentId, -i++);
                issue = parent;
            }
            indices.put(id, i++);
        }
        IssueHierarchyNode topLevelNode = new IssueHierarchyNode(null, 0L, (Map<Long, Integer>)indices);
        topLevelNode.addIssues(topLevelIssues, visited, (Map<Long, Integer>)indices, filterData, found);
        return topLevelNode;
    }
}

