/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.watchFolder;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.plugins.DisplayUserProfile;
import jetbrains.charisma.service.UserProfileService;
import jetbrains.charisma.smartui.watchFolder.Folders;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import org.jetbrains.annotations.NotNull;

public abstract class IssueFolderSidebarSettings<T extends Entity> {
    private final String name;
    private final Entity explicitUser;
    private final boolean canCollapse;
    private Boolean cachedPersistentExpanded;
    private boolean myPersistentExpanded;

    public IssueFolderSidebarSettings(String name, Entity explicitUser, boolean collapsible) {
        this.name = name;
        this.explicitUser = explicitUser;
        this.canCollapse = collapsible;
    }

    public String getName() {
        return this.name;
    }

    public Entity getUser() {
        return EntityOperations.equals((Entity)this.explicitUser, null) ? ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get() : this.explicitUser;
    }

    public boolean isCollapsible() {
        return this.canCollapse;
    }

    protected DisplayUserProfile getUserProfile() {
        return ((UserProfileService)ServiceLocator.getBean((String)"userProfileService")).getDisplayUserProfile(this.getUser());
    }

    public Folders getFolders() {
        ArrayList<Entity> pinned = null;
        ArrayList<Entity> unpinned = null;
        Entity user = this.getUser();
        for (Entity folder : this.getAllSortedFolders()) {
            if (this.isPinned(folder, user)) {
                if (pinned == null) {
                    pinned = new ArrayList<Entity>();
                }
                pinned.add(folder);
                continue;
            }
            if (unpinned == null) {
                unpinned = new ArrayList<Entity>();
            }
            unpinned.add(folder);
        }
        return new Folders(pinned, unpinned);
    }

    protected boolean isPinned(T folder, Entity user) {
        return ((IssueFolderImpl)DnqUtils.getPersistentClassInstance(folder, (String)"IssueFolder")).isNotUnpinned(user, folder);
    }

    @NotNull
    public abstract Iterable<T> getAllSortedFolders();

    public boolean getExpanded() {
        if (this.cachedPersistentExpanded == null) {
            this.cachedPersistentExpanded = !this.canCollapse || this.getPersistentExpanded();
        }
        return this.cachedPersistentExpanded;
    }

    public void setExpanded(boolean value) {
        this.cachedPersistentExpanded = value;
        this.setPersistentExpanded(value);
    }

    protected boolean getPersistentExpanded() {
        return this.myPersistentExpanded;
    }

    protected void setPersistentExpanded(boolean value) {
        this.myPersistentExpanded = value;
    }
}

