/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.watchFolder;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.smartui.watchFolder.StarService;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.StaticTypedIterableDecorator;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Permissions;
import jetbrains.youtrack.core.security.Security;
import jetbrains.youtrack.core.watchFolder.RuleType;

public class IssueWatchers {
    public static final int MASK = RuleType.NOTIFY_ON_COMMENT_POST.mask | RuleType.NOTIFY_ON_ISSUE_UPDATE.mask | RuleType.NOTIFY_ON_NEW_ISSUE.mask | RuleType.NOTIFY_ON_ISSUE_RESOLVE.mask | RuleType.NOTIFY_ON_VOTE.mask;
    private Iterable<Entity> watchers;
    private Boolean accessible;
    private Map<Entity, Entity> duplicatesWatchers;
    private EntityIdSet starrers;
    private HashSet duplicateStarrers;
    private final Entity issue;

    public IssueWatchers(Entity issue) {
        this.issue = issue;
        this.reset();
    }

    public void reset() {
        this.accessible = null;
        this.watchers = null;
        this.duplicatesWatchers = null;
        this.starrers = null;
        this.duplicateStarrers = null;
    }

    public boolean isCalculated() {
        return this.watchers != null && this.duplicatesWatchers != null;
    }

    public int getSize() {
        if (!this.isCalculated()) {
            return -1;
        }
        return QueryOperations.getSize(this.watchers) + MapSequence.fromMap(this.duplicatesWatchers).count();
    }

    public boolean isAccessible() {
        if (this.accessible == null) {
            this.accessible = ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.issue, (String)"Issue")).isAccessible(Operation.VIEW_WATCHERS, this.issue);
        }
        return this.accessible;
    }

    public boolean isAccessible(Entity user) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)this.issue, (String)"Issue")).isAccessible(Operation.VIEW_WATCHERS, user, this.issue);
    }

    public Iterable<Entity> getWatchers() {
        if (this.watchers == null) {
            this.calculate();
        }
        return this.watchers;
    }

    public Map<Entity, Entity> getDuplicatesWatchers() {
        if (this.duplicatesWatchers == null) {
            this.calculate();
        }
        return this.duplicatesWatchers;
    }

    public boolean isStarrer(Entity user) {
        return this.starrers.contains((EntityId)DnqUtils.toPersistentId((Entity)user));
    }

    public boolean isDuplicateStarrer(Entity user) {
        return this.duplicateStarrers.contains(user);
    }

    private Map<Entity, Entity> calculateDuplicateWachersAndStarrers(PersistentStoreTransaction txn) {
        long clusterId = (Long)PrimitiveAssociationSemantics.get((Entity)this.issue, (String)"duplicateCluster", Long.class, null);
        if (clusterId == 0L) {
            return Collections.EMPTY_MAP;
        }
        Entity me = ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get();
        Iterable duplicates = ((Permissions)ServiceLocator.getBean((String)"permissions")).apply(me, QueryOperations.exclude((Iterable)QueryOperations.query(null, (String)"Issue", (NodeBase)new PropertyEqual("duplicateCluster", (Comparable)Long.valueOf(clusterId))), (Iterable)QueryOperations.singleton((Entity)this.issue)), ((Security)ServiceLocator.getBean((String)"security")).getProjectsUnordered(me, Permission.VIEW_WATCHERS, false));
        HashMap result = new HashMap();
        String star = ((StarService)ServiceLocator.getBean((String)"starService")).getStarName();
        TreeKeepingEntityIterable tkei = QueryOperations.query((Iterable)QueryOperations.selectManyDistinct((Iterable)duplicates, (String)"tags"), (String)"IssueTag", (NodeBase)new PropertyEqual("name", (Comparable)((Object)star)));
        EntityIterableBase source = ((EntityIterableBase)tkei.instantiate()).getSource();
        EntityIdSet stars = source == EntityIterableBase.EMPTY ? EntityIdSetFactory.newSet() : source.toSet(txn);
        for (Entity issue : Sequence.fromIterable((Iterable)duplicates)) {
            this.addDirectTagWatchers(issue, (Map<Entity, Entity>)result);
            if (stars.count() <= 0) continue;
            this.addDuplicateStarrers(issue, (Map<Entity, Entity>)result, stars);
        }
        return result;
    }

    private void addDuplicateStarrers(Entity issue, Map<Entity, Entity> result, EntityIdSet stars) {
        for (Entity tag : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"tags"))) {
            if (!stars.contains(tag.getId())) continue;
            Entity user = AssociationSemantics.getToOne((Entity)tag, (String)"owner");
            result.put(user, issue);
            this.duplicateStarrers.add(user);
        }
    }

    private void addDirectTagWatchers(Entity issue, Map<Entity, Entity> result) {
        for (Entity user : Sequence.fromIterable(this.getIssueTagWatchers(issue))) {
            result.put(user, issue);
        }
    }

    private Iterable<Entity> getIssueStarrers(Entity issue, String star) {
        return QueryOperations.selectDistinct((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"tags"), (String)"IssueTag", (NodeBase)new PropertyEqual("name", (Comparable)((Object)star))), (String)"owner");
    }

    private Iterable<Entity> getIssueTagWatchers(Entity issue) {
        Iterable watchRules = QueryOperations.selectManyDistinct((Iterable)AssociationSemantics.getToMany((Entity)issue, (String)"tags"), (String)"watchRules");
        HashSet<Entity> owners = new HashSet<Entity>();
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity rule : Sequence.fromIterable((Iterable)watchRules)) {
            Entity owner;
            if (!RuleType.is((int)((Integer)PrimitiveAssociationSemantics.get((Entity)rule, (String)"mask", Integer.class, null)), (int)MASK) || owners.contains(owner = AssociationSemantics.getToOne((Entity)rule, (String)"owner"))) continue;
            owners.add(owner);
            if (!((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)issue, (String)"Issue")).isAccessible(Operation.READ, owner, issue)) continue;
            result.add(owner);
        }
        return result;
    }

    public void calculate() {
        this.watchers = this.getIssueTagWatchers(this.issue);
        Iterable<Entity> originalStarrers = this.getIssueStarrers(this.issue, ((StarService)ServiceLocator.getBean((String)"starService")).getStarName());
        PersistentStoreTransaction txn = (PersistentStoreTransaction)((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getCurrentTransaction();
        EntityIterableBase eib = ((EntityIterableBase)((EntityIterable)((StaticTypedIterableDecorator)originalStarrers).instantiate())).getSource();
        this.starrers = eib == EntityIterableBase.EMPTY ? EntityIdSetFactory.newSet() : eib.toSet(txn);
        this.watchers = QueryOperations.union(this.watchers, originalStarrers);
        this.duplicateStarrers = new HashSet();
        this.duplicatesWatchers = this.calculateDuplicateWachersAndStarrers(txn);
        for (Entity user : Sequence.fromIterable(this.watchers)) {
            MapSequence.fromMap(this.duplicatesWatchers).removeKey((Object)user);
        }
    }

    public Entity getIssue() {
        return this.issue;
    }
}

