/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.watchFolder;

import jetbrains.charisma.smartui.filter.CountingOrderedEntityListener;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterator;
import jetbrains.youtrack.api.parser.OrderedEntitiesListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortIterableWithCallBack
extends EntityIterableBase {
    private EntityIterableBase wrapped;
    private final OrderedEntitiesListener callback;

    public SortIterableWithCallBack(EntityIterableBase wrapped, OrderedEntitiesListener callback) {
        super(wrapped.getTransaction());
        this.wrapped = wrapped;
        this.callback = callback;
    }

    @NotNull
    public EntityIterator getIteratorImpl(PersistentStoreTransaction txn) {
        EntityIterator iterator = this.wrapped.getIteratorImpl(txn);
        if (iterator instanceof PropertyValueIterator) {
            if (this.callback instanceof CountingOrderedEntityListener) {
                ((CountingOrderedEntityListener)this.callback).reset();
            }
            Iterator iter = new Iterator(this.wrapped, (PropertyValueIterator)iterator);
            return iter;
        }
        return iterator;
    }

    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return this.wrapped.getHandle();
    }

    protected long countImpl(PersistentStoreTransaction txn) {
        return this.wrapped.count();
    }

    public boolean canBeCached() {
        return false;
    }

    public boolean isSortedById() {
        return false;
    }

    public boolean isThreadSafe() {
        return false;
    }

    private class Iterator
    extends EntityIteratorBase {
        private final PropertyValueIterator sourceIter;
        private boolean orderFinished;

        private Iterator(@NotNull EntityIterableBase source, PropertyValueIterator sourceIter) {
            super(source);
            this.orderFinished = false;
            this.sourceIter = sourceIter;
        }

        protected boolean hasNextImpl() throws ExodusException {
            return this.sourceIter.hasNext();
        }

        @Nullable
        protected EntityId nextIdImpl() throws ExodusException {
            EntityId result = this.sourceIter.nextId();
            this.callbackIfNeeded(result);
            return result;
        }

        private void callbackIfNeeded(EntityId entityId) {
            if (SortIterableWithCallBack.this.callback != null && !this.orderFinished && this.sourceIter.currentValue() != null) {
                SortIterableWithCallBack.this.callback.onEntityOrdered(entityId);
            } else {
                this.orderFinished = true;
            }
        }
    }
}

