/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.watchFolder;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.UndirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.LinkedHashSet;
import java.util.Set;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.charisma.persistent.BadCharsException;
import jetbrains.charisma.persistent.IProjectFieldValue;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.smartui.dto.IssueRequestDataHolder;
import jetbrains.charisma.smartui.parser.search.IParseResult;
import jetbrains.charisma.smartui.parser.search.ParseResultUtil;
import jetbrains.charisma.smartui.parser.search.Parser;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.charisma.smartui.watchFolder.SavedQueryImpl;
import jetbrains.charisma.smartui.watchFolder.SharingSettingImpl;
import jetbrains.charisma.smartui.watchFolder.StringUtils;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.NullPropertyException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinksEqualDecorator;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.api.parser.IFieldValue;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.watchFolder.RuleType;
import jetbrains.youtrack.core.watchFolder.WatchRuleImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public class WatchFolderImpl
extends IssueFolderImpl {
    private static String __ENTITY_TYPE__ = "WatchFolder";
    public static final String RESTRICTED_CHARS = "<>&,";
    public static final int MAX_LENGHT = 150;
    protected static Log log = LogFactory.getLog(WatchFolderImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String name, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)name), String.class);
        return entity;
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        if (!EntityOperations.isRemoved((Entity)entity)) {
            String name = (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)IssueFolderImpl.getNullName());
            if (org.apache.commons.lang.StringUtils.isBlank((String)name)) {
                throw new ConstraintsValidationException((DataIntegrityViolationException)new NullPropertyException((TransientEntity)entity, "name"));
            }
            if (!WatchFolderImpl.isValidName(name)) {
                throw new ConstraintsValidationException((DataIntegrityViolationException)new BadCharsException((TransientEntity)entity, "name", "name", RESTRICTED_CHARS));
            }
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)(name == null ? null : name.trim())), String.class);
        }
    }

    public boolean isAccessible(Operation o, Entity user, Entity entity) {
        if (EntityOperations.isRemoved((Entity)entity)) {
            return false;
        }
        if (WatchFolderImpl.eq_x0sjq6_a0b0d(o, Operation.READ)) {
            return ((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"WatchFolder")).isVisibleFor(user, entity);
        }
        if (WatchFolderImpl.eq_x0sjq6_a0a1a3(o, Operation.UPDATE)) {
            if (((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"WatchFolder")).isOwner(user, entity)) {
                return true;
            }
            if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.UPDATE_NOT_OWN_PROFILE, user)) {
                return true;
            }
            Entity uss = AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting");
            return uss != null && !EntityOperations.isRemoved((Entity)uss) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isInGroup(AssociationSemantics.getToOne((Entity)uss, (String)"userGroup"), user) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.UPDATE_WATCH_FOLDER, user);
        }
        if (WatchFolderImpl.eq_x0sjq6_a0b1a3(o, Operation.SHARE)) {
            if (!this.isExplicit(entity)) {
                return false;
            }
            return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.SHARE_WATCH_FOLDER, user) && (((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"WatchFolder")).isOwner(user, entity) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.UPDATE_NOT_OWN_PROFILE, user));
        }
        if (WatchFolderImpl.eq_x0sjq6_a0c1a3(o, Operation.CREATE)) {
            return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.CREATE_WATCH_FOLDER, user);
        }
        if (WatchFolderImpl.eq_x0sjq6_a0d1a3(o, Operation.DELETE)) {
            if (!this.isExplicit(entity)) {
                return false;
            }
            return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.DELETE_WATCH_FOLDER, user) && (((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"WatchFolder")).isOwner(user, entity) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).hasPermission(Permission.UPDATE_NOT_OWN_PROFILE, user));
        }
        throw new IllegalArgumentException("Unsupported operation. Ordinal " + o.getOrdinal());
    }

    public boolean isVisibleFor(Entity user, Entity entity) {
        Entity userGroup;
        if (EntityOperations.equals((Entity)user, (Object)this.getOwner(entity))) {
            return true;
        }
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isService(user) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isSystem(user)) {
            return true;
        }
        Entity ss = AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting");
        if (ss != null && !EntityOperations.isRemoved((Entity)ss) && ((userGroup = AssociationSemantics.getToOne((Entity)ss, (String)"userGroup")) == null || Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)user, (String)"groups")).contains((Object)userGroup))) {
            return true;
        }
        return ((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"WatchFolder")).canUpdate(user, entity);
    }

    public boolean canUpdate(Entity user, Entity entity) {
        Entity uss = AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting");
        return uss != null && !EntityOperations.isRemoved((Entity)uss) && Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)user, (String)"groups")).contains((Object)AssociationSemantics.getToOne((Entity)uss, (String)"userGroup"));
    }

    public boolean isSingleUser(Entity entity) {
        Entity ss = AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting");
        return ss == null || EntityOperations.isRemoved((Entity)ss);
    }

    public Iterable<Entity> filterSharedVisible(Iterable<Entity> rules, final Entity entity) {
        final Entity sharingGroup = AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting"), (String)"userGroup");
        if (sharingGroup == null) {
            return rules;
        }
        return Sequence.fromIterable(rules).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)it, (String)"owner"), (String)"groups"), (Entity)sharingGroup) || QueryOperations.contains((Iterable)AssociationSemantics.getToMany((Entity)AssociationSemantics.getToOne((Entity)it, (String)"owner"), (String)"groups"), (Entity)AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting"), (String)"userGroup"));
            }
        });
    }

    public String getNotificationTitle(Entity user, Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public Entity getOwner(Entity entity) {
        if (EntityOperations.equals((Entity)entity, null)) {
            throw new NullPointerException("Entity is null. May be it was removed? Ask support!");
        }
        throw new UnsupportedOperationException("Abstract method called.");
    }

    public boolean isOwner(Entity user, Entity entity) {
        return EntityOperations.equals((Entity)this.getOwner(entity), (Object)user);
    }

    public boolean isOwner(Entity entity) {
        return this.isOwner(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), entity);
    }

    public Entity getWatchRule(Entity user, Entity entity) {
        return this.getWatchRule(user, true, entity);
    }

    public boolean isWatched(Entity byUser, RuleType ruleType, Entity entity) {
        Entity watchRule = this.getWatchRule(byUser, false, entity);
        return watchRule != null && ((WatchRuleImpl)DnqUtils.getPersistentClassInstance((Entity)watchRule, (String)"WatchRule")).is(ruleType, watchRule);
    }

    public boolean isNotUnpinned(Entity user, Entity entity) {
        Entity watchRule = this.getWatchRule(user, false, entity);
        return watchRule != null && ((WatchRuleImpl)DnqUtils.getPersistentClassInstance((Entity)watchRule, (String)"WatchRule")).is(RuleType.PINNED, watchRule);
    }

    public void setPinned(Entity user, Boolean value, Entity entity) {
        Entity watchRule = this.getWatchRule(user, value != null, entity);
        if (watchRule == null) {
            return;
        }
        ((WatchRuleImpl)DnqUtils.getPersistentClassInstance((Entity)watchRule, (String)"WatchRule")).set(RuleType.PINNED, value != null && value != false, watchRule);
        ((WatchRuleImpl)DnqUtils.getPersistentClassInstance((Entity)watchRule, (String)"WatchRule")).set(RuleType.UNPINNED, value != null && value == false, watchRule);
    }

    public void setWatched(Entity byUser, RuleType ruleType, Boolean value, Entity entity) {
        Entity watchRule = this.getWatchRule(byUser, true, entity);
        ((WatchRuleImpl)DnqUtils.getPersistentClassInstance((Entity)watchRule, (String)"WatchRule")).set(ruleType, value.booleanValue(), watchRule);
    }

    public Entity getWatchRule(Entity user, boolean createIfNotExist, Entity entity) {
        IssueRequestDataHolder dto;
        Entity watchRule = null;
        if (EntityOperations.isNew((Entity)entity)) {
            for (Entity rule : Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"watchRules"))) {
                if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)rule, (String)"owner"), (Object)user)) continue;
                return rule;
            }
        } else if (!EntityOperations.equals((Entity)user, (Object)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()) || (dto = IssueRequestDataHolder.get()) == null) {
            watchRule = QueryOperations.getFirst((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"watchRules"), (String)"WatchRule", (NodeBase)new LinkEqual("owner", user)));
        } else {
            if (!dto.watchRulesInited()) {
                dto.initWatchRules();
                for (Entity rule : QueryOperations.query(null, (String)"WatchRule", (NodeBase)new LinkEqual("owner", user))) {
                    dto.setWatchRuleByWatchFolder(rule);
                }
            }
            watchRule = dto.getWatchRuleByWatchFolder(entity);
        }
        if (createIfNotExist && watchRule == null && EntityOperations.isNew((Entity)(watchRule = WatchRuleImpl.getOrCreate((Entity)user, (Entity)entity))) && EntityOperations.equals((Entity)user, (Object)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()) && (dto = IssueRequestDataHolder.get()) != null && dto.watchRulesInited()) {
            dto.setWatchRuleByWatchFolder(watchRule);
        }
        return watchRule;
    }

    public Entity getShareGroup(Entity entity) {
        Entity group = null;
        if (AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting") != null && (group = AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting"), (String)"userGroup")) == null) {
            group = UserGroupImpl.getAllUsersGroup();
        }
        return group;
    }

    public void setShareGroup(final Entity userGroup, Entity entity) {
        if (userGroup == null) {
            if (AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting") != null) {
                EntityOperations.remove((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting"));
            }
        } else {
            if (AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting") == null) {
                AggregationAssociationSemantics.setOneToOne((Entity)entity, (String)"sharingSetting", (String)"watchFolder", (Entity)SharingSettingImpl.constructor());
            }
            if (!EntityOperations.equals((Entity)userGroup, (Object)UserGroupImpl.getAllUsersGroup())) {
                UndirectedAssociationSemantics.setManyToOne((Entity)userGroup, (String)"sharedFolderSettings", (String)"userGroup", (Entity)AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting"));
                if (!EntityOperations.equals((Entity)userGroup, (Object)AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting"), (String)"userGroup"))) {
                    final Entity wfOwner = this.getOwner(entity);
                    Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"watchRules")).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

                        public void visit(Entity watchRule) {
                            if (!EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)watchRule, (String)"owner"), (Object)wfOwner) && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)watchRule, (String)"owner"), (String)"User")).isInGroup(userGroup, AssociationSemantics.getToOne((Entity)watchRule, (String)"owner"))) {
                                EntityOperations.remove((Entity)watchRule);
                            }
                        }
                    });
                }
            } else {
                UndirectedAssociationSemantics.setManyToOne(null, (String)"sharedFolderSettings", (String)"userGroup", (Entity)AssociationSemantics.getToOne((Entity)entity, (String)"sharingSetting"));
            }
        }
    }

    public Entity getUpdateShareGroup(Entity entity) {
        Entity group = null;
        if (AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting") != null && (group = AssociationSemantics.getToOne((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting"), (String)"userGroup")) == null) {
            group = UserGroupImpl.getAllUsersGroup();
        }
        return group;
    }

    public void setUpdateShareGroup(Entity userGroup, Entity entity) {
        if (userGroup == null) {
            if (AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting") != null) {
                EntityOperations.remove((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting"));
            }
        } else {
            if (AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting") == null) {
                AggregationAssociationSemantics.setOneToOne((Entity)entity, (String)"updateShareSetting", (String)"watchFolder_update", (Entity)SharingSettingImpl.constructor());
            }
            if (!EntityOperations.equals((Entity)userGroup, (Object)UserGroupImpl.getAllUsersGroup())) {
                UndirectedAssociationSemantics.setManyToOne((Entity)userGroup, (String)"sharedFolderSettings", (String)"userGroup", (Entity)AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting"));
            } else {
                UndirectedAssociationSemantics.setManyToOne(null, (String)"sharedFolderSettings", (String)"userGroup", (Entity)AssociationSemantics.getToOne((Entity)entity, (String)"updateShareSetting"));
            }
        }
    }

    public void fixName(Entity entity) {
        if (!WatchFolderImpl.isValidName((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()))) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)WatchFolderImpl.toValidName((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()))), String.class);
        }
    }

    public Iterable<Entity> getQueryProjects(Entity entity) {
        IParseResult parseResult = ((Parser)ServiceLocator.getBean((String)"parser")).parse(null, IssueFolderUtil.getOrderedIssuesProvider(entity).getQuery(), new Context());
        ISetSequence projectFilters = SetSequence.fromSet(new LinkedHashSet());
        ((ParseResultUtil)ServiceLocator.getBean((String)"parseResultUtil")).collectSearchedValues(parseResult, (IField)ServiceLocator.getBean((String)"predefinedFieldProject"), (Set<IFieldValue>)projectFilters);
        return SetSequence.fromSet((Set)projectFilters).select((_FunctionTypes._return_P1_E0)new ISelector<IFieldValue, Entity>(){

            public Entity select(IFieldValue it) {
                return ((IProjectFieldValue)it).getProject();
            }
        });
    }

    public static Entity constructor(String name) {
        return ((WatchFolderImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name, __ENTITY_TYPE__);
    }

    protected static Iterable<Entity> getOrdered(Entity user, Iterable<Entity> own, Iterable<Entity> notOwn) {
        own = QueryOperations.query(own, (String)"WatchFolder", (NodeBase)new SortByProperty(null, "name", true));
        TreeKeepingEntityIterable shared = QueryOperations.query(WatchFolderImpl.whereSharedIsVisible(user, notOwn), (String)"WatchFolder", (NodeBase)new SortByProperty(null, "name", true));
        return QueryOperations.concat((Iterable)own, (Iterable)shared);
    }

    public static Iterable<Entity> whereSharedIsVisible(Entity user, Iterable<Entity> watchFolders) {
        if (((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isService(user) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).isSystem(user)) {
            return watchFolders;
        }
        Iterable sharedWithGroups = QueryOperations.selectManyDistinct(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getUserGroupsExcludingAllUsersGroup(user), (String)"sharedFolderSettings");
        TreeKeepingEntityIterable sharedToAll = QueryOperations.query(watchFolders, (String)"WatchFolder", (NodeBase)new And((NodeBase)new UnaryNot((NodeBase)new LinkEqual("sharingSetting", null)), (NodeBase)new LinksEqualDecorator("sharingSetting", (NodeBase)new LinkEqual("userGroup", null), "SharingSetting")));
        return QueryOperations.union((Iterable)sharedToAll, (Iterable)QueryOperations.intersect(watchFolders, (Iterable)QueryOperations.union((Iterable)QueryOperations.selectDistinct((Iterable)sharedWithGroups, (String)"watchFolder"), (Iterable)QueryOperations.selectDistinct((Iterable)sharedWithGroups, (String)"watchFolder_update"))));
    }

    public static Iterable<Entity> getUnsortedWithShared(Entity user) {
        return QueryOperations.union((Iterable)QueryOperations.union(SavedQueryImpl.getOwn(user), (Iterable)QueryOperations.query(null, (String)"IssueTag", (NodeBase)new LinkEqual("owner", user))), WatchFolderImpl.whereSharedIsVisible(user, (Iterable<Entity>)QueryOperations.queryGetAll((String)"WatchFolder")));
    }

    private static boolean isValidName(String name) {
        return name == null || name.length() == 0 || name.indexOf(60) < 0 && name.indexOf(62) < 0 && name.indexOf(38) < 0 && name.indexOf(44) < 0;
    }

    public static String toValidName(String name) {
        name = name.replace('<', '(');
        name = name.replace('>', ')');
        name = name.replace('&', '_');
        name = name.replace(',', '_');
        return name;
    }

    @Nullable
    public static Entity fromId(String type, String folderId) {
        int localId;
        if (folderId == null || folderId.length() == 0) {
            return null;
        }
        int typeId = ((PersistentEntityStoreImpl)((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore"))).getEntityTypeId(type, false);
        int dashIndex = folderId.lastIndexOf("-");
        if (typeId == -1 || dashIndex == -1) {
            return null;
        }
        String idStr = StringUtils.substring(folderId, dashIndex + 1);
        try {
            localId = Integer.parseInt(idStr);
        }
        catch (NumberFormatException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Failed to parse WatchFolder id: " + idStr));
            }
            return null;
        }
        PersistentEntityId id = new PersistentEntityId(typeId, (long)localId);
        try {
            Entity folder = DnqUtils.fromPersistentId((PersistentEntityId)id);
            String name = StringUtils.substring(folderId, 0, dashIndex);
            if (name != null && name.length() > 0 && name.equalsIgnoreCase((String)PrimitiveAssociationSemantics.get((Entity)folder, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()))) {
                if (((WatchFolderImpl)DnqUtils.getPersistentClassInstance((Entity)folder, (String)"WatchFolder")).isAccessible(Operation.READ, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), folder)) {
                    return folder;
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("WatchFolder id: " + idStr + " is not accessible"));
                }
                return null;
            }
            return null;
        }
        catch (EntityRemovedInDatabaseException exception) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("WatchFolder id: " + idStr + " was removed"));
            }
            return null;
        }
    }

    private static boolean eq_x0sjq6_a0b0d(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_x0sjq6_a0a1a3(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_x0sjq6_a0b1a3(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_x0sjq6_a0c1a3(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_x0sjq6_a0d1a3(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

