/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.smartui.workspace;

import jetbrains.charisma.misc.IssueListExportDataSource;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.smartui.filter.FilterData;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import jetbrains.mps.webr.runtime.templateComponent.ActionController;
import jetbrains.mps.webr.runtime.templateComponent.ActionFactory;
import jetbrains.mps.webr.runtime.templateComponent.SimpleActionController;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.reports.DataExporter;
import jetbrains.youtrack.api.reports.DataExporterFactory;
import jetbrains.youtrack.api.reports.ExportDataSource;
import webr.framework.controller.CentralManager;
import webr.framework.runtime.response.ResponseAction;

public class Export_Controller
extends ActionFactory {
    public Export_Controller() {
        super("export");
    }

    public ActionController createAction(String actionName, String windowId) {
        if ("exportQuery".equalsIgnoreCase(actionName)) {
            return new ExportQueryAction(windowId, this);
        }
        return null;
    }

    public static class ExportQueryAction
    extends SimpleActionController {
        public ExportQueryAction(String windowId, ActionFactory actionFactory) {
            super("exportQuery", windowId, actionFactory);
        }

        protected String[] getActionParameterNames() {
            return new String[]{"folderId", "query", "mime"};
        }

        protected ResponseAction processSimpleAction() {
            Entity folder = IssueFolderUtil.findById((String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("folderId"), String.class.getName()));
            FilterData filterData = FilterData.create((String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("query"), String.class.getName()), folder, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), -1);
            Iterable<Entity> issues = filterData.getIssues(true, true);
            try {
                DataExporter exporter = ((DataExporterFactory)ServiceLocator.getBean((String)"dataExporterFactory")).forMime((String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("mime"), String.class.getName()));
                if ((String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("mime"), String.class.getName()) == null) {
                    throw new IllegalArgumentException("No exporter exists for mime type " + (String)((TypeConvertManager)ServiceLocator.getBean((String)"typeConvertManager")).fromString((String)this.getActionParameters().get("mime"), String.class.getName()));
                }
                return exporter.export((ExportDataSource)new IssueListExportDataSource(issues));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean requiresBasicAuth() {
            return !((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).isPresent() || ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).isGuest();
        }

        protected String getBasicAuthRealm() {
            return ((CentralManager)ServiceLocator.getBean((String)"centralManager")).getApplicationName();
        }
    }
}

