/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.wiki;

import java.util.ArrayList;
import java.util.List;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.wiki.CharismaHtmlTextWikiProcessorMarkup;
import jetbrains.charisma.wiki.CharismaHtmlTextWikiProcessorRemoveMarkup;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.WikiBlockHelp;
import jetbrains.mps.webr.wiki.processor.runtime.WikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.WikiUtil;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.security.Permissions;

public class CharismaHtmlTextWikiProcessor
implements WikiProcessor {
    private static List<WikiBlockHelp> HELP;
    private static boolean HELP_READY;
    private static CharismaHtmlTextWikiProcessor INSTANCE;

    private CharismaHtmlTextWikiProcessor() {
    }

    public String clean(String arg) {
        if (arg == null) {
            return null;
        }
        int s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            s += arg.charAt(i) == '\r' ? 0 : 1;
        }
        char[] ar = new char[s];
        s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == '\r') continue;
            ar[s++] = arg.charAt(i);
        }
        return new String(ar);
    }

    public IWikiProcessor createProcessor(String s) {
        CharismaHtmlTextWikiProcessorMarkup result = CharismaHtmlTextWikiProcessorMarkup.create(this.clean(s));
        return result;
    }

    public IWikiProcessor createRemoveMarkupProcessor(String s) {
        CharismaHtmlTextWikiProcessorRemoveMarkup result = CharismaHtmlTextWikiProcessorRemoveMarkup.create(this.clean(s));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WikiBlockHelp> getHelp() {
        if (!HELP_READY) {
            CharismaHtmlTextWikiProcessor charismaHtmlTextWikiProcessor = this;
            synchronized (charismaHtmlTextWikiProcessor) {
                if (!HELP_READY) {
                    HELP = ListSequence.fromList(new ArrayList());
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("HtmlText.Subset_of_HTML", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return CharismaHtmlTextWikiProcessor.concat(new String[]{WikiUtil.getSampleHtml()});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLink.Link_to_issue_", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return CharismaHtmlTextWikiProcessor.concat(new String[]{((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)QueryOperations.getFirst((Iterable)((Permissions)ServiceLocator.getBean((String)"permissions")).apply(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Iterable)QueryOperations.queryGetAll((String)"Issue"))), (String)"Issue")).getId(QueryOperations.getFirst((Iterable)((Permissions)ServiceLocator.getBean((String)"permissions")).apply(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (Iterable)QueryOperations.queryGetAll((String)"Issue"))))});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLink.Link_to_issue_attachment", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return CharismaHtmlTextWikiProcessor.concat(new String[]{"[file:attachment.png]"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLink.Draw_picture", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return CharismaHtmlTextWikiProcessor.concat(new String[]{"!" + ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getLogoUrl((Entity)ServiceLocator.getBean((String)"applicationMetaData")).substring(((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getLogoUrl((Entity)ServiceLocator.getBean((String)"applicationMetaData")).lastIndexOf(47) + 1) + "!"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("IssueLink.User_login", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return CharismaHtmlTextWikiProcessor.concat(new String[]{"@root"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("QueryLink.Link_to_query", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return CharismaHtmlTextWikiProcessor.concat(new String[]{"[query:for: me #unresolved]"});
                        }
                    }, true));
                    HELP_READY = true;
                }
            }
        }
        return HELP;
    }

    public static CharismaHtmlTextWikiProcessor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CharismaHtmlTextWikiProcessor();
        }
        return INSTANCE;
    }

    private static String concat(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

