/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.workflow.exceptions;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.customfields.CustomFieldPrototypeImpl;
import jetbrains.charisma.smartui.keyword.CategorizedFieldService;
import jetbrains.charisma.workflow.exceptions.WorkflowException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.parser.FieldAlias;
import jetbrains.youtrack.api.parser.IField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FieldRequiredException
extends WorkflowException {
    protected static Log log = LogFactory.getLog(FieldRequiredException.class);
    private final String fieldName;

    public FieldRequiredException(Entity issue, String ruleFqName, String fieldName) {
        super(issue, ruleFqName, new LocalizationObject("FieldRequiredException.{0}_is_required", new Object[]{fieldName}));
        this.fieldName = fieldName;
    }

    public FieldRequiredException(Entity issue, String ruleFqName, String fieldName, String message) {
        super(issue, ruleFqName, new LocalizationObject("FieldRequiredException.{0}_is_required_details_{1}", new Object[]{fieldName, message}));
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getExtendedFieldName() {
        Entity requiredField = CustomFieldPrototypeImpl.findPrototype(this.getFieldName());
        if (!EntityOperations.equals((Entity)requiredField, null)) {
            IField field = ((CategorizedFieldService)ServiceLocator.getBean((String)"categorizedFieldService")).findCategorizedField(requiredField);
            if (field != null) {
                FieldAlias fieldAlias = (FieldAlias)Sequence.fromIterable((Iterable)field.getAliases()).where((_FunctionTypes._return_P1_E0)new IWhereFilter<FieldAlias>(){

                    public boolean accept(FieldAlias it) {
                        return it.isCommand();
                    }
                }).first();
                return fieldAlias.getAlias();
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("There is no field with name " + this.getFieldName()));
            }
            return null;
        }
        if (FieldRequiredException.isNotEmpty_txd8t7_a0a2a1(this.getFieldName())) {
            return this.getFieldName();
        }
        return null;
    }

    public static boolean isNotEmpty_txd8t7_a0a2a1(String str) {
        return str != null && str.length() > 0;
    }
}

