var Ajax = {};
Ajax = function () {
};
Ajax.onFieldRequired = null;
Ajax.LOADING_TIMEOUT = 500;
Ajax.LOADING_MESSAGE = l10n('${l10n("Ajax.js.Loading")}');
Ajax.onError = function (jqXHR, textStatus, errorThrown) {
  var message = errorThrown;
  if (jqXHR.status == 412) {
    //show command window on "required field exception"
    var field;
    var originalCommand;
    if (jqXHR.responseXML) {
      var r = $(jqXHR.responseXML);
      message = r.find("message").text();
      field = r.find("field").text();
      originalCommand = r.find("originalCommand").text();
    } else {
      //try json
      try {
        var r = jQuery.parseJSON(jqXHR.responseText);
        message = r["message"];
        field = r["field"];
        originalCommand = r["originalCommand"];
      } catch (e) {
        //ignore
      }

    }

        

    if (field != null && field.length > 0) {
      if (Ajax.onFieldRequired) {
        Ajax.onFieldRequired(field, originalCommand);
      }

    }

  } else if (jqXHR.status == 418) {
    //418 it returned by backend only in case of readonly mode. statusText exists
    message = jqXHR.statusText;
  } else {
    if (jqXHR.responseXML) {
      message = $(jqXHR.responseXML).text();
    } else {
      //try json
      try {
        message = jQuery.parseJSON(jqXHR.responseText)["value"];
      } catch (e) {
        //ignore
      }

    }

  }

    

  Webr.ErrorMessage.addMessage(message, 10000);
};
Ajax.loadingInit = function (jqXHR, settings) {
  jqXHR.loadingPopupHandle = window.setTimeout(function () {
    Webr.event.PopupMessage.SYSTEM.show(Ajax.LOADING_MESSAGE);
    jqXHR.msgObject = Webr.event.PopupMessage.SYSTEM.message;
  }, Ajax.LOADING_TIMEOUT);
};
Ajax.loadingDispose = function (jqXHR, textStatus) {
  var handle = jqXHR.loadingPopupHandle;
  window.clearTimeout(handle);
  //hide only message what was shown by us
  if (Webr.event.PopupMessage.SYSTEM.message == jqXHR.msgObject) {
    Webr.event.PopupMessage.SYSTEM.hide();
  }

};
Ajax.ajaxSettings = function () {
  return {error: Ajax.onError, beforeSend: function (jqXDR, settings) {
    Ajax.loadingInit(jqXDR, settings);
  }, complete: Ajax.loadingDispose};
};


