var ringController;
charisma.RingCommonController = function (menuConfig, callback) {
  this.config = menuConfig;
  this.callback = callback;
  this.init();
  ringController = this;
  this.userInternalRest = new Webr.rest.Client(Webr.Event.rootUrl, Ajax.ajaxSettings()).resource({p: ["userInternal"]});
};
charisma.RingCommonController.prototype.setPart = function (part) {
  this.part = part;
};
charisma.RingCommonController.prototype.init = function () {
  this.callback();
  this.onLoad();
};
charisma.RingCommonController.prototype.onLoad = function () {
  $(document).ready(function () {
    this.initShortcutDialog();
    this.initCreateButton();
    this.initKeyHandlers();
  }.bind(this));
};
charisma.RingCommonController.prototype.initKeyHandlers = function () {
  var self = this;
  $(document).keydown(function (e) {
    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["MyWatchFolder"])) {
      $(".yt-header__issues-toggler").click();
      return false;
    }

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["QuickHelp"])) {
      self.showShortcutsDialog();
      return false;
    }

  });
};
charisma.RingCommonController.prototype.initShortcutDialog = function () {
  $(document).on(charisma.RingCommonController.CLICK_RING, ".yt-header__help-shortcuts", jQuery.proxy(this.showShortcutsDialog, this));
};
charisma.RingCommonController.prototype.showShortcutsDialog = function () {
  if (this.config.methods.showShorcuts) {
    this.config.methods.showShorcuts();
  }

};
charisma.RingCommonController.prototype.initCreateButton = function () {
  $(document).on(charisma.RingCommonController.CLICK_RING, ".yt-header__create-btn", function (e) {
    e.preventDefault();
  });
};
charisma.RingCommonController.prototype.initNewUiButton = function () {
  var it = this;
  $(".yt-header__new-ui").bind(charisma.RingCommonController.CLICK_RING, function (e) {
    //no need for success handler, ring menu will reload the page when the call returns
    it.userInternalRest.method("put", {p: ["userInternal", "profile", null]}).call({p: ["userInternal", "profile", it.part], x: {dataType: "json", async: false}});
  });
};
charisma.RingCommonController.prototype.callback = function () {
};
charisma.RingCommonController.prototype.login = function () {
  var servId = this.config.serviceId;
  try {
    localStorage.removeItem(servId + '-token');
  } catch (e) {
  }

};
charisma.RingCommonController.CLICK_RING = "click.ring";
charisma.RingCommonController.CONTAINER = ".container";
charisma.RingCommonController.initFooter = function (footerConfig, propAtLeft) {
  if (window.reactRender && window.React && window.Footer) {
    var container = $(".footer-placeholder");
        

    container.addClass(propAtLeft === true ?"footer-placeholder_left" :"footer-placeholder_right");
        

    var afterRender = function () {
      var spentTimeHolder = $(".ring-footer-spent");
      if (spentTimeHolder[0]) {
        $(".yt-mps-footer div:last li:first").append(spentTimeHolder.html());
        spentTimeHolder.remove();
      }

    };
        

    try {
      var footerElement = window.React.createElement(window.Footer, footerConfig);
      window.reactRender(footerElement, container[0], afterRender);
    } catch (err) {
      window['console'].log('Footer is unavailable.');
    }

        

  } else {
    window['console'].log('React not found! Footer is unavailable.');
  }

};
