charisma.smartui.CommentItem = function (list, element) {
  this.commentsList = list;
  var query = $(element);
  this.element = query.get(0);
  var self = this;
  this.initAttachmentsBlock();
  query.click(function (e) {
    if (!Webr.util.Util.targetIsInput(e) && !$(e.target).hasClass("comment-reply")) {
      self.commentsList.mousedown(self);
    }

    return true;
  });
};
charisma.smartui.CommentItem.prototype.collect = function () {
  time("collect comment elements");
  var query = $(this.element);
  var expanded = query.attr("exp");
  this.attachmentsExpanded = expanded ?true :false;
  this.permaLink = query.find("a." + "permalink");
  this.editComment = query.find("a." + "commentEdit").get(0);
  this.deleteComment = query.find("a." + "commentDelete").get(0);
  timeEnd("collect comment elements");
};
charisma.smartui.CommentItem.prototype.initAttachmentsBlock = function () {
  var self = this;
  this.attachmentsExpanded = false;
  this.attachmentToggler = $(this.element).find("span." + "comment-change-title");
};
charisma.smartui.CommentItem.prototype.edit = function () {
  if (this.editComment) {
    $(this.editComment).click();
  }

};
charisma.smartui.CommentItem.prototype.del = function () {
  if (this.deleteComment) {
    $(this.deleteComment).click();
  }

};
charisma.smartui.CommentItem.prototype.refresh = function (editMode) {
  this.collect();
  this.select();
  $(this.element)[editMode ?"removeClass" :"addClass"]("comment-selected");
};
charisma.smartui.CommentItem.prototype.select = function (noFocus, noScroll) {
  this.addClass(this.commentsList.selectedItemClass);
  if (!noFocus) {
    this.permaLink.focus();
  }

  if (!noScroll) {
    $(this.element).scrollTo(this.commentsList.scrollable ?this.commentsList.mainDivElement :undefined, this.commentsList.getToolbarIndents());
  }

};
charisma.smartui.CommentItem.prototype.unselect = function () {
  this.removeClass(this.commentsList.selectedItemClass);
};
charisma.smartui.CommentItem.prototype.addClass = function (cls) {
  $(this.element).addClass(cls);
};
charisma.smartui.CommentItem.prototype.removeClass = function (cls) {
  $(this.element).removeClass(cls);
};
charisma.smartui.CommentItem.prototype.toggleAttachments = function () {
  if (this.attachmentToggler.get(0)) {
    this.attachmentToggler.click();
  }

};
charisma.smartui.CommentItem.prototype.toggleState = function () {
  this.attachmentsExpanded = !this.attachmentsExpanded;
};
