var CommandToolbarGuard = {};
CommandToolbarGuard = function (menu) {
  this.visible = true;
  var self = this;
  this.menu = menu;
  this.componentName = menu.button.attr("id").substring(3);
  info("MenuGuard[" + this.componentName + "] created");
  this.refreshListener = {beforeRefresh: function (templatePath) {
    self.onTemplateRefresh(templatePath);
  }};
  this.keyProxy = function (e) {
    if (self.visible && self.menu.isEnabled()) {
      return self.keyHandler(e);
    }

    return true;
  };
  Webr.event.RefreshCommandProcessor.addListener(this.refreshListener);
};
CommandToolbarGuard.prototype.onTemplateRefresh = function (path) {
  if (this.componentName.indexOf(path) == 0) {
    this.finalize();
  }

};
CommandToolbarGuard.prototype.setKeyHandler = function (handler) {
  info("MenuGuard[" + this.componentName + "] keyHandler updated");
  var self = this;
  if (this.keyHandler) {
    $(document).unbind("keydown", this.keyProxy);
  }

  this.keyHandler = handler;
  if (handler) {
    $(document).keydown(this.keyProxy);
  }

};
CommandToolbarGuard.prototype.setChangeListener = function (listener, timeout) {
  info("MenuGuard[" + this.componentName + "] issue listener updated");
  //remove old listener
  if (this.changeListener) {
    commonController.removeChangeListener(this.changeListener);
    delete this.changeListener;
    this.changeListener = null;
  }

  //add new listener
  if (listener) {
    if (timeout) {
      var it = this;
      window.setTimeout(function () {
        it.setChangeListener(listener, false);
      }, 10);
    } else {
      this.changeListener = listener;
      commonController.addChangeListener(this.changeListener);
      listener.checkedItemsUpdated();
    }

  }

};
CommandToolbarGuard.prototype.setVisible = function (visible) {
  info("MenuGuard[" + this.componentName + "] " + (visible ?"visible" :"hidden"));
  this.visible = visible;
};
CommandToolbarGuard.prototype.finalize = function () {
  this.setKeyHandler(null);
  this.setChangeListener(null, false);
  info("MenuGuard[" + this.componentName + "] destroyed");
  this.componentName = null;
  this.keyProxy = null;
  Webr.event.RefreshCommandProcessor.removeListener(this.refreshListener);
  this.refreshListener = null;
  this.menu["guard"] = null;
};
CommandToolbarGuard.registerHandlers = function (menu, keyDownHandler, changeListener) {
  var guard = CommandToolbarGuard.get(Webr.component.Menu.getMenu(menu, true));
  guard.setKeyHandler(keyDownHandler);
  guard.setChangeListener(changeListener, true);
};
CommandToolbarGuard.get = function (menu) {
  if (!menu["guard"]) {
    menu["guard"] = new CommandToolbarGuard(menu);
  }

  return menu["guard"];
};
