charisma.smartui.CommonController = function () {
  charisma.smartui.CommonController.superclass.constructor.call(this);
  this.changeListeners = new Webr.util.Set();
  this.editMode = false;
  var it = this;
  $(document).keydown(function (e) {
    if (Webr.component.panel.Dialog.isModalVisible() || charisma.smartui.ViewImageAttachment.isVisible()) {
      return true;
    }

        

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["NewIssue"])) {
      if (!it.newIssueHandler()) {
        return false;
      }

    }

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["NewSubtask"])) {
      if (!it.newSubtask()) {
        return false;
      }

    }

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["ExpandCollapseExceptions_IDEA"]) || Webr.util.Key.isApplicable(e, SmartUIShortCuts["ExpandCollapseExceptions"])) {
      it.togglerExceptionsView();
      return false;
    }

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["AddComment"])) {
      it.onAddComment();
      return false;
    }

  });
  this.reduceIeShadow();
  this.setNewInlineIssue();
  charisma.UsernameSuggest.attach();
  new charisma.smartui.DragInsertWikifiedImageFileName();
};
{
  var F = new Function();
  F.prototype = Webr.component.ComponentListener.prototype;
  charisma.smartui.CommonController.prototype = new F();
  charisma.smartui.CommonController.prototype.constructor = charisma.smartui.CommonController;
  charisma.smartui.CommonController.superclass = Webr.component.ComponentListener.prototype;
}

charisma.smartui.CommonController.prototype.allFoundIssuesAreSelected = function () {
  return false;
};
charisma.smartui.CommonController.prototype.newIssueHandler = function () {
  this.newInlineIssue.mouseup();
  return false;
};
charisma.smartui.CommonController.prototype.onAddComment = function () {
  if (this.commandDialog) {
    this.commandDialog.show(this.commentCommand, true);
    return false;
  }

};
charisma.smartui.CommonController.prototype.getQuery = function () {
  return this.searchField.value;
};
charisma.smartui.CommonController.prototype.setSearchQuery = function (query) {
  this.searchField.focus();
  this.searchField.value = query;
};
charisma.smartui.CommonController.prototype.getSelectedIssuesIds = function () {
  return [];
};
charisma.smartui.CommonController.prototype.getSelectedIssuesCount = function () {
  return 1;
};
charisma.smartui.CommonController.prototype.getFocusedIssueId = function () {
  return null;
};
charisma.smartui.CommonController.prototype.getFocusedPresentationIssueId = function () {
  return null;
};
charisma.smartui.CommonController.prototype.setSearchUrl = function (url) {
  this.searchUrl = url;
};
charisma.smartui.CommonController.prototype.setCommandDialog = function (commandsDialog) {
  this.setComponent("commandDialog", commandsDialog);
};
charisma.smartui.CommonController.prototype.doSearchRequest = function () {
  var loc = this.searchUrl;
  if (this.getQuery() && this.getQuery().length > 0) {
    var encoded = encodeURIComponent(this.getQuery());
    encoded = encoded.replaceAll("%20", "+");
    encoded = encoded.replaceAll("{", "%7B");
    encoded = encoded.replaceAll("}", "%7D");
    loc += "?q=" + encoded;
  }

  Webr.Event.redirect(loc);
};
charisma.smartui.CommonController.prototype.setSearchField = function (searchField, forceComplete) {
  this.searchField = searchField;
  var suggest = searchField.getSuggest();
  this.setComponent("searchSuggest", suggest);
  this.forceComplete = forceComplete;
  this.hideAutocompleteOnMobileScrollOrTap(suggest);
};
charisma.smartui.CommonController.prototype.hideAutocompleteOnMobileScrollOrTap = function (suggest) {
  if (Webr.util.Util.isMobile) {
    $(document).on("touchstart tap", function (e) {
      $("#spContainer").removeClass("showRecentSearch");
      if (!$(suggest.suggestDiv).ancestorOf(e.target)) {
        suggest.blur();
      }

    });
  }

};
charisma.smartui.CommonController.prototype.setRecentSearches = function (recentSearchesList) {
  this.recentSearchesList = recentSearchesList;
};
charisma.smartui.CommonController.prototype.setNewIssueId = function (id) {
  charisma.smartui.TextCopier.hideCopier(true);
  if (!id || id == "") {
    this.newIssueId = null;
  } else {
    this.newIssueId = id;
  }

  this.fireNewIssueIsShown(this.newIssueId);
    

  charisma.smartui.NewIssueSwitcher.instance.change(id);
};
charisma.smartui.CommonController.prototype.newSubtask = function () {
  return true;
};
charisma.smartui.CommonController.prototype.setNewSubtaskHandler = function (handler) {
  this.newSubtask = function () {
    if (!charisma.smartui.NewIssueSwitcher.instance.isVisible()) {
      handler();
    }

    return false;
  };
};
charisma.smartui.CommonController.prototype.setNewInlineIssue = function () {
  var waitForCreateButton = window.setInterval(function () {
    this.newInlineIssue = $(".yt-header__create-btn");
    if (this.newInlineIssue[0]) {
      window.clearInterval(waitForCreateButton);
      charisma.smartui.NewIssueSwitcher.init(this.newInlineIssue);
    }

  }.bind(this), 500);
};
charisma.smartui.CommonController.prototype.fireNewIssueIsShown = function (id) {
  this.changeListeners.forEach(function (l) {
    l.newIssueIsShown(id);
    return true;
  });
  if (!id) {
    $(window).trigger("resize");
  }

};
charisma.smartui.CommonController.prototype.focusSearchField = function () {
  if (this.searchField) {
    this.searchField.focus();
  }

};
charisma.smartui.CommonController.prototype.getSearchField = function () {
  return this.searchField;
};
charisma.smartui.CommonController.prototype.setComponent = function (name, component) {
  if (this[name]) {
    this[name].removeListener(this);
  }

  this[name] = component;
  component.addListener(this);
};
charisma.smartui.CommonController.prototype.setExceptionStateToggler = function (exceptionToggler) {
  this.exceptionStateToggler = exceptionToggler;
};
charisma.smartui.CommonController.prototype.togglerExceptionsView = function () {
};
charisma.smartui.CommonController.prototype.focusIssue = function () {
  return false;
};
charisma.smartui.CommonController.prototype.selectIssue = function (issueId) {
};
charisma.smartui.CommonController.prototype.toggleEditMode = function (edit) {
  if (edit) {
    $(".sb-edit-ico").parent().addClass("sb-btn-pressed");
  } else {
    $(".sb-edit-ico").parent().removeClass("sb-btn-pressed");
  }

};
charisma.smartui.CommonController.prototype.finishIssueEdit = function () {
};
charisma.smartui.CommonController.prototype.addChangeListener = function (listener) {
};
charisma.smartui.CommonController.prototype.removeChangeListener = function (listener) {
};
charisma.smartui.CommonController.prototype.commentsLoaded = function (commentsList) {
};
charisma.smartui.CommonController.prototype.commentsRefreshed = function () {
};
charisma.smartui.CommonController.prototype.issueRedrawn = function (issueId, focus) {
};
charisma.smartui.CommonController.prototype.commandsHide = function (source) {
};
charisma.smartui.CommonController.prototype.keyPressed = function (source, e) {
  switch (source) {
  case this.searchSuggest:
    return this.searchSuggestKeyEvent(e);
  }

  return true;
};
charisma.smartui.CommonController.prototype.keyDown = function (source, e) {
  switch (source) {
  case this.searchSuggest:
    return this.searchSuggestKeyEvent(e);
  }

  return true;
};
charisma.smartui.CommonController.prototype.searchSuggestKeyEvent = function (e) {
  if (e.isKey(Webr.util.Key.TAB)) {
    return false;
  }

  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["SubmitSearchField"])) {
    this.doSearchRequest();
    return false;
  }

  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["ForceComplete"])) {
    this.forceComplete();
    return false;
  }

    

  return true;
};
charisma.smartui.CommonController.prototype.getToolbar = function () {
  return null;
};
charisma.smartui.CommonController.prototype.getCommentList = function () {
  return null;
};
charisma.smartui.CommonController.prototype.initDragUpload = function (handler, windowId, selector) {
  var _selector = selector || ".newIssueContainer .issueContainer__fsi:visible,  .edit-content__block:visible, .issueContainer";
  new charisma.smartui.AttachFileRest(_selector, handler, windowId);
};
charisma.smartui.CommonController.prototype.reduceIeShadow = function () {
  Webr.component.Shadow.getShadow = function (context, cssClass) {
    var shadow = Webr.component.Shadow.EMPTY_SHADOW;
    if (Webr.util.Util.isIE && Webr.util.Util.browserVersion < 9) {
      shadow = new charisma.smartui.IEShadowController(context, cssClass);
    }

    return shadow;
  };
};
charisma.smartui.CommonController.prototype.underlineSearchQuery = function (searchField) {
  var counter = 0;
  var timer;
  timer = window.setInterval(function () {
    if ($(".ring-header")[0] || counter > 45) {
      window.clearInterval(timer);
      charisma.RestMethods.$(searchField).underline(3);
    } else {
      ++counter;
    }

  }, 200);
};


var commonController;
charisma.smartui.IssueChangeListener = function () {
};
charisma.smartui.IssueChangeListener.prototype.checkedItemsUpdated = function () {
};
charisma.smartui.IssueChangeListener.prototype.newIssueIsShown = function (shown) {
};






//This is diagnostic override for JT-37985
//TODO: remove this instrumentation when issue is fixed


charisma.smartui.requestLogger = function () {
};
charisma.smartui.requestLogger.SWITCH_ON_TRACE_KEY = 'youtrack.feature.xmlhttprequestlog';
charisma.smartui.requestLogger.LOGGING_ENABLED = false;
charisma.smartui.requestLogger.init = function () {
  var localStorage = window.localStorage;
  if (!localStorage || !localStorage.getItem) {
    charisma.smartui.requestLogger.LOGGING_ENABLED = false;
  } else {
    charisma.smartui.requestLogger.LOGGING_ENABLED = localStorage.getItem(charisma.smartui.requestLogger.SWITCH_ON_TRACE_KEY) === 'true';
  }

};
charisma.smartui.requestLogger.isEnabled = function () {
  return charisma.smartui.requestLogger.LOGGING_ENABLED;
};
charisma.smartui.requestLogger.getDateTime = function () {
  var date = new Date();
  return [date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()].join(":");
};
charisma.smartui.requestLogger.trace = function (message, data) {
  if (!charisma.smartui.requestLogger.isEnabled()) {
    return ;
  }

    

  var consoleLog = console.log;
  var getDateTime = function () {
    var date = new Date();
    return [date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()].join(":");
  };
    

  var messageWithDateTime = getDateTime() + ': ' + (message || '') + ' ';
    

  if (data) {
    window['console']['log'](messageWithDateTime, data);
  } else {
    window['console']['log'](messageWithDateTime);
  }

};


charisma.smartui.requestLogger.init();


//************************************
var __responseServerEventListenerPrototype = Webr.event.ResponseServerEventListener['prototype'];
var responseServerEventListenerOnFinish = __responseServerEventListenerPrototype['onFinish'];
//************************************
var responseServerEventListenerInstrumentedOnFinish = function (event, success, exception) {
  var _this = this;
  if (!success) {
    if (exception != null) {
      var isTimeout = exception.isTimeout();
      var isCommunicationProblem = exception.isCommunication();
      var traceData;
      if (isTimeout) {
        traceData = {exceptionStatus: exception.status, exceptionText: exception.statusText};
      }

      if (isCommunicationProblem) {
        traceData = {communicationFailureStatus: exception.status, communicationFailureText: exception.statusText};
      }

      charisma.smartui.requestLogger.trace('ResponseServerEventListener(onFinish) ', traceData);
            

      if (isTimeout || isCommunicationProblem) {
        Webr.event.ResponseServerEventListener.disconnected();
        charisma.smartui.requestLogger.trace('go Disconnected');
      } else {
        Webr.event.ResponseServerEventListener.error(exception.statusText);
      }

    }

    if (_this.syncCall) {
      Webr.event.ResponseServerEventListener.SYNC_CALL_IN_PROGRESS = false;
    }

  }

};


__responseServerEventListenerPrototype['onFinish'] = function (event, success, exception) {
  var _this = this;
    

  if (charisma.smartui.requestLogger.isEnabled()) {
    responseServerEventListenerInstrumentedOnFinish.call(_this, event, success, exception);
  } else {
    responseServerEventListenerOnFinish.call(_this, event, success, exception);
  }

};


var instrumentResponseServerEventListenerReloadStaticMethods = function () {
  Webr.event.ResponseServerEventListener.reloadDelayed = function (seconds) {
    if (!Webr.event.ResponseServerEventListener.RELOAD_INTERVAL) {
      Webr.event.ResponseServerEventListener.TIME_TO_RELOAD = seconds;
            

      charisma.smartui.requestLogger.trace('ResponseServerEventListener(reloadDelayed) after [processRequest] method with interval', seconds);
            

      Webr.event.ResponseServerEventListener.RELOAD_INTERVAL = window.setInterval(Webr.event.ResponseServerEventListener.waitReloadTick, 1000);
    }

  };
    

  Webr.event.ResponseServerEventListener.waitReloadTick = function () {
    if (Webr.event.ResponseServerEventListener.TIME_TO_RELOAD > 0) {
      charisma.smartui.requestLogger.trace('ResponseServerEventListener(waitReloadTick)', Webr.event.ResponseServerEventListener.TIME_TO_RELOAD);
            

      Webr.event.ResponseServerEventListener.disconnectedMessage(l10n('${l10n("CommonController.js.Connection_Restored_{0}_{1}")}', '<a href="javascript:reload();">' + l10n('${l10n("CommonController.js.Reload")}') + '</a>', Webr.event.ResponseServerEventListener.TIME_TO_RELOAD));
      --Webr.event.ResponseServerEventListener.TIME_TO_RELOAD;
    } else {
      Webr.event.ResponseServerEventListener.abortReload();
      Webr.Event.reloadInternal(function () {
        //On success - just reload
        Webr.Event.reload();
      }, function (jqXHR, textStatus, errorThrown) {
                

        charisma.smartui.requestLogger.trace('ResponseServerEventListener(waitReloadTick) fail to relad branch', errorThrown);
                

        Webr.event.ResponseServerEventListener.internalReloadError(textStatus, errorThrown);
      });
    }

  };
    

  Webr.event.ResponseServerEventListener.callInternalReload = function () {
    charisma.smartui.requestLogger.trace('ResponseServerEventListener(callInternalReload)');
        

    Webr.event.ResponseServerEventListener.abortReload();
    Webr.event.ResponseServerEventListener.disconnectedMessage(l10n('${l10n("CommonController.js.Reloading")}'));
        

    Webr.Event.reloadInternal(function (data) {
      charisma.smartui.requestLogger.trace('ResponseServerEventListener(callInternalReload): success, replacing');
            

      var headEnd = "</head>";
      var start = data.indexOf("<head");
      var head = data.substring(start, data.indexOf(headEnd, start) + headEnd.length);
      var bodyEnd = "</body>";
      start = data.indexOf("<body");
      var body = data.substring(start, data.indexOf(bodyEnd, start) + bodyEnd.length);
      //process scripts from head and css links
      trace("Stop all active timers and intervals!");
      Webr.TimerUtil.clearAll();
      trace("Replacing head...");
      Webr.event.ResponseServerEventListener.processHead(head, function () {
        //replace body
        trace("Replacing body...");
        time("Set body");
        Webr.event.RefreshCommandProcessor.setContentToElement(document.body, body);
        timeEnd("Set body");
        Webr.event.ResponseServerEventListener.abortReload();
      });
    }, function (jqXHR, textStatus, errorThrown) {
      charisma.smartui.requestLogger.trace('ResponseServerEventListener(callInternalReload): fail', errorThrown);
            

      Webr.event.ResponseServerEventListener.abortReload();
      Webr.event.ResponseServerEventListener.internalReloadError(textStatus, errorThrown);
    });
  };
};


if (charisma.smartui.requestLogger.isEnabled()) {
  instrumentResponseServerEventListenerReloadStaticMethods();
}





//************************************
var __serverEventPrototype = Webr.event.ServerEvent['prototype'];
var serverEventHandleResponse = __serverEventPrototype['handleResponse'];
//************************************
var serverEventInstrumentedHandleResponse = function (aborted, timeout) {
  var _this = this;
    

  var target = 'ServerEvent(handleResponse) ';
  if (!aborted) {
    //not aborted
    var httpStatus;
    var status = _this.xmlHttpRequest.status;
    try {
      if (status !== undefined && status != 0) {
        httpStatus = status;
      } else {
        httpStatus = Webr.event.ServerEvent.STATE_ERROR;
      }

    } catch (e) {
      httpStatus = Webr.event.ServerEvent.STATE_ERROR;
    }

        

    if (httpStatus >= 200 && httpStatus < 300) {
      var responseObject = new Webr.event.ResponseObject(_this.xmlHttpRequest);
      _this.fireSuccess(responseObject);
    } else {
      var exceptionCodes = Webr.event.ServerEvent.EXCEPTION_CODES;
      var isException = false;
      for (var i = 0; i < exceptionCodes.length; ++i) {
        if (httpStatus == exceptionCodes[i]) {
          isException = true;
          charisma.smartui.requestLogger.trace(target + 'status code is out of 200-300: ', exceptionCodes[i]);
                    break;

        }

      }

            

      var obj;
      if (isException) {
        obj = new Webr.event.ExceptionObject(aborted, timeout);
        _this.fireException(obj);
      } else {
        obj = new Webr.event.ResponseObject(this.xmlHttpRequest);
        _this.fireFailure(obj);
      }

            

      charisma.smartui.requestLogger.trace(target + 'not aborted with exception ', obj);
    }

  } else {
    //aborted
    var exceptionObject = new Webr.event.ExceptionObject(aborted, timeout);
    charisma.smartui.requestLogger.trace(target + 'aborted with exception ', exceptionObject);
    _this.fireException(exceptionObject);
  }

    

  _this.releaseXmlHttpRequest();
};


__serverEventPrototype['handleResponse'] = function (aborted, timeout) {
  var _this = this;
    

  if (charisma.smartui.requestLogger.isEnabled()) {
    serverEventInstrumentedHandleResponse.call(_this, aborted, timeout);
  } else {
    serverEventHandleResponse.call(_this, aborted, timeout);
  }

};




//log xmlHttpRequest status
var serverEventSend = __serverEventPrototype['send'];
var serverEventSendInstrumented = function () {
  var _this = this;
    

  _this.config.headers = _this.config.headers || {};
  _this.config.headers["X-Requested-With"] = "XMLHttpRequest";
  _this.xmlHttpRequest = _this.newXmlHttpRequest();
  _this.xmlHttpRequest.open(_this.config.method, _this.config.handlerUrl, !_this.config.sync);
  for ( var headerName in _this.config.headers) {
    _this.xmlHttpRequest.setRequestHeader(headerName, _this.config.headers[headerName]);
  }

  _this.setupPollingAndTimeout();
  var body = _this.config.body || this.getParameters();
    

  _this.xmlHttpRequest.onreadystatechange = function () {
    charisma.smartui.requestLogger.trace('ServerEvent(send) ', {sessionId: Webr.Event.sessionId, eventName: _this.config.eventName, requestStatus: _this.xmlHttpRequest.status, responseText: _this.xmlHttpRequest.responseText});
  };
    

  _this.xmlHttpRequest.send(body);
};


__serverEventPrototype['send'] = function () {
  var _this = this;
    

  if (charisma.smartui.requestLogger.isEnabled()) {
    serverEventSendInstrumented.call(_this);
  } else {
    serverEventSend.call(_this);
  }

};






var verticalComboLayouter = Webr.component.VerticalLayouter['prototype'];
verticalComboLayouter.getMaxVisibleHeight = function (toUp) {
  var anchor = this.config.anchor;
  var top = anchor.offset().top;
  var padding = top - $(window).scrollTop();
  if (!toUp) {
    padding = $(window).height() - anchor.outerHeight(true) - padding;
  }

  var res = Math.max(0, padding);
  return res;
};




var bindedComboRenderer = Webr.component.BindedComboRenderer['prototype'];
bindedComboRenderer.move = function (direction, maxHeight, preffered) {
  switch (direction) {
  case Webr.component.Layouter.UP:
    this.getContainer().addClass("reversal");
    this.shadow.relayout(true);
    this.setComboContainerPositionAndHeight(this.anchorElement.offset().top - this.getContainer().outerHeight(true), maxHeight, preffered);
    this.setExtraContentPosition();
        break;

  case Webr.component.Layouter.DOWN:
    this.setComboContainerPositionAndHeight(this.anchorElement.offset().top + this.anchorElement.outerHeight(true), maxHeight, preffered);
    this.setExtraContentPosition();
        break;

  case Webr.component.Layouter.LEFT:
    this.getContainer().css({left: this.anchorElement.offset().left - this.getContainer().outerWidth() + this.anchorElement.outerWidth()});
        break;

  case Webr.component.Layouter.RIGHT:
    this.getContainer().css({left: this.anchorElement.offset().left});
  }

};


bindedComboRenderer.setComboContainerPositionAndHeight = function (top, maxHeight, preffered) {
  this.getContainer().css({top: top});
    

  if (maxHeight < this.config.minListHeight) {
    maxHeight = this.config.minListHeight;
  } else if (maxHeight > this.config.maxListHeight) {
    maxHeight = this.config.maxListHeight;
  }

    

  if (preffered >= maxHeight) {
    var maxHeight = maxHeight - this.getMainElement().outerHeight(true) - (this.extraContainer ?this.extraContainer.outerHeight() :0);
        

    this.listContainer.css({"max-height": maxHeight - 40, "overflow-y": "scroll"});
  } else {
    this.listContainer.css({"max-height": "", "overflow-y": ""});
  }

    

};


var comboRenderer = Webr.component.ComboRenderer['prototype'];
bindedComboRenderer.draw = function (dataList) {
  //have to paste all code from the method becauase of the context `this`
  var list = this.getList();
  if (!this.drawn) {
    var listContainer = this.createComboContainer();
    listContainer.append(list);
    if (this.extraContents) {
      var extras = this.createExtraContainer();
      this.extraContents.forEach(function (c) {
        extras.append(c);
      });
      listContainer.append(extras);
    }

    this.rootElement.append(listContainer);
    this.drawn = true;
    this.shadow = Webr.component.Shadow.getShadow(listContainer, "ie-combo-shadow");
    this.shadow.setTop(listContainer.offset().top);
  } else {
    list.children().remove();
  }

  dataList.forEach(function (item) {
    list.append(item.getElement());
  });
    

  if (this.listContainer.is(':visible')) {
    var comboListHeight = this.listContainer.outerHeight();
    var maxComboListHeight = comboListHeight + this.inputElement.outerHeight();
    var verticalLayouter = this.layouter.verticalLayouter;
        

    var visibleHeightDown = verticalLayouter.getMaxVisibleHeight(false);
    var visibleHeighUp = verticalLayouter.getMaxVisibleHeight(true);
    var maxVisibleHeight;
        

    var direction;
    if (visibleHeightDown >= visibleHeighUp) {
      direction = Webr.component.Layouter.DOWN;
      maxVisibleHeight = visibleHeightDown;
    } else {
      direction = Webr.component.Layouter.UP;
      maxVisibleHeight = visibleHeighUp;
    }

    this.move(direction, maxVisibleHeight, maxVisibleHeight);
  }

};
















