charisma.smartui.Filter = function (ul) {
  this.options = $(ul).find("li input:checkbox").filter(function (index) {
    return index > 0;
  });
};
charisma.smartui.Filter.lastChecked = [];
charisma.smartui.Filter.getFilter = function (filterCheckbox) {
  var filterUl = charisma.smartui.Filter.getGroupUL(filterCheckbox);
  var fieldName = "searchFilterComponent";
  var filter = filterUl[fieldName];
  if (filter == null) {
    filter = new charisma.smartui.Filter(filterUl);
    filterUl[fieldName] = filter;
  }

  return filter;
};
charisma.smartui.Filter.getGroupUL = function (filterCheckbox) {
  return filterCheckbox.parentNode.parentNode;
};
charisma.smartui.Filter.getGroupHeader = function (checkbox) {
  return $(checkbox).parent().parent().parent().children("a:first");
};
charisma.smartui.Filter.swapLastChecked = function (newlyChecked) {
  var lastClicked = charisma.smartui.Filter.lastClicked;
  //Check that both last and newly check belong to the group
  if (lastClicked && newlyChecked && charisma.smartui.Filter.getGroupUL(lastClicked) != charisma.smartui.Filter.getGroupUL(newlyChecked)) {
    lastClicked = null;
  }

  charisma.smartui.Filter.lastClicked = newlyChecked;
  return lastClicked;
};
charisma.smartui.Filter.getCheckboxRange = function (from, to) {
  var fromIndex = $(from.parentNode).index();
  var toIndex = $(to.parentNode).index();
  if (toIndex < fromIndex) {
    var buffer = toIndex;
    toIndex = fromIndex;
    fromIndex = buffer;
  }

  return $(charisma.smartui.Filter.getGroupUL(from)).children().slice(fromIndex, toIndex + 1).children("input:checkbox");
};
charisma.smartui.Filter.setFilterPopup = function (popup) {
  charisma.smartui.Filter.filterPopup = popup;
  charisma.smartui.Filter.filterPopup.hide_pause = 3000;
};
charisma.smartui.Filter.hideFilterPopup = function (hideAfterPause) {
  if (charisma.smartui.Filter.filterPopup) {
    if (hideAfterPause) {
      charisma.smartui.Filter.filterPopup.mouseOutAnchor();
    } else {
      charisma.smartui.Filter.filterPopup.hide();
    }

  }

};
charisma.smartui.Filter.showFilterPopup = function () {
  if (charisma.smartui.Filter.filterPopup) {
    charisma.smartui.Filter.filterPopup.show(false, $(charisma.smartui.Filter.lastClicked).parent().get(0));
  }

};
